package cz.cuni.amis.pogamut.episodic.decisions;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 * @author Michal Cermak
 */
public class ActionTest {

    Action instance = null;

    public ActionTest() {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testAction01() {
        instance = new Action("action",0);

        //new Action is empty
        assertTrue(instance.getAllChildrenNodes().isEmpty());
        assertTrue(instance.getAffordances().isEmpty());

        //filling the elements
        String i1name = "intention1";
        Intention i1 = new Intention(i1name,0);
        instance.addSubNode(i1);

        String aa1name = "atomic1";
        AtomicAction aa1 = new AtomicAction(aa1name,0);
        instance.addAtomicAction(aa1);

        String s1name = "slot1";
        AffordanceSlot s1 = new AffordanceSlot(s1name);
        instance.addAffordance(s1);

        //elements were filled correctly
        assertEquals(instance.getAtomicActions().size(), 1);
        assertEquals(instance.getSubNodes().size(), 1);
        assertEquals(instance.getAllChildrenNodes().size(), 2);
        assertEquals(instance.getAffordances().size(), 1);

        Node n1test = instance.getSubNode(i1name);
        assertNotNull(n1test);
        assertEquals(n1test.getName(), i1name);
        assertSame(n1test, i1);
        assertSame(instance, n1test.parent);
        
        AtomicAction aa1test = instance.getAtomicAction(aa1name);
        assertNotNull(aa1test);
        assertEquals(aa1test.getName(), aa1name);
        assertSame(aa1, aa1test);
        assertSame(instance, aa1test.parent);
        
        AffordanceSlot s1test = instance.getAffordances().iterator().next();
        assertNotNull(s1test);
        assertEquals(s1test.type, s1name);
        assertSame(s1, s1test);

        //more elements can be added and elements can be changed
        String i2name = "intention2";
        Intention i2 = new Intention(i2name,0);
        instance.addSubNode(i2);
        assertEquals(instance.getSubNodes().size(), 2);
        assertSame(i2, instance.getSubNode(i2name));

        Intention i3 = new Intention(i2name,0);
        instance.addSubNode(i3);
        assertEquals(instance.getSubNodes().size(), 2);
        assertSame(i3, instance.getSubNode(i2name));

        String aa2name = "atomic2";
        AtomicAction aa2 = new AtomicAction(aa2name,0);
        instance.addAtomicAction(aa2);
        assertEquals(instance.getAtomicActions().size(), 2);
        assertSame(aa2, instance.getAtomicAction(aa2name));

        AtomicAction aa3 = new AtomicAction(aa2name,0);
        instance.addAtomicAction(aa3);
        assertEquals(instance.getAtomicActions().size(), 2);
        assertSame(aa3, instance.getAtomicAction(aa2name));

        String s2name = "slot2";
        AffordanceSlot s2 = new AffordanceSlot(s2name);
        instance.addAffordance(s2);
        assertEquals(instance.getAffordances().size(), 2);
        assertSame(s2, instance.getAffordance(s2name));

        AffordanceSlot s3 = new AffordanceSlot(s2name);
        instance.addAffordance(s3);
        assertEquals(instance.getAffordances().size(), 2);
        assertSame(s3, instance.getAffordance(s2name));
        
        System.out.println("---/// TEST ACTION 01 OK ///---");
    }

    @Test
    public void testAction02() {
        instance = new Action("action",10);
        assertEquals(instance.getType(), NodeType.ACTION);
        assertEquals(instance.getAttractivity(), 10);

        try {
            instance.getId();
            fail("ID not set");
        } catch (Exception e) {
        }

        boolean b = instance.setId(5);
        assertTrue(b);
        assertEquals(instance.getId(), 5);
        b = instance.setId(10);
        assertFalse(b);
        assertEquals(instance.getId(), 5);

        System.out.println("---/// TEST ACTION 02 OK ///---");
    }
}