package cz.cuni.amis.pogamut.episodic.decisions;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 * @author Miso
 */
public class AtomicActionTest {

    AtomicAction instance = null;

    public AtomicActionTest() {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testAtomicAction01() {
        String aaName = "atomic";
        instance = new AtomicAction(aaName, 5);
        assertEquals(instance.getName(), aaName);
        assertEquals(instance.getAttractivity(), 5);

        assertNull(instance.getSubNode(""));
        assertTrue(instance.getAllChildrenNodes().isEmpty());
         
        System.out.println("---/// TEST ATOMIC_ACTION 01 OK ///---");
    }

    @Test
    public void testAtomicAction02() {
        instance = new AtomicAction("atomic",10);
        assertEquals(instance.getType(), NodeType.ATOMIC_ACTION);
        assertEquals(instance.getAttractivity(), 10);

        try {
            instance.getId();
            fail("ID not set");
        } catch (Exception e) {
        }

        boolean b = instance.setId(5);
        assertTrue(b);
        assertEquals(instance.getId(), 5);
        b = instance.setId(10);
        assertFalse(b);
        assertEquals(instance.getId(), 5);

        System.out.println("---/// TEST ATOMIC_ACTION 02 OK ///---");
    }
}