package cz.cuni.amis.pogamut.episodic.episodes;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 * @author Michal Cermak
 */
public class AgeIntervalTest {

    AgeInterval instance = null;

    public AgeIntervalTest() {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testAgeInterval01() {
        instance = new AgeInterval(0, 1);

        assertEquals(instance.getMinAge(), 0);
        assertEquals(instance.getMaxAge(), 1);
        
        instance.increase();
        
        assertEquals(instance.getMinAge(), 1);
        assertEquals(instance.getMaxAge(), 2);

        assertFalse(instance.intersects(new AgeInterval(-1,0)));
        assertFalse(instance.intersects(new AgeInterval(3,4)));
        assertTrue(instance.intersects(new AgeInterval(0,1)));
        assertTrue(instance.intersects(new AgeInterval(2,3)));
        assertTrue(instance.intersects(new AgeInterval(0,5)));

        assertNull(instance.join(new AgeInterval(5, 6)));
        instance = instance.join(new AgeInterval(2, 3));
        assertEquals(instance.getMinAge(), 1);
        assertEquals(instance.getMaxAge(), 3);
        instance = instance.join(new AgeInterval(0, 5));
        assertEquals(instance.getMinAge(), 0);
        assertEquals(instance.getMaxAge(), 5);

        try {
            instance = new AgeInterval(2, 1);
            fail("should throw an exception");
        } catch (RuntimeException e) {
        }

        System.out.println("---/// TEST AGE INTERVAL 01 OK ///---");
    }

}