package cz.cuni.amis.pogamut.episodic.episodes;

import cz.cuni.amis.pogamut.episodic.decisions.DecisionTree;
import cz.cuni.amis.pogamut.episodic.decisions.DecisionTreeTest;
import cz.cuni.amis.pogamut.episodic.decisions.Intention;
import cz.cuni.amis.pogamut.episodic.decisions.Node;
import cz.cuni.amis.pogamut.episodic.memory.AgentMemory;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 * @author Michal Cermak
 */
public class EpisodeNodeTest {

    Chronobag ch;
    Episode e;
    EpisodeNode instance = null;

    public EpisodeNodeTest() {
    }

    @Before
    public void setUp() {
        DecisionTree dTree = DecisionTreeTest.sampleTree(10, 2, 3);
        AgentMemory mem = new AgentMemory();
        mem.initialize(dTree.topLevelGoals.values());
        ch = new Chronobag(mem.getIdGenerator(), mem);
        e = new Episode(ch);
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testEpisodeNode01() {
        Node associated = e.getParentChronobag().getMemory().getDecisionTree().topLevelGoals.values().iterator().next();
        instance = new EpisodeNode("node", null, e, associated);
        assertEquals(instance.getName(), "node");
        assertSame(instance.getAssociatedNode(), associated);


        assertTrue(instance.children.isEmpty());
        assertFalse(instance.succeeded);
        assertEquals(instance.numberOfSubNodes, 0);
        assertEquals(instance.numberOfSubNodesWithObjects, 0);
        assertTrue(instance.slots.isEmpty());

        assertSame(instance.getEpisodeRoot(), e);

        boolean result = instance.addChildNode("child1");
        assertTrue(result);
        result = instance.addChildNode("child2");
        assertTrue(result);
        result = instance.addChildNode("child1");
        assertFalse(result);

        assertEquals(instance.getChildrenNodes().size(), 2);
        assertNotNull(instance.getChild("child1"));
        assertNotNull(instance.getChild("child2"));
        assertEquals(instance.numberOfSubNodes, 2);
        assertEquals(instance.numberOfSubNodesWithObjects, 2);

        EpisodeNode child1 = instance.getChild("child1");
        assertSame(child1.getParent(), instance);

        assertSame(instance.getFirstChild().get(e.getIdEpisode()), child1);
        assertEquals(instance.getFirstChild().size(), 1);

        EpisodeNode child2 = instance.getChild("child2");
        assertNull(child1.getPredecessor().get(e.getIdEpisode()));
        assertSame(child1.getSuccessor().get(e.getIdEpisode()), child2);
        assertSame(child2.getPredecessor().get(e.getIdEpisode()), child1);
        assertNull(child2.getSuccessor().get(e.getIdEpisode()));

        assertNull(child1.getAssociatedNode());
        String childName = ((Intention)associated).getSubNodes().iterator().next().getName();
        instance.addChildNode(childName);
        assertNotNull(instance.getChild(childName).associatedNode);
        assertSame(instance.getChild(childName).associatedNode, associated.getSubNode(childName));

        child1.addChildNode("grandchild");
        assertEquals(instance.numberOfSubNodes, 4);
        assertEquals(instance.numberOfSubNodesWithObjects, 4);

        System.out.println("---/// TEST EPISODE NODE 01 OK ///---");
    }

    @Test
    public void testEpisodeNode02() {
        //test slots
        instance = new EpisodeNode("node", null, e, null);
        instance.addSlot("type");

        assertEquals(instance.numberOfSubNodesWithObjects, 0);
        ObjectNode o1 = instance.getEpisodeRoot().getParentChronobag().createObjectNode("obj1");
        ObjectNode o2 = instance.getEpisodeRoot().getParentChronobag().createObjectNode("obj2");
        instance.fillSlot("type", "obj1");
        assertEquals(instance.numberOfSubNodesWithObjects, 1);

        instance.addChildNode("child");
        EpisodeNode child = instance.getChild("child");
        child.addSlot("type");
        child.getObjectSlot("type").addObject(instance.getEpisodeRoot().getParentChronobag().objectNodes.get("obj1"), true);
        child.fillSlot("type", "obj2");

        assertEquals(child.getObjectSlot("type").getUsedObjects().size(), 2);
        assertEquals(child.numberOfSubNodesWithObjects, 2);
        assertEquals(instance.numberOfSubNodesWithObjects, 4);

        child.getObjectSlot("type").emptySlot();
        assertTrue(child.getObjectSlot("type").getUsedObjects().isEmpty());
        assertEquals(child.numberOfSubNodesWithObjects, 0);
        assertEquals(instance.numberOfSubNodesWithObjects, 2);

        child.fillSlot("type", "obj1");
        child.fillSlot("type", "obj2");
        assertEquals(child.numberOfSubNodesWithObjects, 2);
        assertEquals(instance.numberOfSubNodesWithObjects, 4);
        assertEquals(o1.usedAt.size(), 2);
        assertTrue(o1.usedAt.contains(child.getObjectSlot("type")));

        assertNull(child.getObjectSlot("Other"));
        child.getObjectSlot("type").deleteSlot();
        assertNotNull(child.getObjectSlot("Other"));
        assertEquals(child.numberOfSubNodesWithObjects, 2);
        assertEquals(instance.numberOfSubNodesWithObjects, 4);
        assertEquals(o1.usedAt.size(), 2);
        assertTrue(o1.usedAt.contains(child.getObjectSlot("Other")));

        assertEquals(child.getObjectSlot("Other").getUsedObjects().size(), 2);
        assertTrue(child.getObjectSlot("Other").getUsedObjects().contains(o1));
        assertTrue(child.getObjectSlot("Other").getUsedObjects().contains(o2));

        child.getObjectSlot("Other").deleteSlot();
        assertNull(child.getObjectSlot("Other"));
        assertEquals(child.numberOfSubNodesWithObjects, 0);
        assertEquals(instance.numberOfSubNodesWithObjects, 2);
        assertEquals(o1.usedAt.size(), 1);
        assertFalse(o1.usedAt.contains(child.getObjectSlot("Other")));

        System.out.println("---/// TEST EPISODE NODE 02 OK ///---");
    }

    @Test
    public void testEpisodeNode03() {
        //test node merge
        Node associated = e.getParentChronobag().getMemory().getDecisionTree().topLevelGoals.values().iterator().next();
        instance = new EpisodeNode("node", null, e, associated);

        Episode e2 = new Episode(ch);
        EpisodeNode other = new EpisodeNode("node", null, e2, associated);
        assertFalse(e.getIdEpisode() == e2.getIdEpisode());

        instance.addChildNode("child1");
        instance.addChildNode("child2");
        instance.addChildNode("child3");
        EpisodeNode n = instance.getChild("child3");
        n.addSlot("slot1");
        n.addSlot("slot2");
        ObjectNode obj1 = instance.getEpisodeRoot().getParentChronobag().createObjectNode("obj1");
        ObjectNode obj2 = instance.getEpisodeRoot().getParentChronobag().createObjectNode("obj2");
        ObjectNode obj3 = instance.getEpisodeRoot().getParentChronobag().createObjectNode("obj3");
        ObjectNode obj4 = instance.getEpisodeRoot().getParentChronobag().createObjectNode("obj4");
        n.fillSlot("slot1", "obj1");
        n.fillSlot("slot1", "obj2");
        n.fillSlot("slot2", "obj3");

        assertSame(instance.numberOfCommonSubNodesWithObjects(instance.getChild("child1")), 0);
        assertSame(instance.numberOfCommonSubNodesWithObjects(other), 1);

        other.addChildNode("child3");
        other.addChildNode("child4");
        other.addChildNode("child5");
        n = other.getChild("child3");
        n.addSlot("slot1");
        n.addSlot("slot2");
        n.fillSlot("slot1", "obj1");
        n.fillSlot("slot1", "obj4");
        n.fillSlot("slot2", "obj2");

        assertSame(instance.numberOfCommonSubNodesWithObjects(other), 3);

        assertEquals(instance.numberOfSubNodes, 3);
        assertEquals(instance.numberOfSubNodesWithObjects, 6);
        
        instance.mergeWith(other);

        assertEquals(instance.numberOfSubNodes, 5);
        assertEquals(instance.numberOfSubNodesWithObjects, 10);

        assertEquals(instance.getChildrenNodes().size(), 5);
        EpisodeNode child1 = instance.getChild("child1");
        EpisodeNode child3 = instance.getChild("child3");
        assertSame(child1, instance.getFirstChild().get(e.getIdEpisode()));
        assertSame(child3, instance.getFirstChild().get(e2.getIdEpisode()));
        assertSame(instance.getChild("child2"), child1.getSuccessor().get(e.idEpisode));
        assertSame(instance.getChild("child3"), child1.getSuccessor().get(e.idEpisode).getSuccessor().get(e.idEpisode));
        assertNull(child1.getSuccessor().get(e.idEpisode).getSuccessor().get(e.idEpisode).getSuccessor().get(e.idEpisode));
        assertSame(instance.getChild("child4"), child3.getSuccessor().get(e2.idEpisode));
        assertSame(instance.getChild("child5"), child3.getSuccessor().get(e2.idEpisode).getSuccessor().get(e2.idEpisode));
        assertNull(child3.getSuccessor().get(e2.idEpisode).getSuccessor().get(e2.idEpisode).getSuccessor().get(e2.idEpisode));
        assertTrue(child1.getPredecessor().isEmpty());
        assertSame(child3.getPredecessor().get(e.idEpisode), instance.getChild("child2"));

        assertEquals(child3.slots.size(), 2);
        assertTrue(child3.slots.get("slot1").getUsedObjects().contains(obj1));
        assertTrue(child3.slots.get("slot1").getUsedObjects().contains(obj2));
        assertTrue(child3.slots.get("slot1").getUsedObjects().contains(obj4));
        assertEquals(child3.slots.get("slot1").getUsedObjects().size(), 3);
        assertTrue(child3.slots.get("slot2").getUsedObjects().contains(obj2));
        assertTrue(child3.slots.get("slot2").getUsedObjects().contains(obj3));
        assertEquals(child3.slots.get("slot2").getUsedObjects().size(), 2);

        assertEquals(obj1.usedAt.size(), 1);
        assertEquals(obj2.usedAt.size(), 2);
        assertEquals(obj3.usedAt.size(), 1);
        assertEquals(obj4.usedAt.size(), 1);
        
        System.out.println("---/// TEST EPISODE NODE 03 OK ///---");
    }

    @Test
    public void TestEpisodeNode04() {
        Node associated = e.getParentChronobag().getMemory().getDecisionTree().topLevelGoals.values().iterator().next();
        instance = new EpisodeNode(associated.getName(), null, e, associated);

        ObjectNode obj1 = instance.getEpisodeRoot().getParentChronobag().createObjectNode("obj1");
        ObjectNode obj2 = instance.getEpisodeRoot().getParentChronobag().createObjectNode("obj2");
        ObjectNode obj3 = instance.getEpisodeRoot().getParentChronobag().createObjectNode("obj3");
        ObjectNode obj4 = instance.getEpisodeRoot().getParentChronobag().createObjectNode("obj4");

        instance.addChildNode("child1");
        instance.addChildNode("child2");
        instance.addChildNode("child3");
        instance.addSlot("slot");
        instance.fillSlot("slot", "obj1");
        instance.fillSlot("slot", "obj2");
        EpisodeNode n = instance.getChild("child3");
        n.addSlot("slot1");
        n.addSlot("slot2");
        n.fillSlot("slot1", "obj3");
        n.fillSlot("slot2", "obj4");

        assertEquals(obj1.usedAt.size(), 1);
        assertEquals(obj2.usedAt.size(), 1);
        assertEquals(obj3.usedAt.size(), 1);
        assertEquals(obj4.usedAt.size(), 1);

        n = instance.createCopy(null, e);

        assertSame(instance.getAssociatedNode(), n.getAssociatedNode());
        assertNotSame(instance, n);
        assertSame(instance.numberOfSubNodesWithObjects + 1, instance.numberOfCommonSubNodesWithObjects(n));

        assertNotSame(instance.getChild("child1"), n.getChild("child1"));

        assertEquals(obj1.usedAt.size(), 2);
        assertEquals(obj2.usedAt.size(), 2);
        assertEquals(obj3.usedAt.size(), 2);
        assertEquals(obj4.usedAt.size(), 2);

        

        System.out.println("---/// TEST EPISODE NODE 04 OK ///---");
    }

    @Test
    public void TestEpisodeNode05() {
        Node associated = e.getParentChronobag().getMemory().getDecisionTree().topLevelGoals.values().iterator().next();
        instance = new EpisodeNode("node", null, e, associated);

        instance.addChildNode("child1");
        instance.addChildNode("child2");
        instance.addChildNode("child3");

        assertTrue(instance.getChild("child1").getPredecessor().isEmpty());
        assertTrue(instance.getChild("child1").getSuccessor().size() == 1);
        assertTrue(instance.getChild("child2").getPredecessor().size() == 1);
        assertTrue(instance.getChild("child2").getSuccessor().size() == 1);
        assertTrue(instance.getChild("child3").getPredecessor().size() == 1);
        assertTrue(instance.getChild("child3").getSuccessor().isEmpty());
        assertSame(instance.getChild("child1").getSuccessor().get(e.getIdEpisode()), instance.getChild("child2"));
        assertSame(instance.getChild("child2").getPredecessor().get(e.getIdEpisode()), instance.getChild("child1"));
        assertSame(instance.getChild("child2").getSuccessor().get(e.getIdEpisode()), instance.getChild("child3"));
        assertSame(instance.getChild("child3").getPredecessor().get(e.getIdEpisode()), instance.getChild("child2"));

        instance.getChild("child2").deleteNode();

        assertEquals(instance.children.size(), 2);
        assertNotNull(instance.getChild("child1"));
        assertNotNull(instance.getChild("child3"));

        assertTrue(instance.getChild("child1").getPredecessor().isEmpty());
        assertTrue(instance.getChild("child1").getSuccessor().size() == 1);
        assertTrue(instance.getChild("child3").getPredecessor().size() == 1);
        assertTrue(instance.getChild("child3").getSuccessor().isEmpty());

        assertSame(instance.getChild("child1").getSuccessor().get(e.getIdEpisode()), instance.getChild("child3"));
        assertSame(instance.getChild("child3").getPredecessor().get(e.getIdEpisode()), instance.getChild("child1"));

        instance.getChild("child3").deleteNode();

        assertEquals(instance.children.size(), 1);
        assertNotNull(instance.getChild("child1"));

        assertTrue(instance.getChild("child1").getPredecessor().isEmpty());
        assertTrue(instance.getChild("child1").getSuccessor().isEmpty());


        System.out.println("---/// TEST EPISODE NODE 05 OK ///---");
    }

    @Test
    public void TestEpisodeNode06() {
        Node associated = e.getParentChronobag().getMemory().getDecisionTree().topLevelGoals.values().iterator().next();
        instance = new EpisodeNode(associated.getName(), null, e, associated);

        instance.addChildNode("child1");
        instance.addChildNode("child2");
        instance.addChildNode("child3");
        instance.addChildNode("child4");

        EpisodeNode n = instance.getChild("child1");
        n.addChildNode("child3");

        n.deleteNode();

        assertTrue(instance.validateNode(instance));
        assertEquals(instance.children.size(), 3);
        assertTrue(instance.validateNode(instance.children.values()));

        instance.addChildNode("child5");
        n = instance.getChild("child5");
        n.addChildNode("child3");

        n.deleteNode();

        assertTrue(instance.validateNode(instance));
        assertEquals(instance.children.size(), 3);
        assertTrue(instance.validateNode(instance.children.values()));

        n = instance.getChild("child2");
        n.deleteNode();
        n = instance.getChild("child3");
        n.deleteNode();
        n = instance.getChild("child4");
        n.deleteNode();
        
        assertTrue(instance.validateNode(instance));
        assertEquals(instance.children.size(), 0);

        instance.addChildNode("child1");
        instance.addChildNode("child2");
        instance.addChildNode("child3");
        instance.addChildNode("child4");

        n = instance.getChild("child2");
        n.addChildNode("child4");
        n.deleteNode();

        assertTrue(instance.validateNode(instance));
        assertEquals(instance.children.size(), 3);
        assertTrue(instance.validateNode(instance.children.values()));

        n = instance.getChild("child1");
        n.deleteNode();
        n = instance.getChild("child3");
        n.deleteNode();
        n = instance.getChild("child4");
        n.deleteNode();

        assertTrue(instance.validateNode(instance));
        assertEquals(instance.children.size(), 0);

        instance.addChildNode("child1");
        instance.addChildNode("child2");
        instance.addChildNode("child3");
        instance.addChildNode("child4");

        n = instance.getChild("child3");
        n.addChildNode("child1");
        n.deleteNode();

        assertTrue(instance.validateNode(instance));
        assertEquals(instance.children.size(), 3);
        assertTrue(instance.validateNode(instance.children.values()));

        n = instance.getChild("child1");
        n.deleteNode();
        n = instance.getChild("child2");
        n.deleteNode();
        n = instance.getChild("child4");
        n.deleteNode();
        
        assertTrue(instance.validateNode(instance));
        assertEquals(instance.children.size(), 0);

        instance.addChildNode("child1");
        instance.addChildNode("child2");
        instance.addChildNode("child3");
        instance.addChildNode("child4");

        n = instance.getChild("child2");
        n.addChildNode("child3");
        n.deleteNode();

        assertTrue(instance.validateNode(instance));
        assertEquals(instance.children.size(), 3);
        assertTrue(instance.validateNode(instance.children.values()));

        n = instance.getChild("child1");
        n.deleteNode();
        n = instance.getChild("child3");
        n.deleteNode();
        n = instance.getChild("child4");
        n.deleteNode();

        assertTrue(instance.validateNode(instance));
        assertEquals(instance.children.size(), 0);

        instance.addChildNode("child1");
        instance.addChildNode("child2");
        instance.addChildNode("child3");
        instance.addChildNode("child4");

        n = instance.getChild("child2");
        n.addChildNode("child1");
        n.deleteNode();

        assertTrue(instance.validateNode(instance));
        assertEquals(instance.children.size(), 3);
        assertTrue(instance.validateNode(instance.children.values()));

        n = instance.getChild("child1");
        n.deleteNode();
        n = instance.getChild("child3");
        n.deleteNode();
        n = instance.getChild("child4");
        n.deleteNode();

        assertTrue(instance.validateNode(instance));
        assertEquals(instance.children.size(), 0);

        instance.addChildNode("child1");
        instance.addChildNode("child2");
        instance.addChildNode("child3");
        instance.addChildNode("child4");

        n = instance.getChild("child3");
        n.addChildNode("child4");
        n.deleteNode();

        assertTrue(instance.validateNode(instance));
        assertEquals(instance.children.size(), 3);
        assertTrue(instance.validateNode(instance.children.values()));

        n = instance.getChild("child1");
        n.deleteNode();
        n = instance.getChild("child2");
        n.deleteNode();
        n = instance.getChild("child4");
        n.deleteNode();

        assertTrue(instance.validateNode(instance));
        assertEquals(instance.children.size(), 0);

        instance.addChildNode("child1");
        instance.addChildNode("child2");
        instance.addChildNode("child3");
        instance.addChildNode("child4");

        n = instance.getChild("child1");
        n.addChildNode("child2");
        n.deleteNode();

        assertTrue(instance.validateNode(instance));
        assertEquals(instance.children.size(), 3);
        assertTrue(instance.validateNode(instance.children.values()));

        n = instance.getChild("child2");
        n.deleteNode();
        n = instance.getChild("child3");
        n.deleteNode();
        n = instance.getChild("child4");
        n.deleteNode();

        assertTrue(instance.validateNode(instance));
        assertEquals(instance.children.size(), 0);

        instance.addChildNode("child1");
        instance.addChildNode("child2");
        instance.addChildNode("child3");
        instance.addChildNode("child4");

        n = instance.getChild("child4");
        n.addChildNode("child3");
        n.deleteNode();

        assertTrue(instance.validateNode(instance));
        assertEquals(instance.children.size(), 3);
        assertTrue(instance.validateNode(instance.children.values()));

        System.out.println("---/// TEST EPISODE NODE 06 OK ///---");
    }

    @Test
    public void TestEpisodeNode07() {
        //tests deriving node trace
        Node associated = e.getParentChronobag().getMemory().getDecisionTree().topLevelGoals.values().iterator().next();
        instance = new EpisodeNode(associated.getName(), null, e, associated);

        instance.addChildNode("action.1.0");
        instance.addChildNode("action.1.1");
        instance.addChildNode("action.1.2");

        EpisodeNode child2 = instance.getChild("action.1.1");
        child2.addChildNode("intention.1.0");
        child2.addChildNode("intention.1.1");
        child2.addChildNode("intention.1.2");

        assertEquals(instance.numberOfSubNodes, 6);
        child2.deleteNode();

        assertEquals(instance.children.size(), 5);
        assertEquals(instance.numberOfSubNodes, 5);
        assertFalse(instance.children.containsKey("action.1.1"));
        
        EpisodeNode grandChild = instance.getChild("intention.1.0");
        grandChild.deriveNodeTrace();

        assertTrue(instance.children.containsKey("action.1.1"));
        assertFalse(instance.children.containsKey("intention.1.0"));
        assertEquals(instance.children.size(), 5);
        assertEquals(instance.numberOfSubNodes, 6);

        child2 = instance.getChild("action.1.1");
        assertEquals(child2.children.size(), 1);
        assertTrue(child2.children.containsKey("intention.1.0"));

        grandChild = instance.getChild("intention.1.1");
        grandChild.deriveNodeTrace();

        assertTrue(instance.children.containsKey("action.1.1"));
        assertFalse(instance.children.containsKey("intention.1.1"));
        assertEquals(instance.children.size(), 4);
        assertEquals(instance.numberOfSubNodes, 6);
        assertEquals(child2.children.size(), 2);
        assertTrue(child2.children.containsKey("intention.1.0"));
        assertTrue(child2.children.containsKey("intention.1.1"));
        
        System.out.println("---/// TEST EPISODE NODE 07 OK ///---");
    }

}