package cz.cuni.amis.pogamut.episodic.episodes;

import cz.cuni.amis.pogamut.episodic.decisions.DecisionTree;
import cz.cuni.amis.pogamut.episodic.decisions.DecisionTreeTest;
import cz.cuni.amis.pogamut.episodic.memory.AffordanceUsed;
import cz.cuni.amis.pogamut.episodic.memory.AgentMemory;
import java.util.ArrayList;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 * @author Michal Cermak
 */
public class EpisodeTest {

    Chronobag ch = null;
    Episode instance = null;

    public EpisodeTest() {
    }

    @Before
    public void setUp() {
        DecisionTree dTree = DecisionTreeTest.sampleTree(10, 2, 3);
        AgentMemory mem = new AgentMemory();
        mem.initialize(dTree.topLevelGoals.values());
        ch = new Chronobag(mem.getIdGenerator(), mem);
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testEpisode01() {
        //add new node test
        instance = new Episode(ch);
        assertFalse(instance.deleted);
        assertFalse(instance.finished);
        assertSame(instance.getParentChronobag(), ch);

        ArrayList<String> trace = new ArrayList<String>();
        trace.add("intention.2.0");
        trace.add("action.1.0");
        trace.add("intention.1.0");
        trace.add("action.0.0");
        ArrayList<AffordanceUsed> affs = new ArrayList<AffordanceUsed>();
        
        instance.addNewNode("atomic.0.0", trace, affs);

        assertEquals(instance.getRoot().getName(), "intention.2.0");
        assertSame(instance.getRoot().getAssociatedNode(), ch.getMemory().getDecisionTree().topLevelGoals.get("intention.2.0"));
        EpisodeNode n = instance.getRoot();
        n = n.getChild("action.1.0").getChild("intention.1.0").getChild("action.0.0").getChild("atomic.0.0");
        assertNotNull(n.getAssociatedNode());

        affs.add(new AffordanceUsed("action.1.0", "type", "obj1"));

        instance.addNewNode("atomic.0.0", trace, affs);

        n = instance.getRoot().getChild("action.1.0");

        assertEquals(n.getObjectSlot("type").getUsedObjects().size(), 1);
        assertEquals(n.getObjectSlot("type").getUsedObjects().iterator().next().getName(), "obj1");

        assertEquals(instance.getRoot().numberOfSubNodes, 4);
        assertEquals(instance.getRoot().numberOfSubNodesWithObjects, 5);

        trace.clear();
        trace.add("intention.2.0");
        trace.add("action.1.1");
        trace.add("intention.1.0");
        trace.add("action.0.0");

        affs.clear();
        affs.add(new AffordanceUsed("intention.2.0", "type", "obj2"));

        instance.addNewNode("atomic.0.0", trace, affs);

        assertEquals(instance.getRoot().numberOfSubNodes, 8);
        assertEquals(instance.getRoot().numberOfSubNodesWithObjects, 10);

        //finishing nodes
        ArrayList<String> trace2 = new ArrayList<String>(trace);
        trace2.add("atomic.0.0");
        boolean result;
        result = instance.finishNode("atomic.0.0", trace2, true);
        assertTrue(result);
        trace2.addAll(trace);
        result = instance.finishNode("action.0.0", trace2, false);
        assertTrue(result);

        n = instance.getRoot().getChild("action.1.1").getChild("intention.1.0").getChild("action.0.0");
        assertTrue(n.finished);
        assertFalse(n.succeeded);
        n = n.getChild("atomic.0.0");
        assertTrue(n.finished);
        assertTrue(n.succeeded);

        //inconsistent root
        trace.clear();
        trace.add("intention.2.1");
        trace.add("action.1.1");
        trace.add("intention.1.0");
        trace.add("action.0.0");

        try {
            instance.addNewNode("atomic.0.0", trace, affs);
            fail();
        } catch (Exception e) {
        }

        assertEquals(instance.getRoot().numberOfSubNodes, 8);
        assertEquals(instance.getRoot().numberOfSubNodesWithObjects, 10);

        //adding non-associated nodes
        trace.clear();
        trace.add("intention.2.0");
        trace.add("action.x.x");

        affs.clear();

        instance.addNewNode("atomic.x", trace, affs);

        n = instance.getRoot().getChild("action.x.x");
        assertNotNull(n);
        assertNull(n.associatedNode);
        n = n.getChild("atomic.x");
        assertNotNull(n);
        assertNull(n.associatedNode);

        assertFalse(instance.finished);
        trace.clear();
        trace.add("intention.2.0");
        instance.finishNode("intention.2.0", trace, true);
        assertTrue(instance.finished);

        System.out.println("---/// TEST EPISODE 01 OK ///---");
    }

    @Test
    public void testEpisode02() {
        //create copy test
        instance = new Episode(ch);

        ArrayList<String> trace = new ArrayList<String>();
        trace.add("intention.2.0");
        trace.add("action.1.0");
        trace.add("intention.1.0");
        trace.add("action.0.0");
        ArrayList<AffordanceUsed> affs = new ArrayList<AffordanceUsed>();

        affs.add(new AffordanceUsed("action.1.0", "type", "obj1"));

        instance.addNewNode("atomic.0.0", trace, affs);

        trace.clear();
        trace.add("intention.2.0");
        trace.add("action.x.x");

        affs.clear();

        instance.addNewNode("atomic.x", trace, affs);

        Episode copy = instance.createCopy(null);

        assertNotNull(copy);
        assertNotSame(instance, copy);
        assertEquals(instance.getIdEpisode(), copy.getIdEpisode());
        assertNull(copy.getParentChronobag());

        assertNotSame(instance.getRoot(), copy.getRoot());
        assertEquals(instance.getRoot().getName(), copy.getRoot().getName());
        assertFalse(instance.getRoot().getId() == copy.getRoot().getId());
        assertSame(instance.getRoot().getAssociatedNode(), copy.getRoot().getAssociatedNode());

        EpisodeNode n1 = instance.getRoot().getChild("action.1.0");
        EpisodeNode n2 = copy.getRoot().getChild("action.1.0");

        assertNotSame(n1, n2);
        assertEquals(n1.getName(), n2.getName());
        assertFalse(n1.getId() == n2.getId());
        assertSame(n1.getAssociatedNode(), n2.getAssociatedNode());

        assertEquals(n1.getObjectSlots().size(), n2.getObjectSlots().size());
        assertEquals(n1.getObjectSlot("type").getUsedObjects().size(), n2.getObjectSlot("type").getUsedObjects().size());
        assertSame(n1.getObjectSlot("type").getUsedObjects().iterator().next(), n2.getObjectSlot("type").getUsedObjects().iterator().next());

        assertEquals(instance.getParentChronobag().objectNodes.get("obj1").usedAt.size(), 2);
        
        System.out.println("---/// TEST EPISODE 02 OK ///---");
    }
}