package cz.cuni.amis.pogamut.episodic.schemas;

import cz.cuni.amis.pogamut.episodic.decisions.Action;
import cz.cuni.amis.pogamut.episodic.decisions.DecisionTree;
import cz.cuni.amis.pogamut.episodic.decisions.DecisionTreeTest;
import cz.cuni.amis.pogamut.episodic.decisions.Intention;
import cz.cuni.amis.pogamut.episodic.memory.AffordanceUsed;
import cz.cuni.amis.pogamut.episodic.memory.AgentMemory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 * @author Michal Cermak
 */
public class SchemaBagTest {

    DecisionTree dTree = null;
    SchemaBag instance = null;

    public SchemaBagTest() {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testSchemaBag01() {
        AgentMemory mem = new AgentMemory();
        instance = new SchemaBag(mem.getIdGenerator(), mem);

        assertTrue(instance.counters.isEmpty());
        assertSame(instance.memory, mem);
        assertSame(instance.idGenerator, mem.getIdGenerator());
        assertTrue(instance.schemaENodes.isEmpty());
        assertTrue(instance.schemaONodes.isEmpty());

        assertEquals(instance.getNumberOfNodes(), 0);

        System.out.println("---/// TEST SCHEMA BAG 01 OK ///---");
    }

    @Test
    public void testSchemaBag02() {
        AgentMemory mem = new AgentMemory();
        instance = new SchemaBag(mem.getIdGenerator(), mem);

        Collection<SchemaCounter> col = null;
        Collection<SchemaEpisodeNode> cole = new HashSet<SchemaEpisodeNode>();
        Collection<SlotContent> colc = new HashSet<SlotContent>();

        col = instance.getAllExistingSubSets(cole, colc, 0);
        assertTrue(col.isEmpty());
        col = instance.getAllExistingSubSets(cole, colc, 1);
        assertTrue(col.isEmpty());

        Intention n1 = new Intention("intention1",0);
        Intention n2 = new Intention("intention2",0);
        Action n3 = new Action("action1",0);
        Action n4 = new Action("action2",0);

        SchemaEpisodeNode node1 = new SchemaEpisodeNode(n1, 1, "n1");
        SchemaEpisodeNode node2 = new SchemaEpisodeNode(n2, 2, "n2");
        SchemaEpisodeNode node3 = new SchemaEpisodeNode(n3, 3, "n3");
        SchemaEpisodeNode node4 = new SchemaEpisodeNode(n4, 4, "n4");

        cole.add(node1);
        cole.add(node2);
        cole.add(node3);
        cole.add(node4);

        SchemaSlot slot1 = new SchemaSlot(1,"type1");
        SchemaSlot slot2 = new SchemaSlot(2,"type2");
        SchemaObjectNode obj1 = new SchemaObjectNode(3, "object1");
        SchemaObjectNode obj2 = new SchemaObjectNode(4, "object2");

        SlotContent content11 = new SlotContent(5, slot1, obj1);
        SlotContent content12 = new SlotContent(6, slot1, obj2);
        SlotContent content21 = new SlotContent(7, slot2, obj1);
        SlotContent content22 = new SlotContent(8, slot2, obj2);

        colc.add(content11);
        colc.add(content12);
        colc.add(content21);
        colc.add(content22);

        assertEquals(instance.counters.totalSize(), 0);

        instance.increaseCounts(cole, colc, 8);

        assertEquals(instance.counters.totalSize(), (int)Math.pow(2, 8) - 1);

        col = instance.getAllExistingSubSets(cole, colc, 0);
        assertTrue(col.isEmpty());

        col = instance.getAllExistingSubSets(cole, colc, 1);
        assertEquals(col.size(), colc.size() + cole.size());

        col = instance.getAllExistingSubSets(cole, colc, 2);
        assertEquals(col.size(), colc.size() + cole.size() + (colc.size() + cole.size()) * (colc.size() + cole.size() - 1) / 2);

        col = instance.getAllExistingSubSets(cole, colc, 8);
        assertEquals(col.size(), (int)Math.pow(2, 8) - 1);

        System.out.println("---/// TEST SCHEMA BAG 02 OK ///---");
    }

    @Test
    public void testSchemaBag03() {
        //test instance.updateSchema method
        AgentMemory mem = new AgentMemory();
        dTree = DecisionTreeTest.sampleTree(15, 2, 5);
        assertNotNull(dTree);
        mem.initialize(dTree.topLevelGoals.values());
        instance = new SchemaBag(mem.getIdGenerator(), mem);

        ArrayList<String> trace = new ArrayList<String>();
        trace.add("intention.2.0");
        trace.add("action.1.0");
        trace.add("intention.1.0");
        trace.add("action.0.0");
        ArrayList<AffordanceUsed> affs = new ArrayList<AffordanceUsed>();
        affs.add(new AffordanceUsed("intention.2.0","intention.2.0-slot","objectName"));
        instance.updateSchema("atomic.0.0", trace, affs);
        instance.updateSchema("atomic.0.0", trace, affs);

        SchemaEpisodeNode node = mem.getDecisionTree().topLevelGoals.get("intention.2.0").getAssociatedNode();
        assertEquals(node.getSingleCount(), (Integer)1);
        assertEquals(node.getCounts().get(0).size(), 1);
        assertEquals(node.getCounts().get(0).iterator().next().getCount(), 1);
        assertEquals(node.getCounts().get(0).iterator().next().getTotalCount(), 2);

        Collection<SchemaObjectNode> colo = instance.getSchemaONodes();
        assertEquals(colo.size(), 1);
        assertTrue(colo.iterator().next().getName().equals("objectName"));
        assertEquals(colo.iterator().next().getSlotContents().size(), 1);
        SlotContent content = colo.iterator().next().getSlotContents().iterator().next();

        assertEquals(content.getCounts().get(0).size(), 1);
        assertEquals(content.getCounts().get(0).iterator().next().getCount(), 1);
        assertEquals(content.getCounts().get(0).iterator().next().getTotalCount(), 2);

        Collection<SchemaCounter> counters = content.getCounts().get(node.getId());
        SchemaCounter counter = null;
        for (SchemaCounter c : counters) {
            if (c.checkNode(node.getId())) counter = c;
        }
        assertNotNull(counter);
        assertEquals(counter.getContentsNodes().size(), 1);
        assertEquals(counter.getENodes().size(), 1);
        assertSame(counter.getContentsNodes().iterator().next(), content);
        assertSame(counter.getENodes().iterator().next(), node);

        assertEquals(counter.getCount(), 1);
        assertEquals(counter.getTotalCount(), 2);
        
        System.out.println("---/// TEST SCHEMA BAG 03 OK ///---");
    }

    @Test
    public void testSchemaBag04() {
        //test two counters with same hash
        AgentMemory mem = new AgentMemory();
        instance = new SchemaBag(mem.getIdGenerator(), mem);
        
        Collection<SchemaEpisodeNode> cole = new HashSet<SchemaEpisodeNode>();
        Collection<SlotContent> colc = new HashSet<SlotContent>();

        Intention n1 = new Intention("intention1",0);
        Action n2 = new Action("action2",0);

        SchemaEpisodeNode node1 = new SchemaEpisodeNode(n1, 1, "n1");
        SchemaEpisodeNode node2 = new SchemaEpisodeNode(n2, 2, "n2");
        cole.add(node1);
        cole.add(node2);

        SchemaSlot slot1 = new SchemaSlot(0,"type1");
        SchemaSlot slot2 = new SchemaSlot(0,"type2");
        SchemaObjectNode obj1 = new SchemaObjectNode(0, "object1");
        SlotContent content1= new SlotContent(6, slot1, obj1);
        SlotContent content2 = new SlotContent(7, slot2, obj1);
        colc.add(content1);
        colc.add(content2);

        instance.increaseCounts(cole, colc, 2);

        colc.remove(content1);
        cole.remove(node2);

        SchemaCounter counter = instance.getCounter(cole, colc, 2);
        assertEquals(counter.key, 8);
        assertTrue(counter.getContentsNodes().contains(content2));
        assertEquals(counter.getContentsNodes().size(), 1);
        assertTrue(counter.getENodes().contains(node1));
        assertEquals(counter.getENodes().size(), 1);

        colc.remove(content2);
        colc.add(content1);
        cole.remove(node1);
        cole.add(node2);

        counter = instance.getCounter(cole, colc, 2);
        assertEquals(counter.key, 8);
        assertTrue(counter.getContentsNodes().contains(content1));
        assertEquals(counter.getContentsNodes().size(), 1);
        assertTrue(counter.getENodes().contains(node2));
        assertEquals(counter.getENodes().size(), 1);

        System.out.println("---/// TEST SCHEMA BAG 04 OK ///---");
    }
}