package cz.cuni.amis.pogamut.episodic.schemas;

import cz.cuni.amis.pogamut.episodic.decisions.Action;
import cz.cuni.amis.pogamut.episodic.decisions.Intention;
import java.util.Collection;
import java.util.HashSet;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 * @author Michal Cermak
 */
public class SchemaCounterTest {

    SchemaCounter instance = null;

    public SchemaCounterTest() {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testSchemaCounter01() {
        Collection<SchemaEpisodeNode> cole = new HashSet<SchemaEpisodeNode>();
        Collection<SlotContent> colc = new HashSet<SlotContent>();
        instance = new SchemaCounter(0, cole, colc);

        assertEquals(instance.key, 0);
        assertEquals(instance.getCount(), 0);
        assertEquals(instance.getTotalCount(), 0);

        assertTrue(instance.getContentsNodes().isEmpty());
        assertTrue(instance.getENodes().isEmpty());

        System.out.println("---/// TEST SCHEMA COUNTER 01 OK ///---");
    }

    @Test
    public void testSchemaCounter02() {
        Intention n1 = new Intention("intention1",0);
        Intention n2 = new Intention("intention2",0);
        Action n3 = new Action("action1",0);
        Action n4 = new Action("action2",0);

        SchemaEpisodeNode node1 = new SchemaEpisodeNode(n1, 1, "n1");
        SchemaEpisodeNode node2 = new SchemaEpisodeNode(n2, 2, "n2");
        SchemaEpisodeNode node3 = new SchemaEpisodeNode(n3, 3, "n3");
        SchemaEpisodeNode node4 = new SchemaEpisodeNode(n4, 4, "n4");
        
        SchemaSlot slot1 = new SchemaSlot(1,"type1");
        SchemaSlot slot2 = new SchemaSlot(2,"type2");

        SchemaObjectNode obj1 = new SchemaObjectNode(3, "object1");
        SchemaObjectNode obj2 = new SchemaObjectNode(4, "object2");

        SlotContent content11 = new SlotContent(5, slot1, obj1);
        SlotContent content12 = new SlotContent(6, slot1, obj2);
        SlotContent content21 = new SlotContent(7, slot2, obj1);
        SlotContent content22 = new SlotContent(8, slot2, obj2);
        
        Collection<SchemaEpisodeNode> cole = new HashSet<SchemaEpisodeNode>();
        Collection<SlotContent> colc = new HashSet<SlotContent>();        
        cole.add(node1);
        cole.add(node2);
        cole.add(node3);
        cole.add(node4);
        colc.add(content11);
        colc.add(content12);
        colc.add(content21);
        colc.add(content22);

        int hash = node1.id + node2.id + node3.id + node4.id;
        hash += content11.id + content12.id + content21.id + content22.id;

        instance = new SchemaCounter(hash, cole, colc);

        assertTrue(instance.checkNode(node1.getId()));
        assertTrue(instance.checkNode(node2.getId()));
        assertTrue(instance.checkNode(node3.getId()));
        assertTrue(instance.checkNode(node4.getId()));

        assertTrue(instance.checkNode(content11.getId()));
        assertTrue(instance.checkNode(content12.getId()));
        assertTrue(instance.checkNode(content21.getId()));
        assertTrue(instance.checkNode(content22.getId()));

        assertTrue(instance.checkNodes(cole, colc));

        Collection<Integer> col = new HashSet<Integer>();

        col.add(node1.getId());
        assertFalse(instance.checkNodes(col));
        col.add(node2.getId());
        col.add(node3.getId());
        col.add(node4.getId());
        assertFalse(instance.checkNodes(col));
        col.add(content11.getId());
        col.add(content12.getId());
        col.add(content21.getId());
        assertFalse(instance.checkNodes(col));
        col.add(content22.getId());
        assertTrue(instance.checkNodes(col));

        col.add(-1);
        assertFalse(instance.checkNodes(col));
        assertFalse(instance.checkNode(0));

        colc.remove(content11);
        assertFalse(instance.checkNodes(cole, colc));
        colc.add(content11);
        assertTrue(instance.checkNodes(cole, colc));
        cole.remove(node1);
        assertFalse(instance.checkNodes(cole, colc));     

        System.out.println("---/// TEST SCHEMA COUNTER 02 OK ///---");
    }
}