package cz.cuni.amis.pogamut.episodic.schemas;

import cz.cuni.amis.pogamut.episodic.decisions.Action;
import cz.cuni.amis.pogamut.episodic.decisions.Intention;
import java.util.Collection;
import java.util.HashSet;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 * @author Michal Cermak
 */
public class SchemaEpisodeNodeTest {

    SchemaEpisodeNode instance = null;

    public SchemaEpisodeNodeTest() {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testSchemaEpisodeNode01() {
        Intention intention = new Intention("intention",0);
        instance = new SchemaEpisodeNode(intention, 1, "SchemaEpisodeNode1");

        assertSame(instance.getAssociatedNode(), intention);
        assertSame(intention.getAssociatedNode(), instance);

        assertEquals(instance.getId(), 1);
        assertEquals(instance.getName(), "SchemaEpisodeNode1");
        assertNull(instance.getParentSchemaNode());
        assertTrue(instance.getChildrenSchemaNodes().isEmpty());

        Action action1 = new Action("action1",0);
        intention.addSubNode(action1);
        SchemaEpisodeNode node2 = new SchemaEpisodeNode(action1, 2, "SchemaEpisodeNode2");
        
        assertEquals(instance.getChildrenSchemaNodes().size(), 1);
        assertSame(node2.getParentSchemaNode(), instance);

        Action action2 = new Action("action2",0);
        intention.addSubNode(action2);
        SchemaEpisodeNode node3 = new SchemaEpisodeNode(action2, 3, "SchemaEpisodeNode3");

        assertEquals(instance.getChildrenSchemaNodes().size(), 2);
        assertSame(node3.getParentSchemaNode(), instance);
        assertTrue(instance.getChildrenSchemaNodes().contains(node2));
        assertTrue(instance.getChildrenSchemaNodes().contains(node3));

        assertTrue(instance.getSlots().isEmpty());
        boolean result;
        result = instance.addSlot("slot1", 4);
        assertTrue(result);
        result = instance.addSlot("slot2", 5);
        assertTrue(result);
        result = instance.addSlot("slot2", 6);
        assertFalse(result);

        assertEquals(instance.getSlots().size(), 2);
        assertEquals(instance.getSlot("slot1").getId(),4);
        assertEquals(instance.getSlot("slot2").getId(),5);

        System.out.println("---/// TEST SCHEMA EPISODE NODE 01 OK ///---");
    }

    @Test
    public void testSchemaEpisodeNode02() {
        Intention n1 = new Intention("intention1",0);
        Intention n2 = new Intention("intention2",0);
        Action n3 = new Action("action1",0);
        Action n4 = new Action("action2",0);

        SchemaEpisodeNode node1 = new SchemaEpisodeNode(n1, 1, "n1");
        SchemaEpisodeNode node2 = new SchemaEpisodeNode(n2, 2, "n2");
        SchemaEpisodeNode node3 = new SchemaEpisodeNode(n3, 3, "n3");
        SchemaEpisodeNode node4 = new SchemaEpisodeNode(n4, 4, "n4");

        SchemaSlot slot = new SchemaSlot(5,"type");

        SchemaObjectNode obj = new SchemaObjectNode(6, "object");

        SlotContent content = new SlotContent(5, slot, obj);

        Collection<SchemaEpisodeNode> col1 = new HashSet<SchemaEpisodeNode>();
        col1.add(node1);

        Collection<SchemaEpisodeNode> col2 = new HashSet<SchemaEpisodeNode>();
        col2.add(node1);
        col2.add(node2);
        col2.add(node3);

        Collection<SlotContent> colc1 = new HashSet<SlotContent>();
        Collection<SlotContent> colc2 = new HashSet<SlotContent>();
        colc2.add(content);
        
        int hash = node1.id;
        SchemaCounter c1 = new SchemaCounter(hash, col1, colc1);
        hash = node1.id + node2.id + node3.id;
        hash += content.id;
        SchemaCounter c2  = new SchemaCounter(hash, col2, colc2);

        c1.increaseCount();
        c2.increaseCount();
        c2.increaseCount();

        assertEquals(node1.getCounts().size(), 2);
        assertEquals(node2.getCounts().size(), 1);
        assertEquals(node3.getCounts().size(), 1);
        assertEquals(node4.getCounts().size(), 0);

        assertSame(node2.getCounts().get(hash - node2.id).iterator().next(), c2);
        assertSame(node3.getCounts().get(hash - node3.id).iterator().next(), c2);
        assertSame(node1.getCounts().get(hash - node1.id).iterator().next(), c2);

        assertSame(node1.getCounts().get(0).iterator().next(), c1);
        assertEquals(node1.getCounts().get(0).iterator().next().getCount(), 1);

        assertTrue(c1.getENodes().contains(node1));
        assertEquals(c1.getENodes().size(), 1);
        assertTrue(c1.getContentsNodes().isEmpty());
        assertTrue(c2.getENodes().contains(node1));
        assertTrue(c2.getENodes().contains(node2));
        assertTrue(c2.getENodes().contains(node3));
        assertTrue(c2.getENodes().contains(node1));
        assertEquals(c2.getENodes().size(), 3);
        assertTrue(c2.getContentsNodes().contains(content));
        assertEquals(c2.getContentsNodes().size(), 1);

        assertEquals(node1.getCounts().get(hash - node1.id).iterator().next().getCount(), 2);

        System.out.println("---/// TEST SCHEMA EPISODE NODE 02 OK ///---");
    }
}