package cz.cuni.amis.pogamut.episodic.memory;

import java.io.Serializable;

/**
 * <code>IdGenerator</code> class is used to generete unique IDs for all
 * nodes in agent's memory. Each node needs a unique ID due to visualization
 * requirements: each node's visualization is represented by a vertex that
 * needs a unique identifier.
 * <p>
 * There is one instantion of this class in agent's memory and reference to
 * it is passed to inside structures, so all the IDs are provided by
 * one source only.
 *
 * @author Administrator
 */
public class IdGenerator implements Serializable {
    /**
     * Determines if a de-serialized file is compatible with this class.
     *
     * Maintainers must change this value if and only if the new version
     * of this class is not compatible with old versions. See Sun docs
     * for <a href=http://java.sun.com/products/jdk/1.1/docs/guide
     * /serialization/spec/version.doc.html> details. </a>
     *
     * Not necessary to include in first version of the class, but
     * included here as a reminder of its importance.
     */
    private static final long serialVersionUID = 1L;

    /**
     * ID to be returned. None of the nodes have this or higher id.
     */
    private int id = 0;
    /**
     * This method returns an ID that was not returned before and ensures that
     * the next time it is called a unique ID will be returned too.
     *
     * @return  A new unique ID for some node.
     */
    public int getNewId() {
        return id++;
    }
}
