package cz.cuni.amis.pogamut.episodic.query;

import cz.cuni.amis.pogamut.episodic.decisions.Node;
import cz.cuni.amis.pogamut.episodic.episodes.Chronobag;
import cz.cuni.amis.pogamut.episodic.episodes.Episode;
import cz.cuni.amis.pogamut.episodic.memory.AgentMemory;
import cz.cuni.amis.pogamut.episodic.schemas.SchemaObjectNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

/**
 *
 * @author Miso
 */
public class ComboTexts {
    public static Set<String> timeObjects = new HashSet<String>();
    

    public enum ComboType {
        COMBO_ACTIVITY,
        COMBO_ITEM,
        COMBO_TIME,
        COMBO_EPISODE
    }

    public class ComboString {
        final ComboType type;
        final boolean usual;
        String str;
        ComboString(ComboType type, boolean usual, String str) {
            this.type = type;
            this.usual = usual;
            this.str = str;
        }
    }

    AgentMemory mem;

    int mainComboSelected = 0;

    ArrayList<ComboString> mainComboStrings = new ArrayList<ComboString>();
    ArrayList<ComboString> secondaryComboStrings = new ArrayList<ComboString>();

    ComboTexts(AgentMemory mem) {
        this.mem = mem;

        timeObjects.add("Mo");
        timeObjects.add("Tu");
        timeObjects.add("We");
        timeObjects.add("Th");
        timeObjects.add("Fr");
        timeObjects.add("Sa");
        timeObjects.add("Su");
        timeObjects.add("Morning");
        timeObjects.add("Noon");
        timeObjects.add("Afternoon");
        timeObjects.add("Evening");
        timeObjects.add("LateEvening");
        timeObjects.add("Night");

        mainComboStrings.add(new ComboString(ComboType.COMBO_ACTIVITY, false, "When did you last perform ...?"));
        mainComboStrings.add(new ComboString(ComboType.COMBO_ACTIVITY, true, "When do you usually perform ...?"));
        mainComboStrings.add(new ComboString(ComboType.COMBO_ITEM, false, "When did you last use ...?"));
        mainComboStrings.add(new ComboString(ComboType.COMBO_ITEM, true, "When do you usually use ...?"));
        mainComboStrings.add(new ComboString(ComboType.COMBO_TIME, false, "What did you do on ...?"));
        mainComboStrings.add(new ComboString(ComboType.COMBO_TIME, true, "What do you usually do on ...?"));
        mainComboStrings.add(new ComboString(ComboType.COMBO_EPISODE, false, "Describe following episode: "));
    }

    public ArrayList<String> getMainComboTexts() {
        ArrayList<String> res = new ArrayList<String>();
        for (ComboString cs : mainComboStrings) {
            res.add(cs.str);
        }
        return res;
    }
    
    public ArrayList<String> getSecondaryComboTexts() {
        ArrayList<String> res = new ArrayList<String>();
        actualizeSecondaryCombo();
        for (ComboString cs : secondaryComboStrings) {
            res.add(cs.str);
        }
        return res;
    }

    public void actualizeSecondaryCombo() {
        mem.sem.acquireUninterruptibly();
        boolean usual = mainComboStrings.get(mainComboSelected).usual;
        ComboType type = mainComboStrings.get(mainComboSelected).type;
        secondaryComboStrings.clear();
        if (type == ComboType.COMBO_ACTIVITY) {
            for (Node n : mem.getDecisionTree().topLevelGoals.values()) {
                secondaryComboStrings.add(new ComboString(type, usual, n.getName()));
            }
        }
        if (type == ComboType.COMBO_ITEM) {
            for (SchemaObjectNode o : mem.getSchemaBag().getSchemaONodes()) {
                if (!timeObjects.contains(o.getName())) {
                    secondaryComboStrings.add(new ComboString(type, usual, o.getName()));
                }
            }
        }
        if (type == ComboType.COMBO_TIME) {
            for (SchemaObjectNode o : mem.getSchemaBag().getSchemaONodes()) {
                if (timeObjects.contains(o.getName())) {
                    secondaryComboStrings.add(new ComboString(type, usual, o.getName()));
                }
            }
        }
        if (type == ComboType.COMBO_EPISODE && usual == false) {
            String str;
            for (Chronobag ch : mem.getChronobags()) {
                for (Episode e : ch.getEpisodes()) {
                    str = e.toString();
                    str += ch.getAge().toString();
                    secondaryComboStrings.add(new ComboString(type, usual, str));
                }
            }
        }
        mem.sem.release();
    }

}
