package cz.cuni.amis.pogamut.episodic.decisions;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 * @author Miso
 */
public class DecisionTreeTest {

    DecisionTree instance = null;

    public DecisionTreeTest() {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    public static DecisionTree sampleTree(int topLevel, int levels, int subnodes) {
        DecisionTree sample = new DecisionTree();
        Intention i;
        for (int n = 0; n < topLevel; n++) {
            i = new Intention("intention."+levels+"."+n, 0);
            sample.topLevelGoals.put(i.getName(), i);
            fillIntention(i, levels - 1, subnodes);
        }
        return sample;
    }

    @Test
    public void testDecisionTree01() {
        instance = new DecisionTree();
        assertTrue(instance.topLevelGoals.isEmpty());

        Intention i1 = new Intention("i1",0);
        instance.topLevelGoals.put(i1.getName(), i1);
        Intention i;
        for (int n = 0; n < 1000; n++) {
            i = new Intention("intention"+n, 0);
            instance.topLevelGoals.put(i.getName(), i);
        }
        Intention i2 = new Intention("i2",0);
        instance.topLevelGoals.put(i2.getName(), i2);

        assertEquals(instance.topLevelGoals.size(), 1002);
        assertSame(instance.topLevelGoals.get("i1"), i1);
        assertSame(instance.topLevelGoals.get("i2"), i2);

        System.out.println("---/// TEST DECISION TREE 01 OK ///---");
    }

    @Test
    public void testDecisionTree02() {
        int levels = 2;
        int topLevel = 30;
        int subnodes = 5;

        instance = sampleTree(topLevel, levels, subnodes);

        Intention i;
        Action a;

        i = instance.topLevelGoals.get("intention."+levels+".0");
        for (int n = levels - 1; n > 0; n--) {
            assertEquals(i.getSubNodes().size(), subnodes);
            a = (Action)i.getSubNode("action."+n+".0");
            assertEquals(a.getSubNodes().size(), subnodes);
            i = (Intention)a.getSubNode("intention."+n+".0");
        }
        assertEquals(i.getSubNodes().size(), subnodes);
        a = (Action)i.getSubNode("action.0.0");
        assertEquals(a.getSubNodes().size(), 0);
        i = (Intention)a.getSubNode("intention.0.0");
        
        assertNull(i);
        assertNotNull(a);
        assertEquals(a.getAtomicActions().size(), subnodes);
        assertEquals(a.getAllChildrenNodes().size(), subnodes);
        AtomicAction aa = a.getAtomicAction("atomic.0.0");
        assertNotNull(aa);
        //attractivity is set in fillIntention method
        assertEquals(aa.getAttractivity(), 99);
        for (int n = 1; n < subnodes; n++) {
            aa = a.getAtomicAction("atomic.0."+n);
            assertNotNull(aa);
            assertEquals(aa.getAttractivity(), 100);
        }

        System.out.println("---/// TEST DECISION TREE 02 OK ///---");
    }

    private static void fillIntention(Intention i, int levels, int subnodes) {
        Action a;
        Intention i2;
        AffordanceSlot slot = new AffordanceSlot(i.getName()+"-"+"slot");
        i.addAffordance(slot);
        AtomicAction aa;
        //only add actions and atomic actions
        if (levels == 0) {
            for (int n1 = 0; n1 < subnodes; n1++) {
                a = new Action("action."+levels+"."+n1,0);
                slot = new AffordanceSlot(a.getName()+"-"+"slot");
                a.addAffordance(slot);
                i.addSubNode(a);
                for (int n2 = 0; n2 < subnodes; n2++) {
                    //attractivity of atomic actions start at 99 -> tested at test02
                    aa = new AtomicAction("atomic."+levels+"."+n2, 99+n2);
                    a.addAtomicAction(aa);
                }
            }
            return;
        }
        //recursively add actions and intentions
        for (int n1 = 0; n1 < subnodes; n1++) {
            a = new Action("action."+levels+"."+n1,0);
            slot = new AffordanceSlot(a.getName()+"-"+"slot");
            a.addAffordance(slot);
            i.addSubNode(a);
            for (int n2 = 0; n2 < subnodes; n2++) {
                i2 = new Intention("intention."+levels+"."+n2,0);
                a.addSubNode(i2);
                fillIntention(i2, levels-1, subnodes);
            }
        }
    }
}