package cz.cuni.amis.pogamut.episodic.decisions;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 * @author Michal Cermak
 */
public class IntentionTest {

    Intention instance = null;

    public IntentionTest() {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testIntention01() {
        instance = new Intention("intention",0);

        //new Intention is empty
        assertTrue(instance.getAllChildrenNodes().isEmpty());
        assertTrue(instance.getAffordances().isEmpty());

        //filling the elements
        String a1name = "action1";
        Action a1 = new Action(a1name,0);
        instance.addSubNode(a1);

        String s1name = "slot1";
        AffordanceSlot s1 = new AffordanceSlot(s1name);
        instance.addAffordance(s1);

        //elements were filled correctly
        assertEquals(instance.getSubNodes().size(), 1);
        assertEquals(instance.getAllChildrenNodes().size(), 1);
        assertEquals(instance.getAffordances().size(), 1);

        Node n1test = instance.getSubNode(a1name);
        assertNotNull(n1test);
        assertEquals(n1test.getName(), a1name);
        assertSame(n1test, a1);
        assertSame(instance, n1test.parent);

        AffordanceSlot s1test = instance.getAffordances().iterator().next();
        assertNotNull(s1test);
        assertEquals(s1test.type, s1name);
        assertSame(s1, s1test);

        //more elements can be added and elements can be changed
        String a2name = "action2";
        Action a2 = new Action(a2name,0);
        instance.addSubNode(a2);
        assertEquals(instance.getSubNodes().size(), 2);
        assertSame(a2, instance.getSubNode(a2name));

        Action a3 = new Action(a2name,0);
        instance.addSubNode(a3);
        assertEquals(instance.getSubNodes().size(), 2);
        assertSame(a3, instance.getSubNode(a2name));

        String s2name = "slot2";
        AffordanceSlot s2 = new AffordanceSlot(s2name);
        instance.addAffordance(s2);
        assertEquals(instance.getAffordances().size(), 2);
        assertSame(s2, instance.getAffordance(s2name));

        AffordanceSlot s3 = new AffordanceSlot(s2name);
        instance.addAffordance(s3);
        assertEquals(instance.getAffordances().size(), 2);
        assertSame(s3, instance.getAffordance(s2name));

        System.out.println("---/// TEST INTENTION 01 OK ///---");
    }

    @Test
    public void testAction02() {
        instance = new Intention("intention",10);
        assertEquals(instance.getType(), NodeType.INTENTION);
        assertEquals(instance.getAttractivity(), 10);

        try {
            instance.getId();
            fail("ID not set");
        } catch (Exception e) {
        }

        boolean b = instance.setId(5);
        assertTrue(b);
        assertEquals(instance.getId(), 5);
        b = instance.setId(10);
        assertFalse(b);
        assertEquals(instance.getId(), 5);

        System.out.println("---/// TEST INTENTION 02 OK ///---");
    }
}