package cz.cuni.amis.pogamut.episodic.schemas;

import java.util.Collection;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 * @author Michal Cermak
 */
public class SchemaSlotTest {

    SchemaSlot instance = null;

    public SchemaSlotTest() {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testSchemaSlot01() {
        instance = new SchemaSlot(123, "type");
        assertEquals(instance.getId(), 123);
        assertEquals(instance.getType(), "type");

        assertTrue(instance.filledBy.isEmpty());
        assertNull(instance.getSlotContent("object"));
        
        SchemaObjectNode obj = new SchemaObjectNode(456, "object");
        boolean result = instance.addSlotContent(789, obj);
        assertTrue(result);
        assertEquals(instance.filledBy.size(),1);

        SlotContent cont = instance.getSlotContent("object");
        assertNotNull(cont);

        assertSame(cont.getSlot(), instance);
        assertSame(cont.getObject(), obj);
        assertEquals(cont.getId(), 789);

        result = instance.addSlotContent(0, obj);
        assertFalse(result);
        cont = instance.getSlotContent("object");
        assertEquals(cont.getId(), 789);

        SchemaObjectNode obj2 = new SchemaObjectNode(1, "object2");
        result = instance.addSlotContent(1, obj2);
        assertTrue(result);
        assertEquals(instance.filledBy.size(),2);

        cont = instance.getSlotContent("object2");
        assertSame(cont.getSlot(), instance);
        assertSame(cont.getObject(), obj2);

        assertEquals(instance.getSlotContents(), instance.filledBy.values());

        System.out.println("---/// TEST SCHEMA SLOT 01 OK ///---");
    }

    @Test
    public void testSchemaSlot02() {
        instance = new SchemaSlot(123, "type");
        SchemaObjectNode obj;

        for (int i = 0; i < 100; i++) {
            obj = new SchemaObjectNode(i, "object"+i);
            boolean result = instance.addSlotContent(200+i, obj);
            assertTrue(result);
        }

        SlotContent cont;
        Collection<SlotContent> col = instance.getSlotContents();
        assertEquals(col.size(), 100);
        for (int i = 0; i < 100; i++) {
            cont = instance.getSlotContent("object"+i);
            assertTrue(col.contains(cont));
            assertSame(cont.getSlot(), instance);
            assertEquals(cont.getObject().getName(), "object"+i);
        }

        System.out.println("---/// TEST SCHEMA SLOT 02 OK ///---");
    }
}