package cz.cuni.amis.pogamut.episodic.schemas;

import cz.cuni.amis.pogamut.episodic.decisions.Intention;
import java.util.Collection;
import java.util.HashSet;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 * @author Michal Cermak
 */
public class SlotContentTest {

    SlotContent instance = null;

    public SlotContentTest() {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testSlotContent01() {
        SchemaSlot slot = new SchemaSlot(1, "type");
        SchemaObjectNode obj = new SchemaObjectNode(2, "object");

        instance = new SlotContent(123, slot, obj);
        assertEquals(instance.getId(), 123);
        assertSame(instance.getObject(), obj);
        assertSame(instance.getSlot(), slot);

        assertTrue(instance.getCounts().isEmpty());

        Collection<SchemaEpisodeNode> colE = new HashSet<SchemaEpisodeNode>();
        Collection<SlotContent> colC = new HashSet<SlotContent>();
        colC.add(instance);

        SchemaCounter count = new SchemaCounter(instance.getId(), colE, colC);
        assertEquals(instance.getCounts().size(), 1);
        assertEquals(instance.getCounts().get(0).size(), 1);
        
        assertSame(instance.getCounts().get(0).iterator().next(), count);
        
        System.out.println("---/// TEST SLOT CONTENT 01 OK ///---");
    }

    @Test
    public void testSlotContent02() {
        SchemaSlot slot1 = new SchemaSlot(1,"type1");
        SchemaSlot slot2 = new SchemaSlot(2,"type2");

        SchemaObjectNode obj1 = new SchemaObjectNode(3, "object1");
        SchemaObjectNode obj2 = new SchemaObjectNode(4, "object2");

        SlotContent content11 = new SlotContent(5, slot1, obj1);
        SlotContent content12 = new SlotContent(6, slot1, obj2);
        SlotContent content21 = new SlotContent(7, slot2, obj1);
        SlotContent content22 = new SlotContent(8, slot2, obj2);



        Intention node = new Intention("intention",0);
        SchemaEpisodeNode schemaENode = new SchemaEpisodeNode(node, 10, "episodeNode");

        Collection<SlotContent> col1 = new HashSet<SlotContent>();
        col1.add(content11);
        Collection<SlotContent> col2 = new HashSet<SlotContent>();
        col2.add(content11);
        col2.add(content12);
        col2.add(content21);

        Collection<SchemaEpisodeNode> cole1 = new HashSet<SchemaEpisodeNode>();
        Collection<SchemaEpisodeNode> cole2 = new HashSet<SchemaEpisodeNode>();
        cole2.add(schemaENode);

        int hash = content11.id;
        SchemaCounter c11 = new SchemaCounter(hash, cole1, col1);
        hash = content11.id + content12.id + content21.id;
        hash += schemaENode.id;
        SchemaCounter c22  = new SchemaCounter(hash, cole2, col2);

        c11.increaseCount();
        c22.increaseCount();
        c22.increaseCount();

        assertEquals(content11.getCounts().size(), 2);
        assertEquals(content12.getCounts().size(), 1);
        assertEquals(content21.getCounts().size(), 1);
        assertEquals(content22.getCounts().size(), 0);

        assertSame(content12.getCounts().get(hash - content12.id).iterator().next(), c22);
        assertSame(content21.getCounts().get(hash - content21.id).iterator().next(), c22);
        assertSame(content11.getCounts().get(hash - content11.id).iterator().next(), c22);

        assertSame(content11.getCounts().get(0).iterator().next(), c11);
        assertEquals(content11.getCounts().get(0).iterator().next().getCount(), 1);

        assertTrue(c11.getContentsNodes().contains(content11));
        assertEquals(c11.getContentsNodes().size(), 1);
        assertTrue(c11.getENodes().isEmpty());
        assertTrue(c22.getContentsNodes().contains(content11));
        assertTrue(c22.getContentsNodes().contains(content12));
        assertTrue(c22.getContentsNodes().contains(content21));
        assertTrue(c22.getContentsNodes().contains(content11));
        assertEquals(c22.getContentsNodes().size(), 3);
        assertTrue(c22.getENodes().contains(schemaENode));
        assertEquals(c22.getENodes().size(), 1);

        assertEquals(content11.getCounts().get(hash - content11.id).iterator().next().getCount(), 2);

        System.out.println("---/// TEST SLOT CONTENT 02 OK ///---");
    }
}