/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.episodic.decisions;

import cz.cuni.amis.pogamut.episodic.decisions.Action;
import cz.cuni.amis.pogamut.episodic.decisions.AffordanceSlot;
import cz.cuni.amis.pogamut.episodic.decisions.AtomicAction;
import cz.cuni.amis.pogamut.episodic.decisions.DecisionTree;
import cz.cuni.amis.pogamut.episodic.decisions.Intention;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DecisionTreeTest {
    DecisionTree instance = null;

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    public static DecisionTree sampleTree(int topLevel, int levels, int subnodes) {
        DecisionTree sample = new DecisionTree();
        for (int n = 0; n < topLevel; ++n) {
            Intention i = new Intention("intention." + levels + "." + n, 0);
            sample.topLevelGoals.put(i.getName(), i);
            DecisionTreeTest.fillIntention(i, levels - 1, subnodes);
        }
        return sample;
    }

    @Test
    public void testDecisionTree01() {
        this.instance = new DecisionTree();
        Assert.assertTrue((boolean)this.instance.topLevelGoals.isEmpty());
        Intention i1 = new Intention("i1", 0);
        this.instance.topLevelGoals.put(i1.getName(), i1);
        for (int n = 0; n < 1000; ++n) {
            Intention i = new Intention("intention" + n, 0);
            this.instance.topLevelGoals.put(i.getName(), i);
        }
        Intention i2 = new Intention("i2", 0);
        this.instance.topLevelGoals.put(i2.getName(), i2);
        Assert.assertEquals((long)this.instance.topLevelGoals.size(), (long)1002L);
        Assert.assertSame(this.instance.topLevelGoals.get("i1"), (Object)i1);
        Assert.assertSame(this.instance.topLevelGoals.get("i2"), (Object)i2);
        System.out.println("---/// TEST DECISION TREE 01 OK ///---");
    }

    @Test
    public void testDecisionTree02() {
        Action a;
        int levels = 2;
        int topLevel = 30;
        int subnodes = 5;
        this.instance = DecisionTreeTest.sampleTree(topLevel, levels, subnodes);
        Intention i = (Intention)this.instance.topLevelGoals.get("intention." + levels + ".0");
        for (int n = levels - 1; n > 0; --n) {
            Assert.assertEquals((long)i.getSubNodes().size(), (long)subnodes);
            a = (Action)i.getSubNode("action." + n + ".0");
            Assert.assertEquals((long)a.getSubNodes().size(), (long)subnodes);
            i = (Intention)a.getSubNode("intention." + n + ".0");
        }
        Assert.assertEquals((long)i.getSubNodes().size(), (long)subnodes);
        a = (Action)i.getSubNode("action.0.0");
        Assert.assertEquals((long)a.getSubNodes().size(), (long)0L);
        i = (Intention)a.getSubNode("intention.0.0");
        Assert.assertNull((Object)i);
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((long)a.getAtomicActions().size(), (long)subnodes);
        Assert.assertEquals((long)a.getAllChildrenNodes().size(), (long)subnodes);
        AtomicAction aa = a.getAtomicAction("atomic.0.0");
        Assert.assertNotNull((Object)aa);
        Assert.assertEquals((long)aa.getAttractivity(), (long)99L);
        for (int n = 1; n < subnodes; ++n) {
            aa = a.getAtomicAction("atomic.0." + n);
            Assert.assertNotNull((Object)aa);
            Assert.assertEquals((long)aa.getAttractivity(), (long)100L);
        }
        System.out.println("---/// TEST DECISION TREE 02 OK ///---");
    }

    private static void fillIntention(Intention i, int levels, int subnodes) {
        AffordanceSlot slot = new AffordanceSlot(i.getName() + "-" + "slot");
        i.addAffordance(slot);
        if (levels == 0) {
            for (int n1 = 0; n1 < subnodes; ++n1) {
                Action a = new Action("action." + levels + "." + n1, 0);
                slot = new AffordanceSlot(a.getName() + "-" + "slot");
                a.addAffordance(slot);
                i.addSubNode(a);
                for (int n2 = 0; n2 < subnodes; ++n2) {
                    AtomicAction aa = new AtomicAction("atomic." + levels + "." + n2, 99 + n2);
                    a.addAtomicAction(aa);
                }
            }
            return;
        }
        for (int n1 = 0; n1 < subnodes; ++n1) {
            Action a = new Action("action." + levels + "." + n1, 0);
            slot = new AffordanceSlot(a.getName() + "-" + "slot");
            a.addAffordance(slot);
            i.addSubNode(a);
            for (int n2 = 0; n2 < subnodes; ++n2) {
                Intention i2 = new Intention("intention." + levels + "." + n2, 0);
                a.addSubNode(i2);
                DecisionTreeTest.fillIntention(i2, levels - 1, subnodes);
            }
        }
    }
}

