/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.episodic.episodes;

import cz.cuni.amis.pogamut.episodic.decisions.DecisionTree;
import cz.cuni.amis.pogamut.episodic.decisions.DecisionTreeTest;
import cz.cuni.amis.pogamut.episodic.episodes.Chronobag;
import cz.cuni.amis.pogamut.episodic.episodes.Episode;
import cz.cuni.amis.pogamut.episodic.episodes.EpisodeNode;
import cz.cuni.amis.pogamut.episodic.memory.AffordanceUsed;
import cz.cuni.amis.pogamut.episodic.memory.AgentMemory;
import cz.cuni.amis.pogamut.episodic.memory.Parameters;
import java.util.ArrayList;
import java.util.Iterator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ChronobagTest {
    AgentMemory mem = null;
    Chronobag instance = null;

    @Before
    public void setUp() {
        DecisionTree dTree = DecisionTreeTest.sampleTree(10, 2, 3);
        this.mem = new AgentMemory();
        this.mem.initialize(dTree.topLevelGoals.values());
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testChronobag01() {
        this.instance = new Chronobag(this.mem.getIdGenerator(), this.mem);
        Assert.assertSame((Object)this.instance.getMemory(), (Object)this.mem);
        Assert.assertEquals((long)this.instance.level, (long)0L);
        Assert.assertFalse((boolean)this.instance.landmark);
        Assert.assertEquals((long)this.instance.numberOfEpisodeNodes, (long)0L);
        Assert.assertTrue((boolean)this.instance.getEpisodes().isEmpty());
        Assert.assertFalse((boolean)this.instance.newNodeAdded);
        Assert.assertTrue((boolean)this.instance.objectNodes.isEmpty());
        Assert.assertEquals((long)this.instance.getAge().getMinAge(), (long)0L);
        Assert.assertEquals((long)this.instance.getAge().getMaxAge(), (long)0L);
        ArrayList<String> trace = new ArrayList<String>();
        trace.add("intention.2.0");
        trace.add("action.1.0");
        trace.add("intention.1.0");
        trace.add("action.0.0");
        ArrayList<AffordanceUsed> affs = new ArrayList<AffordanceUsed>();
        this.instance.addNewNode("atomic.0.0", trace, affs, "");
        Assert.assertEquals((long)this.instance.currentEpisodes.size(), (long)1L);
        Assert.assertNotNull(this.instance.currentEpisodes.get("intention.2.0"));
        Assert.assertEquals((long)this.instance.numberOfEpisodeNodes, (long)5L);
        affs.add(new AffordanceUsed("action.1.0", "type", "obj1"));
        this.instance.addNewNode("atomic.0.0", trace, affs, "");
        Assert.assertEquals((long)this.instance.objectNodes.size(), (long)1L);
        Assert.assertNotNull(this.instance.objectNodes.get("obj1"));
        Assert.assertEquals((Object)this.instance.getFirstEpisode().getRoot().getName(), (Object)"intention.2.0");
        Assert.assertTrue((boolean)this.instance.getEpisodes().contains(this.instance.getFirstEpisode()));
        Assert.assertTrue((boolean)this.instance.finishedEpisodes.isEmpty());
        trace.clear();
        trace.add("intention.2.0");
        this.instance.finishNode("intention.2.0", trace, true);
        Assert.assertTrue((boolean)this.instance.currentEpisodes.isEmpty());
        Assert.assertEquals((long)this.instance.getEpisodes().size(), (long)1L);
        Assert.assertTrue((boolean)this.instance.getEpisodes().contains(this.instance.getFirstEpisode()));
        Assert.assertEquals((long)this.instance.finishedEpisodes.size(), (long)1L);
        Assert.assertEquals((Object)((Episode)this.instance.finishedEpisodes.iterator().next()).getRoot().getName(), (Object)"intention.2.0");
        trace.clear();
        trace.add("intention.2.1");
        affs.clear();
        affs.add(new AffordanceUsed("intention.2.1", "type", "obj2"));
        this.instance.addNewNode("atomic.2.0", trace, affs, "");
        trace.clear();
        trace.add("intention.2.2");
        affs.clear();
        affs.add(new AffordanceUsed("intention.2.2", "type", "obj2"));
        this.instance.addNewNode("atomic.2.0", trace, affs, "");
        trace.clear();
        trace.add("intention.2.3");
        affs.clear();
        affs.add(new AffordanceUsed("intention.2.3", "type", "obj2"));
        this.instance.addNewNode("atomic.2.0", trace, affs, "");
        Assert.assertEquals((long)this.instance.currentEpisodes.size(), (long)3L);
        Assert.assertEquals((long)this.instance.getEpisodes().size(), (long)4L);
        Assert.assertNotNull(this.instance.currentEpisodes.get("intention.2.1"));
        Assert.assertNotNull(this.instance.currentEpisodes.get("intention.2.2"));
        Assert.assertNotNull(this.instance.currentEpisodes.get("intention.2.3"));
        Episode e = this.instance.getFirstEpisode();
        Assert.assertEquals((Object)e.getRoot().getName(), (Object)"intention.2.0");
        Assert.assertEquals((long)e.next.size(), (long)1L);
        e = (Episode)e.next.iterator().next();
        Assert.assertEquals((Object)e.getRoot().getName(), (Object)"intention.2.1");
        Assert.assertEquals((long)e.next.size(), (long)1L);
        e = (Episode)e.next.iterator().next();
        Assert.assertEquals((Object)e.getRoot().getName(), (Object)"intention.2.2");
        Assert.assertEquals((long)e.next.size(), (long)1L);
        e = (Episode)e.next.iterator().next();
        Assert.assertEquals((Object)e.getRoot().getName(), (Object)"intention.2.3");
        Assert.assertTrue((boolean)e.next.isEmpty());
        Assert.assertEquals((long)e.previous.size(), (long)1L);
        e = (Episode)e.previous.iterator().next();
        Assert.assertEquals((Object)e.getRoot().getName(), (Object)"intention.2.2");
        Assert.assertEquals((long)e.previous.size(), (long)1L);
        e = (Episode)e.previous.iterator().next();
        Assert.assertEquals((Object)e.getRoot().getName(), (Object)"intention.2.1");
        Assert.assertEquals((long)e.previous.size(), (long)1L);
        e = (Episode)e.previous.iterator().next();
        Assert.assertEquals((Object)e.getRoot().getName(), (Object)"intention.2.0");
        Assert.assertTrue((boolean)e.previous.isEmpty());
        this.instance.finish();
        Assert.assertTrue((boolean)this.instance.currentEpisodes.isEmpty());
        Assert.assertEquals((long)this.instance.finishedEpisodes.size(), (long)4L);
        System.out.println("---/// TEST CHRONOBAG 01 OK ///---");
    }

    @Test
    public void testChronobag02() {
        this.instance = new Chronobag(this.mem.getIdGenerator(), this.mem);
        Assert.assertFalse((boolean)this.instance.isLandmark());
        for (int i = 0; i < Parameters.LANDMARK_AGE_THRESHOLDS[0] - 1; ++i) {
            this.instance.increaseDay();
        }
        Assert.assertFalse((boolean)this.instance.isLandmark());
        this.instance.increaseDay();
        Assert.assertTrue((boolean)this.instance.isLandmark());
        this.instance = new Chronobag(this.mem.getIdGenerator(), this.mem);
        this.instance.increaseDay();
        Assert.assertEquals((long)this.instance.getAge().getMinAge(), (long)1L);
        Assert.assertEquals((long)this.instance.getAge().getMaxAge(), (long)1L);
        Assert.assertNull((Object)this.instance.getMoreAbstractChronobag());
        Chronobag abs = this.instance.createMoreAbstractChronobag();
        Assert.assertNotNull((Object)abs);
        Assert.assertEquals((long)abs.getLevel(), (long)1L);
        Assert.assertSame((Object)abs, (Object)this.instance.getMoreAbstractChronobag());
        Assert.assertEquals((long)abs.getAge().getMinAge(), (long)(this.instance.getAge().getMinAge() - (Parameters.CHRONOBAG_INTERVAL_LENGHTS[1] - Parameters.CHRONOBAG_INTERVAL_LENGHTS[0]) / 2));
        Assert.assertEquals((long)abs.getAge().getMaxAge(), (long)(this.instance.getAge().getMaxAge() + (Parameters.CHRONOBAG_INTERVAL_LENGHTS[1] - Parameters.CHRONOBAG_INTERVAL_LENGHTS[0]) / 2));
        Assert.assertEquals((long)(abs.getAge().getMaxAge() - abs.getAge().getMinAge() + 1), (long)Parameters.CHRONOBAG_INTERVAL_LENGHTS[abs.level]);
        this.instance = new Chronobag(this.mem.getIdGenerator(), this.mem, this.instance);
        Assert.assertSame((Object)this.instance.getMoreAbstractChronobag(), (Object)abs);
        this.instance.createMoreAbstractChronobag();
        Assert.assertSame((Object)this.instance.getMoreAbstractChronobag(), (Object)abs);
        Assert.assertFalse((boolean)abs.isLandmark());
        for (int i = 0; i < Parameters.LANDMARK_AGE_THRESHOLDS[abs.getLevel()] - 1; ++i) {
            abs.increaseDay();
        }
        Assert.assertFalse((boolean)abs.isLandmark());
        abs.increaseDay();
        Assert.assertTrue((boolean)abs.isLandmark());
        System.out.println("---/// TEST CHRONOBAG 02 OK ///---");
    }

    @Test
    public void testChronobag03() {
        this.instance = new Chronobag(this.mem.getIdGenerator(), this.mem);
        ArrayList<String> trace = new ArrayList<String>();
        ArrayList affs = new ArrayList();
        trace.add("intention.2.0");
        this.instance.addNewNode("atomic", trace, affs, "");
        boolean result = this.instance.finishNode("intention.2.0", trace, true);
        Assert.assertTrue((boolean)result);
        trace.add("intention.2.0");
        this.instance.addNewNode("atomic", trace, affs, "");
        result = this.instance.finishNode("intention.2.0", trace, true);
        Assert.assertTrue((boolean)result);
        trace.add("intention.2.0");
        this.instance.addNewNode("atomic", trace, affs, "");
        result = this.instance.finishNode("intention.2.0", trace, true);
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((long)this.instance.getEpisodes().size(), (long)1L);
        trace.add("intention.2.0");
        this.instance.addNewNode("atomic", trace, affs, "");
        this.instance.finishNode("intention.2.0", trace, true);
        trace.add("intention.2.1");
        this.instance.addNewNode("atomic", trace, affs, "");
        this.instance.finishNode("intention.2.1", trace, true);
        trace.add("intention.2.0");
        this.instance.addNewNode("atomic", trace, affs, "");
        this.instance.finishNode("intention.2.0", trace, true);
        Assert.assertEquals((long)this.instance.getEpisodes().size(), (long)3L);
        trace.add("intention.2.2");
        this.instance.addNewNode("atomic", trace, affs, "");
        trace.clear();
        trace.add("intention.2.3");
        this.instance.addNewNode("atomic", trace, affs, "");
        Episode e = (Episode)this.instance.currentEpisodes.get("intention.2.2");
        Assert.assertEquals((long)e.next.size(), (long)1L);
        Assert.assertTrue((boolean)e.next.contains(this.instance.currentEpisodes.get("intention.2.3")));
        trace.clear();
        trace.add("intention.2.2");
        this.instance.addNewNode("atomic", trace, affs, "");
        trace.clear();
        trace.add("intention.2.4");
        this.instance.addNewNode("atomic", trace, affs, "");
        Assert.assertEquals((long)e.next.size(), (long)2L);
        Assert.assertTrue((boolean)e.next.contains(this.instance.currentEpisodes.get("intention.2.3")));
        Assert.assertTrue((boolean)e.next.contains(this.instance.currentEpisodes.get("intention.2.4")));
        Assert.assertTrue((boolean)((Episode)this.instance.currentEpisodes.get((Object)"intention.2.3")).previous.contains(e));
        Assert.assertTrue((boolean)((Episode)this.instance.currentEpisodes.get((Object)"intention.2.4")).previous.contains(e));
        trace.clear();
        trace.add("intention.2.2");
        this.instance.addNewNode("atomic", trace, affs, "");
        trace.clear();
        trace.add("intention.2.3");
        this.instance.addNewNode("atomic", trace, affs, "");
        Assert.assertEquals((long)e.next.size(), (long)3L);
        Assert.assertSame(e.next.get(0), this.instance.currentEpisodes.get("intention.2.3"));
        Assert.assertSame(e.next.get(1), this.instance.currentEpisodes.get("intention.2.4"));
        Assert.assertSame(e.next.get(2), this.instance.currentEpisodes.get("intention.2.3"));
        System.out.println("---/// TEST CHRONOBAG 03 OK ///---");
    }

    @Test
    public void testChronobag04() {
        this.instance = new Chronobag(this.mem.getIdGenerator(), this.mem);
        ArrayList<String> trace = new ArrayList<String>();
        ArrayList<AffordanceUsed> affs = new ArrayList<AffordanceUsed>();
        trace.add("intention.2.0");
        trace.add("action.1.0");
        trace.add("intention.1.0");
        trace.add("action.0.0");
        this.instance.addNewNode("atomic.0.0", trace, affs, "");
        Episode e = this.instance.getFirstEpisode();
        EpisodeNode n = e.getRoot().getChild("action.1.0").getChild("intention.1.0").getChild("action.0.0").getChild("atomic.0.0");
        Assert.assertNotNull((Object)n.getAssociatedNode());
        affs.add(new AffordanceUsed("intention.2.0", "type", "obj1"));
        affs.add(new AffordanceUsed("action.0.0", "type", "obj2"));
        this.instance.addNewNode("atomic.0.0", trace, affs, "");
        trace.clear();
        trace.add("intention.2.0");
        trace.add("action.1.0");
        trace.add("intention.1.1");
        trace.add("action.0.1");
        affs.clear();
        affs.add(new AffordanceUsed("intention.2.0", "type", "obj3"));
        affs.add(new AffordanceUsed("action.0.1", "type", "obj4"));
        this.instance.addNewNode("atomic.0.1", trace, affs, "");
        e = (Episode)this.instance.currentEpisodes.get("intention.2.0");
        Assert.assertEquals((long)e.getRoot().numberOfSubNodes, (long)7L);
        Assert.assertEquals((long)e.getRoot().numberOfSubNodesWithObjects, (long)11L);
        Assert.assertEquals((long)this.instance.numberOfEpisodeNodes, (long)8L);
        this.instance.finish();
        trace.clear();
        trace.add("intention.2.2");
        affs.clear();
        this.instance.addNewNode("atomic.x", trace, affs, "");
        this.instance.finish();
        Assert.assertEquals((long)this.instance.numberOfEpisodeNodes, (long)10L);
        trace.clear();
        trace.add("intention.2.0");
        trace.add("action.1.0");
        trace.add("intention.1.1");
        trace.add("action.0.1");
        affs.clear();
        affs.add(new AffordanceUsed("intention.2.0", "type", "obj5"));
        affs.add(new AffordanceUsed("action.0.1", "type", "obj6"));
        this.instance.addNewNode("atomic.0.1", trace, affs, "");
        Assert.assertEquals((long)this.instance.getEpisodes().size(), (long)3L);
        trace.clear();
        trace.add("intention.2.0");
        trace.add("action.1.2");
        trace.add("intention.1.2");
        trace.add("action.0.2");
        affs.clear();
        affs.add(new AffordanceUsed("intention.2.0", "type", "obj1"));
        affs.add(new AffordanceUsed("action.0.2", "type", "obj2"));
        this.instance.addNewNode("atomic.0.2", trace, affs, "");
        Episode e2 = (Episode)this.instance.currentEpisodes.get("intention.2.0");
        this.instance.finish();
        Assert.assertEquals((long)e2.getRoot().numberOfSubNodes, (long)8L);
        Assert.assertEquals((long)e2.getRoot().numberOfSubNodesWithObjects, (long)12L);
        Assert.assertEquals((long)this.instance.numberOfEpisodeNodes, (long)19L);
        Assert.assertEquals((long)this.instance.getEpisodes().size(), (long)3L);
        Assert.assertEquals((long)this.instance.finishedEpisodes.size(), (long)3L);
        Assert.assertEquals((Object)e.getRoot().getName(), (Object)"intention.2.0");
        Assert.assertEquals((Object)e2.getRoot().getName(), (Object)"intention.2.0");
        Assert.assertNotSame((Object)e, (Object)e2);
        e.mergeWith(e2);
        Assert.assertEquals((long)this.instance.getEpisodes().size(), (long)2L);
        Assert.assertTrue((boolean)this.instance.getEpisodes().contains(e));
        Assert.assertFalse((boolean)this.instance.getEpisodes().contains(e2));
        Assert.assertEquals((long)e.getRoot().numberOfSubNodes, (long)11L);
        Assert.assertEquals((long)e.getRoot().numberOfSubNodesWithObjects, (long)18L);
        n = e.getRoot().getChild("action.1.0");
        Assert.assertEquals((long)n.numberOfSubNodes, (long)6L);
        Assert.assertEquals((long)n.numberOfSubNodesWithObjects, (long)9L);
        n = e.getRoot().getChild("action.1.2");
        Assert.assertEquals((long)n.numberOfSubNodes, (long)3L);
        Assert.assertEquals((long)n.numberOfSubNodesWithObjects, (long)4L);
        Assert.assertEquals((long)this.instance.numberOfEpisodeNodes, (long)14L);
        System.out.println("---/// TEST CHRONOBAG 04 OK ///---");
    }

    @Test
    public void testChronobag05() {
        this.instance = new Chronobag(this.mem.getIdGenerator(), this.mem);
        ArrayList<String> trace = new ArrayList<String>();
        ArrayList affs = new ArrayList();
        trace.add("intention.2.1");
        this.instance.addNewNode("atomic.0.0", trace, affs, "");
        trace.set(0, "intention.2.2");
        this.instance.addNewNode("atomic.0.0", trace, affs, "");
        trace.set(0, "intention.2.3");
        this.instance.addNewNode("atomic.0.0", trace, affs, "");
        trace.set(0, "intention.2.2");
        this.instance.addNewNode("atomic.0.0", trace, affs, "");
        trace.set(0, "intention.2.3");
        this.instance.addNewNode("atomic.0.0", trace, affs, "");
        trace.set(0, "intention.2.4");
        this.instance.addNewNode("atomic.0.0", trace, affs, "");
        trace.set(0, "intention.2.3");
        this.instance.addNewNode("atomic.0.0", trace, affs, "");
        trace.set(0, "intention.2.1");
        this.instance.addNewNode("atomic.0.0", trace, affs, "");
        trace.set(0, "intention.2.3");
        this.instance.addNewNode("atomic.0.0", trace, affs, "");
        trace.set(0, "intention.2.5");
        this.instance.addNewNode("atomic.0.0", trace, affs, "");
        trace.set(0, "intention.2.3");
        this.instance.addNewNode("atomic.0.0", trace, affs, "");
        trace.set(0, "intention.2.4");
        this.instance.addNewNode("atomic.0.0", trace, affs, "");
        trace.set(0, "intention.2.5");
        this.instance.addNewNode("atomic.0.0", trace, affs, "");
        Episode e1 = (Episode)this.instance.currentEpisodes.get("intention.2.1");
        Episode e2 = (Episode)this.instance.currentEpisodes.get("intention.2.2");
        Episode e3 = (Episode)this.instance.currentEpisodes.get("intention.2.3");
        Episode e4 = (Episode)this.instance.currentEpisodes.get("intention.2.4");
        Episode e5 = (Episode)this.instance.currentEpisodes.get("intention.2.5");
        this.instance.finish();
        Assert.assertEquals((long)e3.next.size(), (long)5L);
        Assert.assertEquals((long)e3.previous.size(), (long)5L);
        Assert.assertEquals((Object)((Episode)e3.previous.get(0)).getRoot().getName(), (Object)"intention.2.5");
        Assert.assertEquals((Object)((Episode)e3.previous.get(1)).getRoot().getName(), (Object)"intention.2.1");
        Assert.assertEquals((Object)((Episode)e3.previous.get(2)).getRoot().getName(), (Object)"intention.2.4");
        Assert.assertEquals((Object)((Episode)e3.previous.get(3)).getRoot().getName(), (Object)"intention.2.2");
        Assert.assertEquals((Object)((Episode)e3.previous.get(4)).getRoot().getName(), (Object)"intention.2.2");
        Assert.assertSame(e3.previous.get(3), e3.previous.get(4));
        Assert.assertEquals((Object)((Episode)e3.next.get(0)).getRoot().getName(), (Object)"intention.2.2");
        Assert.assertEquals((Object)((Episode)e3.next.get(1)).getRoot().getName(), (Object)"intention.2.4");
        Assert.assertEquals((Object)((Episode)e3.next.get(2)).getRoot().getName(), (Object)"intention.2.1");
        Assert.assertEquals((Object)((Episode)e3.next.get(3)).getRoot().getName(), (Object)"intention.2.5");
        Assert.assertEquals((Object)((Episode)e3.next.get(4)).getRoot().getName(), (Object)"intention.2.4");
        Assert.assertSame(e3.next.get(1), e3.next.get(4));
        this.instance.deleteEpisode(e3);
        Assert.assertEquals((long)e1.next.size(), (long)2L);
        Iterator it = e1.next.iterator();
        Assert.assertSame(it.next(), (Object)e2);
        Assert.assertSame(it.next(), (Object)e5);
        Assert.assertEquals((long)e2.next.size(), (long)1L);
        it = e2.next.iterator();
        Assert.assertSame(it.next(), (Object)e4);
        Assert.assertEquals((long)e4.next.size(), (long)2L);
        it = e4.next.iterator();
        Assert.assertSame(it.next(), (Object)e1);
        Assert.assertSame(it.next(), (Object)e5);
        Assert.assertEquals((long)e5.next.size(), (long)1L);
        it = e5.next.iterator();
        Assert.assertSame(it.next(), (Object)e4);
        Assert.assertEquals((long)e1.previous.size(), (long)1L);
        it = e1.previous.iterator();
        Assert.assertSame(it.next(), (Object)e4);
        Assert.assertEquals((long)e2.previous.size(), (long)1L);
        it = e2.previous.iterator();
        Assert.assertSame(it.next(), (Object)e1);
        Assert.assertEquals((long)e4.previous.size(), (long)2L);
        it = e4.previous.iterator();
        Assert.assertSame(it.next(), (Object)e5);
        Assert.assertSame(it.next(), (Object)e2);
        Assert.assertEquals((long)e5.previous.size(), (long)2L);
        it = e5.previous.iterator();
        Assert.assertSame(it.next(), (Object)e4);
        Assert.assertSame(it.next(), (Object)e1);
        this.instance.deleteEpisode(e1);
        Assert.assertEquals((long)e2.next.size(), (long)1L);
        it = e2.next.iterator();
        Assert.assertSame(it.next(), (Object)e4);
        Assert.assertEquals((long)e4.next.size(), (long)2L);
        it = e4.next.iterator();
        Assert.assertSame(it.next(), (Object)e5);
        Assert.assertSame(it.next(), (Object)e5);
        Assert.assertEquals((long)e5.next.size(), (long)1L);
        it = e5.next.iterator();
        Assert.assertSame(it.next(), (Object)e4);
        Assert.assertEquals((long)e2.previous.size(), (long)0L);
        Assert.assertEquals((long)e4.previous.size(), (long)2L);
        it = e4.previous.iterator();
        Assert.assertSame(it.next(), (Object)e5);
        Assert.assertSame(it.next(), (Object)e2);
        Assert.assertEquals((long)e5.previous.size(), (long)2L);
        it = e5.previous.iterator();
        Assert.assertSame(it.next(), (Object)e4);
        Assert.assertSame(it.next(), (Object)e4);
        this.instance.deleteEpisode(e5);
        Assert.assertEquals((long)e2.next.size(), (long)1L);
        it = e2.next.iterator();
        Assert.assertSame(it.next(), (Object)e4);
        Assert.assertEquals((long)e4.next.size(), (long)0L);
        Assert.assertEquals((long)e2.previous.size(), (long)0L);
        Assert.assertEquals((long)e4.previous.size(), (long)1L);
        it = e4.previous.iterator();
        Assert.assertSame(it.next(), (Object)e2);
        this.instance.deleteEpisode(e4);
        Assert.assertEquals((long)e2.previous.size(), (long)0L);
        Assert.assertEquals((long)e2.next.size(), (long)0L);
        this.instance = new Chronobag(this.mem.getIdGenerator(), this.mem);
        trace.clear();
        Assert.assertEquals((long)this.instance.getEpisodes().size(), (long)0L);
        trace.add("intention.2.1");
        this.instance.addNewNode("atomic.0.0", trace, affs, "");
        trace.set(0, "intention.2.2");
        this.instance.addNewNode("atomic.0.0", trace, affs, "");
        trace.set(0, "intention.2.3");
        this.instance.addNewNode("atomic.0.0", trace, affs, "");
        trace.set(0, "intention.2.2");
        this.instance.addNewNode("atomic.0.0", trace, affs, "");
        trace.set(0, "intention.2.3");
        this.instance.addNewNode("atomic.0.0", trace, affs, "");
        trace.set(0, "intention.2.4");
        this.instance.addNewNode("atomic.0.0", trace, affs, "");
        trace.set(0, "intention.2.3");
        this.instance.addNewNode("atomic.0.0", trace, affs, "");
        trace.set(0, "intention.2.1");
        this.instance.addNewNode("atomic.0.0", trace, affs, "");
        trace.set(0, "intention.2.3");
        this.instance.addNewNode("atomic.0.0", trace, affs, "");
        trace.set(0, "intention.2.5");
        this.instance.addNewNode("atomic.0.0", trace, affs, "");
        trace.set(0, "intention.2.3");
        this.instance.addNewNode("atomic.0.0", trace, affs, "");
        trace.set(0, "intention.2.4");
        this.instance.addNewNode("atomic.0.0", trace, affs, "");
        trace.set(0, "intention.2.5");
        this.instance.addNewNode("atomic.0.0", trace, affs, "");
        Assert.assertEquals((long)this.instance.getEpisodes().size(), (long)5L);
        e1 = (Episode)this.instance.currentEpisodes.get("intention.2.1");
        e2 = (Episode)this.instance.currentEpisodes.get("intention.2.2");
        e3 = (Episode)this.instance.currentEpisodes.get("intention.2.3");
        e4 = (Episode)this.instance.currentEpisodes.get("intention.2.4");
        e5 = (Episode)this.instance.currentEpisodes.get("intention.2.5");
        this.instance.finish();
        this.instance.deleteEpisode(e3);
        this.instance.deleteEpisode(e5);
        Assert.assertEquals((long)e1.next.size(), (long)2L);
        it = e1.next.iterator();
        Assert.assertSame(it.next(), (Object)e2);
        Assert.assertSame(it.next(), (Object)e4);
        Assert.assertEquals((long)e2.next.size(), (long)1L);
        it = e2.next.iterator();
        Assert.assertSame(it.next(), (Object)e4);
        Assert.assertEquals((long)e4.next.size(), (long)1L);
        it = e4.next.iterator();
        Assert.assertSame(it.next(), (Object)e1);
        Assert.assertEquals((long)e1.previous.size(), (long)1L);
        it = e1.previous.iterator();
        Assert.assertSame(it.next(), (Object)e4);
        Assert.assertEquals((long)e2.previous.size(), (long)1L);
        it = e2.previous.iterator();
        Assert.assertSame(it.next(), (Object)e1);
        Assert.assertEquals((long)e4.previous.size(), (long)2L);
        it = e4.previous.iterator();
        Assert.assertSame(it.next(), (Object)e1);
        Assert.assertSame(it.next(), (Object)e2);
        this.instance.deleteEpisode(e1);
        Assert.assertEquals((long)e2.next.size(), (long)1L);
        it = e2.next.iterator();
        Assert.assertSame(it.next(), (Object)e4);
        Assert.assertEquals((long)e4.next.size(), (long)0L);
        Assert.assertEquals((long)e2.previous.size(), (long)0L);
        Assert.assertEquals((long)e4.previous.size(), (long)1L);
        it = e4.previous.iterator();
        Assert.assertSame(it.next(), (Object)e2);
        this.instance.deleteEpisode(e2);
        Assert.assertEquals((long)e4.previous.size(), (long)0L);
        Assert.assertEquals((long)e4.next.size(), (long)0L);
        System.out.println("---/// TEST CHRONOBAG 05 OK ///---");
    }
}

