/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.episodic.episodes;

import cz.cuni.amis.pogamut.episodic.decisions.Action;
import cz.cuni.amis.pogamut.episodic.decisions.DecisionTree;
import cz.cuni.amis.pogamut.episodic.decisions.DecisionTreeTest;
import cz.cuni.amis.pogamut.episodic.decisions.Intention;
import cz.cuni.amis.pogamut.episodic.decisions.Node;
import cz.cuni.amis.pogamut.episodic.episodes.Chronobag;
import cz.cuni.amis.pogamut.episodic.episodes.Episode;
import cz.cuni.amis.pogamut.episodic.episodes.EpisodeNode;
import cz.cuni.amis.pogamut.episodic.episodes.ObjectNode;
import cz.cuni.amis.pogamut.episodic.episodes.ObjectSlot;
import cz.cuni.amis.pogamut.episodic.memory.AgentMemory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EpisodeNodeTest {
    Chronobag ch;
    Episode e;
    EpisodeNode instance = null;

    @Before
    public void setUp() {
        DecisionTree dTree = DecisionTreeTest.sampleTree(10, 2, 3);
        AgentMemory mem = new AgentMemory();
        mem.initialize(dTree.topLevelGoals.values());
        this.ch = new Chronobag(mem.getIdGenerator(), mem);
        this.e = new Episode(this.ch);
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testEpisodeNode01() {
        Node associated = (Node)this.e.getParentChronobag().getMemory().getDecisionTree().topLevelGoals.values().iterator().next();
        this.instance = new EpisodeNode("node", null, this.e, associated);
        Assert.assertEquals((Object)this.instance.getName(), (Object)"node");
        Assert.assertSame((Object)this.instance.getAssociatedNode(), (Object)associated);
        Assert.assertTrue((boolean)this.instance.children.isEmpty());
        Assert.assertFalse((boolean)this.instance.succeeded);
        Assert.assertEquals((long)this.instance.numberOfSubNodes, (long)0L);
        Assert.assertEquals((long)this.instance.numberOfSubNodesWithObjects, (long)0L);
        Assert.assertTrue((boolean)this.instance.slots.isEmpty());
        Assert.assertSame((Object)this.instance.getEpisodeRoot(), (Object)this.e);
        boolean result = this.instance.addChildNode("child1");
        Assert.assertTrue((boolean)result);
        result = this.instance.addChildNode("child2");
        Assert.assertTrue((boolean)result);
        result = this.instance.addChildNode("child1");
        Assert.assertFalse((boolean)result);
        Assert.assertEquals((long)this.instance.getChildrenNodes().size(), (long)2L);
        Assert.assertNotNull((Object)this.instance.getChild("child1"));
        Assert.assertNotNull((Object)this.instance.getChild("child2"));
        Assert.assertEquals((long)this.instance.numberOfSubNodes, (long)2L);
        Assert.assertEquals((long)this.instance.numberOfSubNodesWithObjects, (long)2L);
        EpisodeNode child1 = this.instance.getChild("child1");
        Assert.assertSame((Object)child1.getParent(), (Object)this.instance);
        Assert.assertSame(this.instance.getFirstChild().get(this.e.getIdEpisode()), (Object)child1);
        Assert.assertEquals((long)this.instance.getFirstChild().size(), (long)1L);
        EpisodeNode child2 = this.instance.getChild("child2");
        Assert.assertNull(child1.getPredecessor().get(this.e.getIdEpisode()));
        Assert.assertSame(child1.getSuccessor().get(this.e.getIdEpisode()), (Object)child2);
        Assert.assertSame(child2.getPredecessor().get(this.e.getIdEpisode()), (Object)child1);
        Assert.assertNull(child2.getSuccessor().get(this.e.getIdEpisode()));
        Assert.assertNull((Object)child1.getAssociatedNode());
        String childName = ((Action)((Intention)associated).getSubNodes().iterator().next()).getName();
        this.instance.addChildNode(childName);
        Assert.assertNotNull((Object)this.instance.getChild((String)childName).associatedNode);
        Assert.assertSame((Object)this.instance.getChild((String)childName).associatedNode, (Object)associated.getSubNode(childName));
        child1.addChildNode("grandchild");
        Assert.assertEquals((long)this.instance.numberOfSubNodes, (long)4L);
        Assert.assertEquals((long)this.instance.numberOfSubNodesWithObjects, (long)4L);
        System.out.println("---/// TEST EPISODE NODE 01 OK ///---");
    }

    @Test
    public void testEpisodeNode02() {
        this.instance = new EpisodeNode("node", null, this.e, null);
        this.instance.addSlot("type");
        Assert.assertEquals((long)this.instance.numberOfSubNodesWithObjects, (long)0L);
        ObjectNode o1 = this.instance.getEpisodeRoot().getParentChronobag().createObjectNode("obj1");
        ObjectNode o2 = this.instance.getEpisodeRoot().getParentChronobag().createObjectNode("obj2");
        this.instance.fillSlot("type", "obj1");
        Assert.assertEquals((long)this.instance.numberOfSubNodesWithObjects, (long)1L);
        this.instance.addChildNode("child");
        EpisodeNode child = this.instance.getChild("child");
        child.addSlot("type");
        child.getObjectSlot("type").addObject((ObjectNode)this.instance.getEpisodeRoot().getParentChronobag().objectNodes.get("obj1"), true);
        child.fillSlot("type", "obj2");
        Assert.assertEquals((long)child.getObjectSlot("type").getUsedObjects().size(), (long)2L);
        Assert.assertEquals((long)child.numberOfSubNodesWithObjects, (long)2L);
        Assert.assertEquals((long)this.instance.numberOfSubNodesWithObjects, (long)4L);
        child.getObjectSlot("type").emptySlot();
        Assert.assertTrue((boolean)child.getObjectSlot("type").getUsedObjects().isEmpty());
        Assert.assertEquals((long)child.numberOfSubNodesWithObjects, (long)0L);
        Assert.assertEquals((long)this.instance.numberOfSubNodesWithObjects, (long)2L);
        child.fillSlot("type", "obj1");
        child.fillSlot("type", "obj2");
        Assert.assertEquals((long)child.numberOfSubNodesWithObjects, (long)2L);
        Assert.assertEquals((long)this.instance.numberOfSubNodesWithObjects, (long)4L);
        Assert.assertEquals((long)o1.usedAt.size(), (long)2L);
        Assert.assertTrue((boolean)o1.usedAt.contains(child.getObjectSlot("type")));
        Assert.assertNull((Object)child.getObjectSlot("Other"));
        child.getObjectSlot("type").deleteSlot();
        Assert.assertNotNull((Object)child.getObjectSlot("Other"));
        Assert.assertEquals((long)child.numberOfSubNodesWithObjects, (long)2L);
        Assert.assertEquals((long)this.instance.numberOfSubNodesWithObjects, (long)4L);
        Assert.assertEquals((long)o1.usedAt.size(), (long)2L);
        Assert.assertTrue((boolean)o1.usedAt.contains(child.getObjectSlot("Other")));
        Assert.assertEquals((long)child.getObjectSlot("Other").getUsedObjects().size(), (long)2L);
        Assert.assertTrue((boolean)child.getObjectSlot("Other").getUsedObjects().contains(o1));
        Assert.assertTrue((boolean)child.getObjectSlot("Other").getUsedObjects().contains(o2));
        child.getObjectSlot("Other").deleteSlot();
        Assert.assertNull((Object)child.getObjectSlot("Other"));
        Assert.assertEquals((long)child.numberOfSubNodesWithObjects, (long)0L);
        Assert.assertEquals((long)this.instance.numberOfSubNodesWithObjects, (long)2L);
        Assert.assertEquals((long)o1.usedAt.size(), (long)1L);
        Assert.assertFalse((boolean)o1.usedAt.contains(child.getObjectSlot("Other")));
        System.out.println("---/// TEST EPISODE NODE 02 OK ///---");
    }

    @Test
    public void testEpisodeNode03() {
        Node associated = (Node)this.e.getParentChronobag().getMemory().getDecisionTree().topLevelGoals.values().iterator().next();
        this.instance = new EpisodeNode("node", null, this.e, associated);
        Episode e2 = new Episode(this.ch);
        EpisodeNode other = new EpisodeNode("node", null, e2, associated);
        Assert.assertFalse((this.e.getIdEpisode() == e2.getIdEpisode() ? 1 : 0) != 0);
        this.instance.addChildNode("child1");
        this.instance.addChildNode("child2");
        this.instance.addChildNode("child3");
        EpisodeNode n = this.instance.getChild("child3");
        n.addSlot("slot1");
        n.addSlot("slot2");
        ObjectNode obj1 = this.instance.getEpisodeRoot().getParentChronobag().createObjectNode("obj1");
        ObjectNode obj2 = this.instance.getEpisodeRoot().getParentChronobag().createObjectNode("obj2");
        ObjectNode obj3 = this.instance.getEpisodeRoot().getParentChronobag().createObjectNode("obj3");
        ObjectNode obj4 = this.instance.getEpisodeRoot().getParentChronobag().createObjectNode("obj4");
        n.fillSlot("slot1", "obj1");
        n.fillSlot("slot1", "obj2");
        n.fillSlot("slot2", "obj3");
        Assert.assertSame((Object)this.instance.numberOfCommonSubNodesWithObjects(this.instance.getChild("child1")), (Object)0);
        Assert.assertSame((Object)this.instance.numberOfCommonSubNodesWithObjects(other), (Object)1);
        other.addChildNode("child3");
        other.addChildNode("child4");
        other.addChildNode("child5");
        n = other.getChild("child3");
        n.addSlot("slot1");
        n.addSlot("slot2");
        n.fillSlot("slot1", "obj1");
        n.fillSlot("slot1", "obj4");
        n.fillSlot("slot2", "obj2");
        Assert.assertSame((Object)this.instance.numberOfCommonSubNodesWithObjects(other), (Object)3);
        Assert.assertEquals((long)this.instance.numberOfSubNodes, (long)3L);
        Assert.assertEquals((long)this.instance.numberOfSubNodesWithObjects, (long)6L);
        this.instance.mergeWith(other);
        Assert.assertEquals((long)this.instance.numberOfSubNodes, (long)5L);
        Assert.assertEquals((long)this.instance.numberOfSubNodesWithObjects, (long)10L);
        Assert.assertEquals((long)this.instance.getChildrenNodes().size(), (long)5L);
        EpisodeNode child1 = this.instance.getChild("child1");
        EpisodeNode child3 = this.instance.getChild("child3");
        Assert.assertSame((Object)child1, this.instance.getFirstChild().get(this.e.getIdEpisode()));
        Assert.assertSame((Object)child3, this.instance.getFirstChild().get(e2.getIdEpisode()));
        Assert.assertSame((Object)this.instance.getChild("child2"), child1.getSuccessor().get(this.e.idEpisode));
        Assert.assertSame((Object)this.instance.getChild("child3"), ((EpisodeNode)child1.getSuccessor().get(this.e.idEpisode)).getSuccessor().get(this.e.idEpisode));
        Assert.assertNull(((EpisodeNode)((EpisodeNode)child1.getSuccessor().get(this.e.idEpisode)).getSuccessor().get(this.e.idEpisode)).getSuccessor().get(this.e.idEpisode));
        Assert.assertSame((Object)this.instance.getChild("child4"), child3.getSuccessor().get(e2.idEpisode));
        Assert.assertSame((Object)this.instance.getChild("child5"), ((EpisodeNode)child3.getSuccessor().get(e2.idEpisode)).getSuccessor().get(e2.idEpisode));
        Assert.assertNull(((EpisodeNode)((EpisodeNode)child3.getSuccessor().get(e2.idEpisode)).getSuccessor().get(e2.idEpisode)).getSuccessor().get(e2.idEpisode));
        Assert.assertTrue((boolean)child1.getPredecessor().isEmpty());
        Assert.assertSame(child3.getPredecessor().get(this.e.idEpisode), (Object)this.instance.getChild("child2"));
        Assert.assertEquals((long)child3.slots.size(), (long)2L);
        Assert.assertTrue((boolean)((ObjectSlot)child3.slots.get("slot1")).getUsedObjects().contains(obj1));
        Assert.assertTrue((boolean)((ObjectSlot)child3.slots.get("slot1")).getUsedObjects().contains(obj2));
        Assert.assertTrue((boolean)((ObjectSlot)child3.slots.get("slot1")).getUsedObjects().contains(obj4));
        Assert.assertEquals((long)((ObjectSlot)child3.slots.get("slot1")).getUsedObjects().size(), (long)3L);
        Assert.assertTrue((boolean)((ObjectSlot)child3.slots.get("slot2")).getUsedObjects().contains(obj2));
        Assert.assertTrue((boolean)((ObjectSlot)child3.slots.get("slot2")).getUsedObjects().contains(obj3));
        Assert.assertEquals((long)((ObjectSlot)child3.slots.get("slot2")).getUsedObjects().size(), (long)2L);
        Assert.assertEquals((long)obj1.usedAt.size(), (long)1L);
        Assert.assertEquals((long)obj2.usedAt.size(), (long)2L);
        Assert.assertEquals((long)obj3.usedAt.size(), (long)1L);
        Assert.assertEquals((long)obj4.usedAt.size(), (long)1L);
        System.out.println("---/// TEST EPISODE NODE 03 OK ///---");
    }

    @Test
    public void TestEpisodeNode04() {
        Node associated = (Node)this.e.getParentChronobag().getMemory().getDecisionTree().topLevelGoals.values().iterator().next();
        this.instance = new EpisodeNode(associated.getName(), null, this.e, associated);
        ObjectNode obj1 = this.instance.getEpisodeRoot().getParentChronobag().createObjectNode("obj1");
        ObjectNode obj2 = this.instance.getEpisodeRoot().getParentChronobag().createObjectNode("obj2");
        ObjectNode obj3 = this.instance.getEpisodeRoot().getParentChronobag().createObjectNode("obj3");
        ObjectNode obj4 = this.instance.getEpisodeRoot().getParentChronobag().createObjectNode("obj4");
        this.instance.addChildNode("child1");
        this.instance.addChildNode("child2");
        this.instance.addChildNode("child3");
        this.instance.addSlot("slot");
        this.instance.fillSlot("slot", "obj1");
        this.instance.fillSlot("slot", "obj2");
        EpisodeNode n = this.instance.getChild("child3");
        n.addSlot("slot1");
        n.addSlot("slot2");
        n.fillSlot("slot1", "obj3");
        n.fillSlot("slot2", "obj4");
        Assert.assertEquals((long)obj1.usedAt.size(), (long)1L);
        Assert.assertEquals((long)obj2.usedAt.size(), (long)1L);
        Assert.assertEquals((long)obj3.usedAt.size(), (long)1L);
        Assert.assertEquals((long)obj4.usedAt.size(), (long)1L);
        n = this.instance.createCopy(null, this.e);
        Assert.assertSame((Object)this.instance.getAssociatedNode(), (Object)n.getAssociatedNode());
        Assert.assertNotSame((Object)this.instance, (Object)n);
        Assert.assertSame((Object)(this.instance.numberOfSubNodesWithObjects + 1), (Object)this.instance.numberOfCommonSubNodesWithObjects(n));
        Assert.assertNotSame((Object)this.instance.getChild("child1"), (Object)n.getChild("child1"));
        Assert.assertEquals((long)obj1.usedAt.size(), (long)2L);
        Assert.assertEquals((long)obj2.usedAt.size(), (long)2L);
        Assert.assertEquals((long)obj3.usedAt.size(), (long)2L);
        Assert.assertEquals((long)obj4.usedAt.size(), (long)2L);
        System.out.println("---/// TEST EPISODE NODE 04 OK ///---");
    }

    @Test
    public void TestEpisodeNode05() {
        Node associated = (Node)this.e.getParentChronobag().getMemory().getDecisionTree().topLevelGoals.values().iterator().next();
        this.instance = new EpisodeNode("node", null, this.e, associated);
        this.instance.addChildNode("child1");
        this.instance.addChildNode("child2");
        this.instance.addChildNode("child3");
        Assert.assertTrue((boolean)this.instance.getChild("child1").getPredecessor().isEmpty());
        Assert.assertTrue((this.instance.getChild("child1").getSuccessor().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((this.instance.getChild("child2").getPredecessor().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((this.instance.getChild("child2").getSuccessor().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((this.instance.getChild("child3").getPredecessor().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.instance.getChild("child3").getSuccessor().isEmpty());
        Assert.assertSame(this.instance.getChild("child1").getSuccessor().get(this.e.getIdEpisode()), (Object)this.instance.getChild("child2"));
        Assert.assertSame(this.instance.getChild("child2").getPredecessor().get(this.e.getIdEpisode()), (Object)this.instance.getChild("child1"));
        Assert.assertSame(this.instance.getChild("child2").getSuccessor().get(this.e.getIdEpisode()), (Object)this.instance.getChild("child3"));
        Assert.assertSame(this.instance.getChild("child3").getPredecessor().get(this.e.getIdEpisode()), (Object)this.instance.getChild("child2"));
        this.instance.getChild("child2").deleteNode();
        Assert.assertEquals((long)this.instance.children.size(), (long)2L);
        Assert.assertNotNull((Object)this.instance.getChild("child1"));
        Assert.assertNotNull((Object)this.instance.getChild("child3"));
        Assert.assertTrue((boolean)this.instance.getChild("child1").getPredecessor().isEmpty());
        Assert.assertTrue((this.instance.getChild("child1").getSuccessor().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((this.instance.getChild("child3").getPredecessor().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.instance.getChild("child3").getSuccessor().isEmpty());
        Assert.assertSame(this.instance.getChild("child1").getSuccessor().get(this.e.getIdEpisode()), (Object)this.instance.getChild("child3"));
        Assert.assertSame(this.instance.getChild("child3").getPredecessor().get(this.e.getIdEpisode()), (Object)this.instance.getChild("child1"));
        this.instance.getChild("child3").deleteNode();
        Assert.assertEquals((long)this.instance.children.size(), (long)1L);
        Assert.assertNotNull((Object)this.instance.getChild("child1"));
        Assert.assertTrue((boolean)this.instance.getChild("child1").getPredecessor().isEmpty());
        Assert.assertTrue((boolean)this.instance.getChild("child1").getSuccessor().isEmpty());
        System.out.println("---/// TEST EPISODE NODE 05 OK ///---");
    }

    @Test
    public void TestEpisodeNode06() {
        Node associated = (Node)this.e.getParentChronobag().getMemory().getDecisionTree().topLevelGoals.values().iterator().next();
        this.instance = new EpisodeNode(associated.getName(), null, this.e, associated);
        this.instance.addChildNode("child1");
        this.instance.addChildNode("child2");
        this.instance.addChildNode("child3");
        this.instance.addChildNode("child4");
        EpisodeNode n = this.instance.getChild("child1");
        n.addChildNode("child3");
        n.deleteNode();
        Assert.assertTrue((boolean)this.instance.validateNode(this.instance));
        Assert.assertEquals((long)this.instance.children.size(), (long)3L);
        Assert.assertTrue((boolean)this.instance.validateNode(this.instance.children.values()));
        this.instance.addChildNode("child5");
        n = this.instance.getChild("child5");
        n.addChildNode("child3");
        n.deleteNode();
        Assert.assertTrue((boolean)this.instance.validateNode(this.instance));
        Assert.assertEquals((long)this.instance.children.size(), (long)3L);
        Assert.assertTrue((boolean)this.instance.validateNode(this.instance.children.values()));
        n = this.instance.getChild("child2");
        n.deleteNode();
        n = this.instance.getChild("child3");
        n.deleteNode();
        n = this.instance.getChild("child4");
        n.deleteNode();
        Assert.assertTrue((boolean)this.instance.validateNode(this.instance));
        Assert.assertEquals((long)this.instance.children.size(), (long)0L);
        this.instance.addChildNode("child1");
        this.instance.addChildNode("child2");
        this.instance.addChildNode("child3");
        this.instance.addChildNode("child4");
        n = this.instance.getChild("child2");
        n.addChildNode("child4");
        n.deleteNode();
        Assert.assertTrue((boolean)this.instance.validateNode(this.instance));
        Assert.assertEquals((long)this.instance.children.size(), (long)3L);
        Assert.assertTrue((boolean)this.instance.validateNode(this.instance.children.values()));
        n = this.instance.getChild("child1");
        n.deleteNode();
        n = this.instance.getChild("child3");
        n.deleteNode();
        n = this.instance.getChild("child4");
        n.deleteNode();
        Assert.assertTrue((boolean)this.instance.validateNode(this.instance));
        Assert.assertEquals((long)this.instance.children.size(), (long)0L);
        this.instance.addChildNode("child1");
        this.instance.addChildNode("child2");
        this.instance.addChildNode("child3");
        this.instance.addChildNode("child4");
        n = this.instance.getChild("child3");
        n.addChildNode("child1");
        n.deleteNode();
        Assert.assertTrue((boolean)this.instance.validateNode(this.instance));
        Assert.assertEquals((long)this.instance.children.size(), (long)3L);
        Assert.assertTrue((boolean)this.instance.validateNode(this.instance.children.values()));
        n = this.instance.getChild("child1");
        n.deleteNode();
        n = this.instance.getChild("child2");
        n.deleteNode();
        n = this.instance.getChild("child4");
        n.deleteNode();
        Assert.assertTrue((boolean)this.instance.validateNode(this.instance));
        Assert.assertEquals((long)this.instance.children.size(), (long)0L);
        this.instance.addChildNode("child1");
        this.instance.addChildNode("child2");
        this.instance.addChildNode("child3");
        this.instance.addChildNode("child4");
        n = this.instance.getChild("child2");
        n.addChildNode("child3");
        n.deleteNode();
        Assert.assertTrue((boolean)this.instance.validateNode(this.instance));
        Assert.assertEquals((long)this.instance.children.size(), (long)3L);
        Assert.assertTrue((boolean)this.instance.validateNode(this.instance.children.values()));
        n = this.instance.getChild("child1");
        n.deleteNode();
        n = this.instance.getChild("child3");
        n.deleteNode();
        n = this.instance.getChild("child4");
        n.deleteNode();
        Assert.assertTrue((boolean)this.instance.validateNode(this.instance));
        Assert.assertEquals((long)this.instance.children.size(), (long)0L);
        this.instance.addChildNode("child1");
        this.instance.addChildNode("child2");
        this.instance.addChildNode("child3");
        this.instance.addChildNode("child4");
        n = this.instance.getChild("child2");
        n.addChildNode("child1");
        n.deleteNode();
        Assert.assertTrue((boolean)this.instance.validateNode(this.instance));
        Assert.assertEquals((long)this.instance.children.size(), (long)3L);
        Assert.assertTrue((boolean)this.instance.validateNode(this.instance.children.values()));
        n = this.instance.getChild("child1");
        n.deleteNode();
        n = this.instance.getChild("child3");
        n.deleteNode();
        n = this.instance.getChild("child4");
        n.deleteNode();
        Assert.assertTrue((boolean)this.instance.validateNode(this.instance));
        Assert.assertEquals((long)this.instance.children.size(), (long)0L);
        this.instance.addChildNode("child1");
        this.instance.addChildNode("child2");
        this.instance.addChildNode("child3");
        this.instance.addChildNode("child4");
        n = this.instance.getChild("child3");
        n.addChildNode("child4");
        n.deleteNode();
        Assert.assertTrue((boolean)this.instance.validateNode(this.instance));
        Assert.assertEquals((long)this.instance.children.size(), (long)3L);
        Assert.assertTrue((boolean)this.instance.validateNode(this.instance.children.values()));
        n = this.instance.getChild("child1");
        n.deleteNode();
        n = this.instance.getChild("child2");
        n.deleteNode();
        n = this.instance.getChild("child4");
        n.deleteNode();
        Assert.assertTrue((boolean)this.instance.validateNode(this.instance));
        Assert.assertEquals((long)this.instance.children.size(), (long)0L);
        this.instance.addChildNode("child1");
        this.instance.addChildNode("child2");
        this.instance.addChildNode("child3");
        this.instance.addChildNode("child4");
        n = this.instance.getChild("child1");
        n.addChildNode("child2");
        n.deleteNode();
        Assert.assertTrue((boolean)this.instance.validateNode(this.instance));
        Assert.assertEquals((long)this.instance.children.size(), (long)3L);
        Assert.assertTrue((boolean)this.instance.validateNode(this.instance.children.values()));
        n = this.instance.getChild("child2");
        n.deleteNode();
        n = this.instance.getChild("child3");
        n.deleteNode();
        n = this.instance.getChild("child4");
        n.deleteNode();
        Assert.assertTrue((boolean)this.instance.validateNode(this.instance));
        Assert.assertEquals((long)this.instance.children.size(), (long)0L);
        this.instance.addChildNode("child1");
        this.instance.addChildNode("child2");
        this.instance.addChildNode("child3");
        this.instance.addChildNode("child4");
        n = this.instance.getChild("child4");
        n.addChildNode("child3");
        n.deleteNode();
        Assert.assertTrue((boolean)this.instance.validateNode(this.instance));
        Assert.assertEquals((long)this.instance.children.size(), (long)3L);
        Assert.assertTrue((boolean)this.instance.validateNode(this.instance.children.values()));
        System.out.println("---/// TEST EPISODE NODE 06 OK ///---");
    }

    @Test
    public void TestEpisodeNode07() {
        Node associated = (Node)this.e.getParentChronobag().getMemory().getDecisionTree().topLevelGoals.values().iterator().next();
        this.instance = new EpisodeNode(associated.getName(), null, this.e, associated);
        this.instance.addChildNode("action.1.0");
        this.instance.addChildNode("action.1.1");
        this.instance.addChildNode("action.1.2");
        EpisodeNode child2 = this.instance.getChild("action.1.1");
        child2.addChildNode("intention.1.0");
        child2.addChildNode("intention.1.1");
        child2.addChildNode("intention.1.2");
        Assert.assertEquals((long)this.instance.numberOfSubNodes, (long)6L);
        child2.deleteNode();
        Assert.assertEquals((long)this.instance.children.size(), (long)5L);
        Assert.assertEquals((long)this.instance.numberOfSubNodes, (long)5L);
        Assert.assertFalse((boolean)this.instance.children.containsKey("action.1.1"));
        EpisodeNode grandChild = this.instance.getChild("intention.1.0");
        grandChild.deriveNodeTrace();
        Assert.assertTrue((boolean)this.instance.children.containsKey("action.1.1"));
        Assert.assertFalse((boolean)this.instance.children.containsKey("intention.1.0"));
        Assert.assertEquals((long)this.instance.children.size(), (long)5L);
        Assert.assertEquals((long)this.instance.numberOfSubNodes, (long)6L);
        child2 = this.instance.getChild("action.1.1");
        Assert.assertEquals((long)child2.children.size(), (long)1L);
        Assert.assertTrue((boolean)child2.children.containsKey("intention.1.0"));
        grandChild = this.instance.getChild("intention.1.1");
        grandChild.deriveNodeTrace();
        Assert.assertTrue((boolean)this.instance.children.containsKey("action.1.1"));
        Assert.assertFalse((boolean)this.instance.children.containsKey("intention.1.1"));
        Assert.assertEquals((long)this.instance.children.size(), (long)4L);
        Assert.assertEquals((long)this.instance.numberOfSubNodes, (long)6L);
        Assert.assertEquals((long)child2.children.size(), (long)2L);
        Assert.assertTrue((boolean)child2.children.containsKey("intention.1.0"));
        Assert.assertTrue((boolean)child2.children.containsKey("intention.1.1"));
        System.out.println("---/// TEST EPISODE NODE 07 OK ///---");
    }
}

