/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.episodic.episodes;

import cz.cuni.amis.pogamut.episodic.episodes.Chronobag;
import cz.cuni.amis.pogamut.episodic.episodes.Episode;
import cz.cuni.amis.pogamut.episodic.episodes.EpisodeNode;
import cz.cuni.amis.pogamut.episodic.episodes.ObjectNode;
import cz.cuni.amis.pogamut.episodic.episodes.ObjectSlot;
import cz.cuni.amis.pogamut.episodic.memory.AgentMemory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ObjectSlotTest {
    EpisodeNode node = null;
    ObjectSlot instance = null;

    @Before
    public void setUp() {
        AgentMemory mem = new AgentMemory();
        Chronobag ch = new Chronobag(mem.getIdGenerator(), mem);
        Episode e = new Episode(ch);
        this.node = new EpisodeNode("node", null, e, null);
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testObjectSlot01() {
        this.instance = new ObjectSlot(1, "slot type", this.node);
        Assert.assertEquals((long)this.instance.getId(), (long)1L);
        Assert.assertEquals((Object)this.instance.getType(), (Object)"slot type");
        Assert.assertSame((Object)this.instance.getParentNode(), (Object)this.node);
        Assert.assertTrue((boolean)this.instance.getUsedObjects().isEmpty());
        ObjectNode obj1 = new ObjectNode("object1", 2);
        ObjectNode obj2 = new ObjectNode("object2", 2);
        this.instance.addObject(obj1, true);
        this.instance.addObject(obj2, true);
        Assert.assertEquals((long)this.instance.getUsedObjects().size(), (long)2L);
        Assert.assertTrue((boolean)this.instance.getUsedObjects().contains(obj1));
        Assert.assertTrue((boolean)this.instance.getUsedObjects().contains(obj2));
        Assert.assertEquals((long)obj1.usedAt.size(), (long)1L);
        Assert.assertTrue((boolean)obj1.usedAt.contains(this.instance));
        this.instance.emptySlot();
        Assert.assertTrue((boolean)this.instance.getUsedObjects().isEmpty());
        Assert.assertTrue((boolean)obj1.usedAt.isEmpty());
        System.out.println("---/// TEST OBJECT SLOT 01 OK ///---");
    }

    @Test
    public void testObjectSlot02() {
        this.instance = new ObjectSlot(1, "slot type", this.node);
        ObjectNode obj1 = new ObjectNode("object1", 2);
        ObjectNode obj2 = new ObjectNode("object2", 2);
        this.instance.addObject(obj1, true);
        this.instance.addObject(obj2, true);
        Assert.assertEquals((long)this.instance.getUsedObjects().size(), (long)2L);
        Assert.assertTrue((boolean)this.instance.getUsedObjects().contains(obj1));
        Assert.assertTrue((boolean)this.instance.getUsedObjects().contains(obj2));
        Assert.assertNull(this.instance.getParentNode().slots.get("Other"));
        this.instance.deleteSlot();
        Assert.assertNotNull(this.instance.getParentNode().slots.get("Other"));
        ObjectSlot other = (ObjectSlot)this.instance.getParentNode().slots.get("Other");
        Assert.assertTrue((boolean)this.instance.getUsedObjects().isEmpty());
        Assert.assertEquals((long)other.getUsedObjects().size(), (long)2L);
        Assert.assertTrue((boolean)other.getUsedObjects().contains(obj1));
        Assert.assertTrue((boolean)other.getUsedObjects().contains(obj2));
        Assert.assertEquals((long)obj1.usedAt.size(), (long)1L);
        Assert.assertSame(obj1.usedAt.iterator().next(), (Object)other);
        Assert.assertEquals((long)obj2.usedAt.size(), (long)1L);
        Assert.assertSame(obj2.usedAt.iterator().next(), (Object)other);
        System.out.println("---/// TEST OBJECT SLOT 02 OK ///---");
    }
}

