/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.episodic.memory;

import cz.cuni.amis.pogamut.episodic.decisions.Action;
import cz.cuni.amis.pogamut.episodic.decisions.AtomicAction;
import cz.cuni.amis.pogamut.episodic.decisions.DecisionTree;
import cz.cuni.amis.pogamut.episodic.decisions.DecisionTreeTest;
import cz.cuni.amis.pogamut.episodic.decisions.Intention;
import cz.cuni.amis.pogamut.episodic.episodes.Chronobag;
import cz.cuni.amis.pogamut.episodic.episodes.Episode;
import cz.cuni.amis.pogamut.episodic.episodes.EpisodeNode;
import cz.cuni.amis.pogamut.episodic.episodes.ObjectNode;
import cz.cuni.amis.pogamut.episodic.episodes.ObjectSlot;
import cz.cuni.amis.pogamut.episodic.memory.AffordanceUsed;
import cz.cuni.amis.pogamut.episodic.memory.AgentMemory;
import cz.cuni.amis.pogamut.episodic.memory.Parameters;
import cz.cuni.amis.pogamut.episodic.schemas.SchemaCounter;
import cz.cuni.amis.pogamut.episodic.schemas.SchemaEpisodeNode;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.PriorityQueue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AgentMemoryTest {
    AgentMemory instance = null;
    DecisionTree dTree = null;

    @Before
    public void setUp() {
        this.dTree = DecisionTreeTest.sampleTree(10, 2, 3);
        for (Intention i : this.dTree.topLevelGoals.values()) {
            Action a = (Action)i.getSubNode("action.1.0").getSubNode("intention.1.0").getSubNode("action.0.0");
            a.addAtomicAction(new AtomicAction("SLEEP", 80));
        }
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testAgentMemory01() {
        System.out.println("---/// STARTING AGENT MEMORY 01 ///---");
        this.instance = new AgentMemory();
        Assert.assertNotNull((Object)this.instance);
        Assert.assertNotNull((Object)this.instance.getIdGenerator());
        Assert.assertNotNull((Object)this.instance.decisionTree);
        Assert.assertTrue((boolean)this.instance.decisionTree.topLevelGoals.isEmpty());
        Assert.assertNotNull((Object)this.instance.getPresentChronobag());
        Assert.assertTrue((boolean)this.instance.getPresentChronobag().getEpisodes().isEmpty());
        Assert.assertTrue((boolean)this.instance.getPastChrononags().isEmpty());
        Assert.assertNotNull((Object)this.instance.getSchemaBag());
        Assert.assertEquals((long)this.instance.getSchemaBag().getNumberOfNodes(), (long)0L);
        this.instance.initialize(this.dTree.topLevelGoals.values());
        Assert.assertFalse((boolean)this.instance.decisionTree.topLevelGoals.isEmpty());
        Assert.assertEquals((long)this.dTree.topLevelGoals.size(), (long)this.instance.getDecisionTree().topLevelGoals.size());
        Assert.assertEquals((long)this.instance.listeners.getListenerCount(), (long)0L);
        System.out.println("---/// TEST AGENT MEMORY 01 OK ///---");
    }

    @Test
    public void testAgentMemory02() {
        System.out.println("---/// STARTING AGENT MEMORY 02 ///---");
        String origHash = this.getParametersHash();
        int MAX_CHRONOBAG_NODES = Parameters.MAX_CHRONOBAG_NODES;
        Parameters.MAX_CHRONOBAG_NODES = 0;
        this.instance = new AgentMemory();
        this.instance.initialize(this.dTree.topLevelGoals.values());
        ArrayList<String> trace = new ArrayList<String>();
        ArrayList affs = new ArrayList();
        trace.add("action.0.0");
        trace.add("intention.1.0");
        trace.add("action.1.0");
        trace.add("intention.2.0");
        String time = "Mo, 03:44, day 0.";
        this.instance.addNewNode("atomic.0.0", trace, time, affs);
        trace.set(3, "intention.2.1");
        this.instance.addNewNode("atomic.0.0", trace, time, affs);
        trace.set(3, "intention.2.2");
        this.instance.addNewNode("atomic.0.0", trace, time, affs);
        trace.set(3, "intention.2.3");
        this.instance.addNewNode("atomic.0.0", trace, time, affs);
        Chronobag ch = this.instance.present;
        Assert.assertEquals((long)this.instance.getChronobags().size(), (long)1L);
        Assert.assertEquals((long)this.instance.schemas.getSchemaENodes().size(), (long)8L);
        time = "Tu, 03:44, day 1.";
        this.instance.addNewNode("SLEEP", trace, time, affs);
        Assert.assertEquals((long)this.instance.getChronobags().size(), (long)5L);
        Assert.assertEquals((long)this.instance.schemas.getSchemaENodes().size(), (long)9L);
        Assert.assertEquals((long)this.instance.past.size(), (long)4L);
        Parameters.MAX_CHRONOBAG_NODES = MAX_CHRONOBAG_NODES;
        String newHash = this.getParametersHash();
        Assert.assertTrue((boolean)newHash.equals(origHash));
        System.out.println("---/// TEST AGENT MEMORY 02 OK ///---");
    }

    @Test
    public void testAgentMemory03() {
        System.out.println("---/// STARTING AGENT MEMORY 03 ///---");
        String origHash = this.getParametersHash();
        int MAX_CHRONOBAG_NODES = Parameters.MAX_CHRONOBAG_NODES;
        int MAX_CHRONOBAG_LEVEL = Parameters.MAX_CHRONOBAG_LEVELS;
        Parameters.MAX_CHRONOBAG_NODES = 500;
        Parameters.MAX_CHRONOBAG_LEVELS = 1;
        this.instance = new AgentMemory();
        this.instance.initialize(this.dTree.topLevelGoals.values());
        ArrayList<String> trace = new ArrayList<String>();
        ArrayList affs = new ArrayList();
        trace.add("action.0.0");
        trace.add("intention.1.0");
        trace.add("action.1.0");
        trace.add("intention.2.0");
        String time = "Mo, 03:44, day 0.";
        this.instance.addNewNode("atomic.0.0", trace, time, affs);
        trace.set(3, "intention.2.1");
        this.instance.addNewNode("atomic.0.0", trace, time, affs);
        trace.set(3, "intention.2.2");
        this.instance.addNewNode("atomic.0.0", trace, time, affs);
        trace.set(3, "intention.2.3");
        this.instance.addNewNode("atomic.0.0", trace, time, affs);
        Chronobag ch = this.instance.present;
        Assert.assertEquals((long)ch.getEpisodes().size(), (long)4L);
        Assert.assertEquals((long)this.instance.getChronobags().size(), (long)1L);
        Assert.assertEquals((long)ch.getNumberOfEpisodeNodes(), (long)20L);
        Assert.assertEquals((long)this.instance.schemas.getSchemaENodes().size(), (long)8L);
        time = "Tu, 03:44, day 1.";
        this.instance.addNewNode("SLEEP", trace, time, affs);
        Assert.assertEquals((long)this.instance.getChronobags().size(), (long)2L);
        Assert.assertEquals((long)this.instance.past.size(), (long)1L);
        ch = (Chronobag)this.instance.past.iterator().next();
        Assert.assertEquals((long)ch.getNumberOfEpisodeNodes(), (long)21L);
        Assert.assertEquals((long)this.instance.schemas.getSchemaENodes().size(), (long)9L);
        Assert.assertEquals((long)ch.getEpisodes().size(), (long)4L);
        Parameters.MAX_CHRONOBAG_NODES = MAX_CHRONOBAG_NODES;
        Parameters.MAX_CHRONOBAG_LEVELS = MAX_CHRONOBAG_LEVEL;
        String newHash = this.getParametersHash();
        Assert.assertTrue((boolean)newHash.equals(origHash));
        System.out.println("---/// TEST AGENT MEMORY 03 OK ///---");
    }

    private void checkEpisodeNodes(AgentMemory mem) {
        HashSet<Integer> ids = new HashSet<Integer>();
        for (Chronobag c : mem.getChronobags()) {
            for (Episode e : c.getEpisodes()) {
                EpisodeNode n = e.getRoot();
                PriorityQueue<EpisodeNode> q = new PriorityQueue<EpisodeNode>();
                q.add(n);
                while (!q.isEmpty()) {
                    n = (EpisodeNode)q.poll();
                    Assert.assertFalse((boolean)ids.contains(n.getId()));
                    ids.add(n.getId());
                    for (EpisodeNode ch : n.getChildrenNodes()) {
                        q.add(ch);
                    }
                    if (n.getPredecessor().isEmpty() || n.getPredecessor().get(n.getEpisodeRoot().idEpisode) != n.getSuccessor().get(n.getEpisodeRoot().idEpisode)) continue;
                    boolean i = true;
                }
            }
        }
    }

    @Test
    public void testAgentMemory04() {
        System.out.println("---/// STARTING AGENT MEMORY 04 ///---");
        int MAX_CHRONOBAG_NODES = Parameters.MAX_CHRONOBAG_NODES;
        double CHRONOBAG_SCORE_NODE_THRESHOLD = Parameters.CHRONOBAG_SCORE_NODE_THRESHOLD;
        int LANDMARK_AGE_THRESHOLD = Parameters.LANDMARK_AGE_THRESHOLDS[0];
        Parameters.MAX_CHRONOBAG_NODES = 25;
        Parameters.LANDMARK_AGE_THRESHOLDS[0] = 10;
        Parameters.CHRONOBAG_SCORE_NODE_THRESHOLD = -1.0;
        this.instance = new AgentMemory();
        this.instance.initialize(this.dTree.topLevelGoals.values());
        ArrayList<String> trace = new ArrayList<String>();
        ArrayList affs = new ArrayList();
        trace.add("action.0.0");
        trace.add("intention.1.0");
        trace.add("action.1.0");
        trace.add("intention.2.0");
        String time = "Mo, 03:44, day 0.";
        this.instance.addNewNode("atomic.0.0", trace, time, affs);
        trace.set(3, "intention.2.1");
        this.instance.addNewNode("atomic.0.0", trace, time, affs);
        trace.set(3, "intention.2.2");
        this.instance.addNewNode("atomic.0.0", trace, time, affs);
        trace.set(3, "intention.2.3");
        this.instance.addNewNode("atomic.0.0", trace, time, affs);
        Chronobag ch = this.instance.present;
        time = "Tu, 03:44, day 1.";
        this.checkEpisodeNodes(this.instance);
        this.instance.addNewNode("SLEEP", trace, time, affs);
        this.checkEpisodeNodes(this.instance);
        this.testChronobagSequence(this.instance);
        int nodes = ch.getNumberOfEpisodeNodes();
        time = "Tu, 03:44, day 2.";
        this.instance.addNewNode("SLEEP", trace, time, affs);
        this.checkEpisodeNodes(this.instance);
        this.testChronobagSequence(this.instance);
        Assert.assertTrue((ch.getNumberOfEpisodeNodes() <= nodes ? 1 : 0) != 0);
        nodes = ch.getNumberOfEpisodeNodes();
        time = "Tu, 03:44, day 3.";
        this.instance.addNewNode("SLEEP", trace, time, affs);
        this.checkEpisodeNodes(this.instance);
        this.testChronobagSequence(this.instance);
        Assert.assertTrue((ch.getNumberOfEpisodeNodes() <= nodes ? 1 : 0) != 0);
        nodes = ch.getNumberOfEpisodeNodes();
        time = "Tu, 03:44, day 4.";
        this.instance.addNewNode("SLEEP", trace, time, affs);
        this.checkEpisodeNodes(this.instance);
        this.testChronobagSequence(this.instance);
        Assert.assertTrue((ch.getNumberOfEpisodeNodes() <= nodes ? 1 : 0) != 0);
        nodes = ch.getNumberOfEpisodeNodes();
        time = "Tu, 03:44, day 5.";
        this.instance.addNewNode("SLEEP", trace, time, affs);
        this.checkEpisodeNodes(this.instance);
        this.testChronobagSequence(this.instance);
        Assert.assertTrue((ch.getNumberOfEpisodeNodes() <= nodes ? 1 : 0) != 0);
        nodes = ch.getNumberOfEpisodeNodes();
        time = "Tu, 03:44, day 6.";
        this.instance.addNewNode("SLEEP", trace, time, affs);
        this.checkEpisodeNodes(this.instance);
        this.testChronobagSequence(this.instance);
        Assert.assertTrue((ch.getNumberOfEpisodeNodes() <= nodes ? 1 : 0) != 0);
        nodes = ch.getNumberOfEpisodeNodes();
        time = "Tu, 03:44, day 7.";
        this.instance.addNewNode("SLEEP", trace, time, affs);
        this.checkEpisodeNodes(this.instance);
        this.testChronobagSequence(this.instance);
        Assert.assertTrue((ch.getNumberOfEpisodeNodes() <= nodes ? 1 : 0) != 0);
        nodes = ch.getNumberOfEpisodeNodes();
        time = "Tu, 03:44, day 8.";
        this.instance.addNewNode("SLEEP", trace, time, affs);
        this.checkEpisodeNodes(this.instance);
        this.testChronobagSequence(this.instance);
        Assert.assertTrue((ch.getNumberOfEpisodeNodes() <= nodes ? 1 : 0) != 0);
        nodes = ch.getNumberOfEpisodeNodes();
        time = "Tu, 03:44, day 9.";
        this.instance.addNewNode("SLEEP", trace, time, affs);
        this.checkEpisodeNodes(this.instance);
        this.testChronobagSequence(this.instance);
        Assert.assertTrue((ch.getNumberOfEpisodeNodes() <= nodes ? 1 : 0) != 0);
        nodes = ch.getNumberOfEpisodeNodes();
        Assert.assertFalse((boolean)ch.isLandmark());
        time = "Tu, 03:44, day 10.";
        this.instance.addNewNode("SLEEP", trace, time, affs);
        this.checkEpisodeNodes(this.instance);
        Assert.assertTrue((ch.getNumberOfEpisodeNodes() <= nodes ? 1 : 0) != 0);
        nodes = ch.getNumberOfEpisodeNodes();
        time = "Tu, 03:44, day 10.";
        this.instance.addNewNode("SLEEP", trace, time, affs);
        Assert.assertTrue((ch.getNumberOfEpisodeNodes() == nodes ? 1 : 0) != 0);
        Assert.assertTrue((boolean)ch.isLandmark());
        Parameters.MAX_CHRONOBAG_NODES = MAX_CHRONOBAG_NODES;
        Parameters.LANDMARK_AGE_THRESHOLDS[0] = LANDMARK_AGE_THRESHOLD;
        Parameters.CHRONOBAG_SCORE_NODE_THRESHOLD = CHRONOBAG_SCORE_NODE_THRESHOLD;
        System.out.println("---/// TEST AGENT MEMORY 04 OK ///---");
    }

    private void testChronobagSequence(AgentMemory instance) {
        int total = 0;
        for (int l = 0; l < Parameters.MAX_CHRONOBAG_LEVELS; ++l) {
            Chronobag c = (Chronobag)instance.getChronobagSequenceEnds().get(l);
            while (c != null) {
                ++total;
                Assert.assertEquals((long)c.getLevel(), (long)l);
                Assert.assertEquals((long)(c.getAge().getMaxAge() - c.getAge().getMinAge() + 1), (long)Parameters.CHRONOBAG_INTERVAL_LENGHTS[l]);
                if ((c = c.getOlderChronobag()) == null) continue;
                Assert.assertTrue((c.getAge().getMinAge() > c.getYoungerChronobag().getAge().getMinAge() ? 1 : 0) != 0);
            }
        }
        Assert.assertEquals((long)total, (long)instance.getChronobags().size());
    }

    @Test
    public void testAgentMemory05() {
        System.out.println("---/// STARTING AGENT MEMORY 05 ///---");
        this.instance = new AgentMemory();
        this.instance.initialize(this.dTree.topLevelGoals.values());
        ArrayList<String> trace = new ArrayList<String>();
        ArrayList<AffordanceUsed> affs = new ArrayList<AffordanceUsed>();
        trace.add("action.0.0");
        trace.add("intention.1.0");
        trace.add("action.1.0");
        trace.add("intention.2.0");
        this.instance.addNewNode("atomic.0.0", trace, affs);
        trace.set(3, "intention.2.1");
        this.instance.addNewNode("atomic.0.0", trace, affs);
        trace.set(3, "intention.2.2");
        this.instance.addNewNode("atomic.0.0", trace, affs);
        trace.set(3, "intention.2.3");
        this.instance.addNewNode("atomic.0.0", trace, affs);
        trace.set(1, "intention.1.1");
        ArrayList<String> rootTrace = new ArrayList<String>();
        for (int i = 0; i < 10; ++i) {
            this.instance.addNewNode("atomic.0.0", trace, affs);
            rootTrace.add("intention.2.3");
            Assert.assertTrue((boolean)this.instance.nodeFinished("intention.2.3", rootTrace, true));
        }
        this.instance.getPresentChronobag().finish();
        Assert.assertEquals((long)28L, (long)this.instance.getPresentChronobag().getNumberOfEpisodeNodes());
        SchemaEpisodeNode sNode = ((Intention)this.instance.getDecisionTree().topLevelGoals.get("intention.2.3")).getAssociatedNode();
        Assert.assertTrue((sNode.getSingleCount() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)((SchemaCounter)sNode.getCounts().get((Object)0).iterator().next()).getCount(), (long)1L);
        Assert.assertEquals((long)((SchemaCounter)sNode.getCounts().get((Object)0).iterator().next()).getTotalCount(), (long)11L);
        affs.add(new AffordanceUsed("intention.1.1", "type", "obj"));
        for (int i = 0; i < 50; ++i) {
            trace.set(3, "intention.2.0");
            this.instance.addNewNode("atomic.0.0", trace, affs);
            rootTrace.add("intention.2.0");
            this.instance.nodeFinished("intention.2.0", rootTrace, true);
            trace.set(3, "intention.2.3");
            this.instance.addNewNode("atomic.0.0", trace, affs);
            rootTrace.add("intention.2.3");
            this.instance.nodeFinished("intention.2.3", rootTrace, true);
        }
        Assert.assertTrue((sNode.getSingleCount() == 51 ? 1 : 0) != 0);
        Episode e = this.instance.getPresentChronobag().getFirstEpisode();
        while (!e.getRoot().getName().equals("intention.2.3") || e.getRoot().getChild("action.1.0").getChild("intention.1.1") == null || e.getRoot().getNumberOfSubNodes() >= 7 || e.getRoot().getChild("action.1.0").getChild("intention.1.1").getObjectSlots().isEmpty()) {
            e = (Episode)e.next.iterator().next();
        }
        ObjectNode obj = (ObjectNode)this.instance.getPresentChronobag().objectNodes.get("obj");
        Assert.assertEquals((long)obj.usedAt.size(), (long)100L);
        Assert.assertEquals((long)e.getRoot().getNumberOfSubNodes(), (long)4L);
        EpisodeNode node = e.getRoot().getChild("action.1.0").getChild("intention.1.1").getChild("action.0.0").getChild("atomic.0.0");
        node.deleteNode();
        node = e.getRoot().getChild("action.1.0").getChild("intention.1.1").getChild("action.0.0");
        Assert.assertTrue((boolean)node.getChildrenNodes().isEmpty());
        node.deleteNode();
        node = e.getRoot().getChild("action.1.0").getChild("intention.1.1");
        Assert.assertTrue((boolean)node.getChildrenNodes().isEmpty());
        node.deleteNode();
        node = e.getRoot().getChild("action.1.0");
        Assert.assertTrue((boolean)node.getChildrenNodes().isEmpty());
        node = e.getRoot().getChild("action.1.0");
        Assert.assertEquals((long)node.getObjectSlots().size(), (long)1L);
        Assert.assertEquals((long)node.getObjectSlot("Other").getUsedObjects().size(), (long)1L);
        Assert.assertEquals((Object)((ObjectNode)node.getObjectSlot("Other").getUsedObjects().iterator().next()).getName(), (Object)"obj");
        e.deriveEpisode();
        Assert.assertEquals((long)obj.usedAt.size(), (long)100L);
        node = e.getRoot();
        Assert.assertEquals((long)1L, (long)node.getChildrenNodes().size());
        Assert.assertNotNull((Object)node.getChild("action.1.0"));
        node = node.getChild("action.1.0");
        Assert.assertTrue((boolean)node.getObjectSlots().isEmpty());
        Assert.assertEquals((long)1L, (long)node.getChildrenNodes().size());
        Assert.assertNotNull((Object)node.getChild("intention.1.1"));
        node = node.getChild("intention.1.1");
        Assert.assertEquals((long)node.getObjectSlots().size(), (long)1L);
        Assert.assertNotNull((Object)node.getObjectSlot("type"));
        Assert.assertEquals((long)node.getObjectSlot("type").getUsedObjects().size(), (long)1L);
        Assert.assertEquals((Object)((ObjectNode)node.getObjectSlot("type").getUsedObjects().iterator().next()).getName(), (Object)"obj");
        Assert.assertEquals((long)1L, (long)node.getChildrenNodes().size());
        Assert.assertNotNull((Object)node.getChild("action.0.0"));
        node = node.getChild("action.0.0");
        Assert.assertEquals((long)1L, (long)node.getChildrenNodes().size());
        Assert.assertNotNull((Object)node.getChild("atomic.0.0"));
        node = node.getChild("atomic.0.0");
        Assert.assertEquals((long)0L, (long)node.getChildrenNodes().size());
        node = e.getRoot().getChild("action.1.0").getChild("intention.1.1");
        node.deleteNode();
        e.deriveEpisode();
        node = e.getRoot();
        Assert.assertEquals((long)1L, (long)node.getChildrenNodes().size());
        Assert.assertNotNull((Object)node.getChild("action.1.0"));
        node = node.getChild("action.1.0");
        Assert.assertEquals((long)1L, (long)node.getChildrenNodes().size());
        Assert.assertNotNull((Object)node.getChild("intention.1.1"));
        node = node.getChild("intention.1.1");
        Assert.assertEquals((long)1L, (long)node.getChildrenNodes().size());
        Assert.assertNotNull((Object)node.getChild("action.0.0"));
        node = node.getChild("action.0.0");
        Assert.assertEquals((long)1L, (long)node.getChildrenNodes().size());
        Assert.assertNotNull((Object)node.getChild("atomic.0.0"));
        node = node.getChild("atomic.0.0");
        Assert.assertEquals((long)0L, (long)node.getChildrenNodes().size());
        System.out.println("---/// TEST AGENT MEMORY 05 OK ///---");
    }

    @Test
    public void testAgentMemory06() {
        System.out.println("---/// STARTING AGENT MEMORY 06 ///---");
        this.instance = new AgentMemory();
        this.instance.initialize(this.dTree.topLevelGoals.values());
        ArrayList<String> trace = new ArrayList<String>();
        ArrayList<AffordanceUsed> affs = new ArrayList<AffordanceUsed>();
        trace.add("action.0.0");
        trace.add("intention.1.0");
        trace.add("action.1.0");
        trace.add("intention.2.0");
        affs.add(new AffordanceUsed("action.0.0", "type1", "obj1"));
        affs.add(new AffordanceUsed("action.0.0", "type1", "obj2"));
        affs.add(new AffordanceUsed("action.0.0", "type2", "obj2"));
        affs.add(new AffordanceUsed("action.0.0", "type2", "obj3"));
        ArrayList<String> rootTrace = new ArrayList<String>();
        for (int i = 0; i < 50; ++i) {
            trace.set(3, "intention.2.0");
            this.instance.addNewNode("atomic.0.0", trace, affs);
            trace.set(2, "action.1.1");
            this.instance.addNewNode("atomic.0.0", trace, affs);
            trace.set(2, "action.1.0");
            rootTrace.add("intention.2.0");
            this.instance.nodeFinished("intention.2.0", rootTrace, true);
            trace.set(3, "intention.2.3");
            this.instance.addNewNode("atomic.0.0", trace, affs);
            rootTrace.add("intention.2.3");
            this.instance.nodeFinished("intention.2.3", rootTrace, true);
        }
        Episode e = this.instance.getPresentChronobag().getFirstEpisode();
        while (!e.getRoot().getName().equals("intention.2.0")) {
            e = (Episode)e.next.iterator().next();
        }
        Assert.assertTrue((e.episodeSimilarity((Episode)e.next.iterator().next()) == 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((e.episodeSimilarity((Episode)((Episode)e.next.iterator().next()).next.iterator().next()) == 1.0 ? 1 : 0) != 0);
        e.getRoot().getChild("action.1.0").deleteNode();
        e.getRoot().getChild("action.1.1").deleteNode();
        Assert.assertEquals((long)e.getRoot().getChildrenNodes().size(), (long)1L);
        Assert.assertNotNull((Object)e.getRoot().getChild("intention.1.0"));
        e.getRoot().getChild("intention.1.0").deleteNode();
        e.getRoot().getChild("action.0.0").deleteNode();
        e.getRoot().getChild("atomic.0.0").deleteNode();
        Assert.assertTrue((boolean)e.getRoot().getChildrenNodes().isEmpty());
        Assert.assertEquals((long)e.getRoot().getObjectSlots().size(), (long)1L);
        Assert.assertNotNull((Object)e.getRoot().getObjectSlot("Other"));
        ObjectSlot slot = e.getRoot().getObjectSlot("Other");
        Assert.assertEquals((long)slot.getUsedObjects().size(), (long)3L);
        e.deriveEpisode();
        EpisodeNode node = e.getRoot();
        slot = node.getObjectSlot("Other");
        Assert.assertNull((Object)slot);
        Assert.assertEquals((long)node.getChildrenNodes().size(), (long)2L);
        node = (EpisodeNode)node.getFirstChild().get(e.getIdEpisode());
        Assert.assertTrue((boolean)node.getObjectSlots().isEmpty());
        String name1 = node.getName();
        node = (EpisodeNode)node.getSuccessor().get(e.getIdEpisode());
        Assert.assertTrue((boolean)node.getObjectSlots().isEmpty());
        String name2 = node.getName();
        Assert.assertTrue((name1.equals("action.1.0") && name2.equals("action.1.1") || name1.equals("action.1.1") && name2.equals("action.1.0") ? 1 : 0) != 0);
        for (int i = 0; i < 2; ++i) {
            node = e.getRoot().getChild("action.1." + i).getChild("intention.1.0");
            Assert.assertNotNull((Object)node);
            Assert.assertTrue((boolean)node.getObjectSlots().isEmpty());
            Assert.assertEquals((long)node.getChildrenNodes().size(), (long)1L);
            node = node.getChild("action.0.0");
            Assert.assertNotNull((Object)node);
            Assert.assertEquals((long)node.getObjectSlots().size(), (long)2L);
            slot = node.getObjectSlot("type1");
            Assert.assertNotNull((Object)slot);
            Assert.assertEquals((long)slot.getUsedObjects().size(), (long)2L);
            ObjectNode obj = (ObjectNode)this.instance.getPresentChronobag().objectNodes.get("obj1");
            Assert.assertTrue((boolean)slot.getUsedObjects().contains(obj));
            obj = (ObjectNode)this.instance.getPresentChronobag().objectNodes.get("obj2");
            slot = node.getObjectSlot("type2");
            Assert.assertNotNull((Object)slot);
            Assert.assertEquals((long)slot.getUsedObjects().size(), (long)2L);
            Assert.assertTrue((boolean)slot.getUsedObjects().contains(obj));
            obj = (ObjectNode)this.instance.getPresentChronobag().objectNodes.get("obj3");
            Assert.assertTrue((boolean)slot.getUsedObjects().contains(obj));
            obj = (ObjectNode)this.instance.getPresentChronobag().objectNodes.get("obj1");
            Assert.assertFalse((boolean)slot.getUsedObjects().contains(obj));
            node = node.getChild("atomic.0.0");
            Assert.assertNotNull((Object)node);
            Assert.assertTrue((boolean)node.getChildrenNodes().isEmpty());
            Assert.assertTrue((boolean)node.getObjectSlots().isEmpty());
        }
        System.out.println("---/// TEST AGENT MEMORY 06 OK ///---");
    }

    @Test
    public void testAgentMemory07() {
        System.out.println("---/// STARTING AGENT MEMORY 07 ///---");
        int MAX_CHRONOBAG_NODES = Parameters.MAX_CHRONOBAG_NODES;
        int LANDMARK_AGE_THRESHOLD = Parameters.LANDMARK_AGE_THRESHOLDS[0];
        int MAX_CHRONOBAG_LEVELS = Parameters.MAX_CHRONOBAG_LEVELS;
        Parameters.MAX_CHRONOBAG_NODES = 25;
        Parameters.LANDMARK_AGE_THRESHOLDS[0] = 1;
        Parameters.MAX_CHRONOBAG_LEVELS = 1;
        this.instance = new AgentMemory();
        this.instance.initialize(this.dTree.topLevelGoals.values());
        ArrayList<String> trace = new ArrayList<String>();
        ArrayList affs = new ArrayList();
        trace.add("action.0.0");
        trace.add("intention.1.0");
        trace.add("action.1.0");
        trace.add("intention.2.0");
        this.instance.addNewNode("atomic.0.0", trace, "Mo, 08:00, day 0.", affs);
        for (int i = 0; i < 100; ++i) {
            this.instance.addNewNode("SLEEP", trace, "Mo, 08:00, day " + i + ".", affs);
        }
        Assert.assertEquals((long)this.instance.getChronobags().size(), (long)100L);
        Parameters.MAX_CHRONOBAG_NODES = MAX_CHRONOBAG_NODES;
        Parameters.LANDMARK_AGE_THRESHOLDS[0] = LANDMARK_AGE_THRESHOLD;
        Parameters.MAX_CHRONOBAG_LEVELS = MAX_CHRONOBAG_LEVELS;
        System.out.println("---/// TEST AGENT MEMORY 07 OK ///---");
    }

    @Test
    public void testAgentMemory08() {
        System.out.println("---/// STARTING AGENT MEMORY 08 ///---");
        int MAX_CHRONOBAG_NODES = Parameters.MAX_CHRONOBAG_NODES;
        int LANDMARK_AGE_THRESHOLD = Parameters.LANDMARK_AGE_THRESHOLDS[0];
        int MAX_CHRONOBAG_LEVELS = Parameters.MAX_CHRONOBAG_LEVELS;
        Parameters.MAX_CHRONOBAG_NODES = 200;
        Parameters.LANDMARK_AGE_THRESHOLDS[0] = 10;
        Parameters.MAX_CHRONOBAG_LEVELS = 4;
        this.instance = new AgentMemory();
        this.instance.initialize(this.dTree.topLevelGoals.values());
        ArrayList<String> trace = new ArrayList<String>();
        ArrayList affs = new ArrayList();
        trace.add("action.0.0");
        trace.add("intention.1.0");
        trace.add("action.1.0");
        trace.add("intention.2.0");
        this.instance.addNewNode("atomic.0.0", trace, "Mo, 08:00, day 0.", affs);
        for (int i = 0; i < 10; ++i) {
            this.instance.addNewNode("SLEEP", trace, "Mo, 08:00, day " + i + ".", affs);
        }
        Assert.assertTrue((this.instance.getChronobags().size() > 10 ? 1 : 0) != 0);
        Parameters.MAX_CHRONOBAG_NODES = MAX_CHRONOBAG_NODES;
        Parameters.LANDMARK_AGE_THRESHOLDS[0] = LANDMARK_AGE_THRESHOLD;
        Parameters.MAX_CHRONOBAG_LEVELS = MAX_CHRONOBAG_LEVELS;
        System.out.println("---/// TEST AGENT MEMORY 08 OK ///---");
    }

    private String getParametersHash() {
        Field[] fields;
        String hash = "";
        for (Field field : fields = Parameters.class.getDeclaredFields()) {
            try {
                if (field.getType().isArray()) {
                    int lenght = Array.getLength(field.get(field));
                    for (int i = 0; i < lenght; ++i) {
                        hash = hash + Array.get(field.get(field), i);
                    }
                    continue;
                }
                hash = hash + field.get(field).toString();
            }
            catch (Exception e) {
                System.out.println("Memory test error: could not retrieve parameter value - " + e);
            }
        }
        return hash;
    }
}

