/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.episodic.schemas;

import cz.cuni.amis.pogamut.episodic.decisions.Action;
import cz.cuni.amis.pogamut.episodic.decisions.DecisionTree;
import cz.cuni.amis.pogamut.episodic.decisions.DecisionTreeTest;
import cz.cuni.amis.pogamut.episodic.decisions.Intention;
import cz.cuni.amis.pogamut.episodic.decisions.Node;
import cz.cuni.amis.pogamut.episodic.memory.AffordanceUsed;
import cz.cuni.amis.pogamut.episodic.memory.AgentMemory;
import cz.cuni.amis.pogamut.episodic.schemas.SchemaBag;
import cz.cuni.amis.pogamut.episodic.schemas.SchemaCounter;
import cz.cuni.amis.pogamut.episodic.schemas.SchemaEpisodeNode;
import cz.cuni.amis.pogamut.episodic.schemas.SchemaObjectNode;
import cz.cuni.amis.pogamut.episodic.schemas.SchemaSlot;
import cz.cuni.amis.pogamut.episodic.schemas.SlotContent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SchemaBagTest {
    DecisionTree dTree = null;
    SchemaBag instance = null;

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testSchemaBag01() {
        AgentMemory mem = new AgentMemory();
        this.instance = new SchemaBag(mem.getIdGenerator(), mem);
        Assert.assertTrue((boolean)this.instance.counters.isEmpty());
        Assert.assertSame((Object)this.instance.memory, (Object)mem);
        Assert.assertSame((Object)this.instance.idGenerator, (Object)mem.getIdGenerator());
        Assert.assertTrue((boolean)this.instance.schemaENodes.isEmpty());
        Assert.assertTrue((boolean)this.instance.schemaONodes.isEmpty());
        Assert.assertEquals((long)this.instance.getNumberOfNodes(), (long)0L);
        System.out.println("---/// TEST SCHEMA BAG 01 OK ///---");
    }

    @Test
    public void testSchemaBag02() {
        AgentMemory mem = new AgentMemory();
        this.instance = new SchemaBag(mem.getIdGenerator(), mem);
        Collection col = null;
        HashSet<SchemaEpisodeNode> cole = new HashSet<SchemaEpisodeNode>();
        HashSet<SlotContent> colc = new HashSet<SlotContent>();
        col = this.instance.getAllExistingSubSets(cole, colc, 0);
        Assert.assertTrue((boolean)col.isEmpty());
        col = this.instance.getAllExistingSubSets(cole, colc, 1);
        Assert.assertTrue((boolean)col.isEmpty());
        Intention n1 = new Intention("intention1", 0);
        Intention n2 = new Intention("intention2", 0);
        Action n3 = new Action("action1", 0);
        Action n4 = new Action("action2", 0);
        SchemaEpisodeNode node1 = new SchemaEpisodeNode((Node)n1, 1, "n1");
        SchemaEpisodeNode node2 = new SchemaEpisodeNode((Node)n2, 2, "n2");
        SchemaEpisodeNode node3 = new SchemaEpisodeNode((Node)n3, 3, "n3");
        SchemaEpisodeNode node4 = new SchemaEpisodeNode((Node)n4, 4, "n4");
        cole.add(node1);
        cole.add(node2);
        cole.add(node3);
        cole.add(node4);
        SchemaSlot slot1 = new SchemaSlot(1, "type1");
        SchemaSlot slot2 = new SchemaSlot(2, "type2");
        SchemaObjectNode obj1 = new SchemaObjectNode(3, "object1");
        SchemaObjectNode obj2 = new SchemaObjectNode(4, "object2");
        SlotContent content11 = new SlotContent(5, slot1, obj1);
        SlotContent content12 = new SlotContent(6, slot1, obj2);
        SlotContent content21 = new SlotContent(7, slot2, obj1);
        SlotContent content22 = new SlotContent(8, slot2, obj2);
        colc.add(content11);
        colc.add(content12);
        colc.add(content21);
        colc.add(content22);
        Assert.assertEquals((long)this.instance.counters.totalSize(), (long)0L);
        this.instance.increaseCounts(cole, colc, 8);
        Assert.assertEquals((long)this.instance.counters.totalSize(), (long)((int)Math.pow(2.0, 8.0) - 1));
        col = this.instance.getAllExistingSubSets(cole, colc, 0);
        Assert.assertTrue((boolean)col.isEmpty());
        col = this.instance.getAllExistingSubSets(cole, colc, 1);
        Assert.assertEquals((long)col.size(), (long)(colc.size() + cole.size()));
        col = this.instance.getAllExistingSubSets(cole, colc, 2);
        Assert.assertEquals((long)col.size(), (long)(colc.size() + cole.size() + (colc.size() + cole.size()) * (colc.size() + cole.size() - 1) / 2));
        col = this.instance.getAllExistingSubSets(cole, colc, 8);
        Assert.assertEquals((long)col.size(), (long)((int)Math.pow(2.0, 8.0) - 1));
        System.out.println("---/// TEST SCHEMA BAG 02 OK ///---");
    }

    @Test
    public void testSchemaBag03() {
        AgentMemory mem = new AgentMemory();
        this.dTree = DecisionTreeTest.sampleTree(15, 2, 5);
        Assert.assertNotNull((Object)this.dTree);
        mem.initialize(this.dTree.topLevelGoals.values());
        this.instance = new SchemaBag(mem.getIdGenerator(), mem);
        ArrayList<String> trace = new ArrayList<String>();
        trace.add("intention.2.0");
        trace.add("action.1.0");
        trace.add("intention.1.0");
        trace.add("action.0.0");
        ArrayList<AffordanceUsed> affs = new ArrayList<AffordanceUsed>();
        affs.add(new AffordanceUsed("intention.2.0", "intention.2.0-slot", "objectName"));
        this.instance.updateSchema("atomic.0.0", trace, affs);
        this.instance.updateSchema("atomic.0.0", trace, affs);
        SchemaEpisodeNode node = ((Intention)mem.getDecisionTree().topLevelGoals.get("intention.2.0")).getAssociatedNode();
        Assert.assertEquals((Object)node.getSingleCount(), (Object)1);
        Assert.assertEquals((long)node.getCounts().get((Object)0).size(), (long)1L);
        Assert.assertEquals((long)((SchemaCounter)node.getCounts().get((Object)0).iterator().next()).getCount(), (long)1L);
        Assert.assertEquals((long)((SchemaCounter)node.getCounts().get((Object)0).iterator().next()).getTotalCount(), (long)2L);
        Collection colo = this.instance.getSchemaONodes();
        Assert.assertEquals((long)colo.size(), (long)1L);
        Assert.assertTrue((boolean)((SchemaObjectNode)colo.iterator().next()).getName().equals("objectName"));
        Assert.assertEquals((long)((SchemaObjectNode)colo.iterator().next()).getSlotContents().size(), (long)1L);
        SlotContent content = (SlotContent)((SchemaObjectNode)colo.iterator().next()).getSlotContents().iterator().next();
        Assert.assertEquals((long)content.getCounts().get((Object)0).size(), (long)1L);
        Assert.assertEquals((long)((SchemaCounter)content.getCounts().get((Object)0).iterator().next()).getCount(), (long)1L);
        Assert.assertEquals((long)((SchemaCounter)content.getCounts().get((Object)0).iterator().next()).getTotalCount(), (long)2L);
        Collection counters = content.getCounts().get((Object)node.getId());
        SchemaCounter counter = null;
        for (SchemaCounter c : counters) {
            if (!c.checkNode(Integer.valueOf(node.getId()))) continue;
            counter = c;
        }
        Assert.assertNotNull(counter);
        Assert.assertEquals((long)counter.getContentsNodes().size(), (long)1L);
        Assert.assertEquals((long)counter.getENodes().size(), (long)1L);
        Assert.assertSame(counter.getContentsNodes().iterator().next(), (Object)content);
        Assert.assertSame(counter.getENodes().iterator().next(), (Object)node);
        Assert.assertEquals((long)counter.getCount(), (long)1L);
        Assert.assertEquals((long)counter.getTotalCount(), (long)2L);
        System.out.println("---/// TEST SCHEMA BAG 03 OK ///---");
    }

    @Test
    public void testSchemaBag04() {
        AgentMemory mem = new AgentMemory();
        this.instance = new SchemaBag(mem.getIdGenerator(), mem);
        HashSet<SchemaEpisodeNode> cole = new HashSet<SchemaEpisodeNode>();
        HashSet<SlotContent> colc = new HashSet<SlotContent>();
        Intention n1 = new Intention("intention1", 0);
        Action n2 = new Action("action2", 0);
        SchemaEpisodeNode node1 = new SchemaEpisodeNode((Node)n1, 1, "n1");
        SchemaEpisodeNode node2 = new SchemaEpisodeNode((Node)n2, 2, "n2");
        cole.add(node1);
        cole.add(node2);
        SchemaSlot slot1 = new SchemaSlot(0, "type1");
        SchemaSlot slot2 = new SchemaSlot(0, "type2");
        SchemaObjectNode obj1 = new SchemaObjectNode(0, "object1");
        SlotContent content1 = new SlotContent(6, slot1, obj1);
        SlotContent content2 = new SlotContent(7, slot2, obj1);
        colc.add(content1);
        colc.add(content2);
        this.instance.increaseCounts(cole, colc, 2);
        colc.remove(content1);
        cole.remove(node2);
        SchemaCounter counter = this.instance.getCounter(cole, colc, 2);
        Assert.assertEquals((long)counter.key, (long)8L);
        Assert.assertTrue((boolean)counter.getContentsNodes().contains(content2));
        Assert.assertEquals((long)counter.getContentsNodes().size(), (long)1L);
        Assert.assertTrue((boolean)counter.getENodes().contains(node1));
        Assert.assertEquals((long)counter.getENodes().size(), (long)1L);
        colc.remove(content2);
        colc.add(content1);
        cole.remove(node1);
        cole.add(node2);
        counter = this.instance.getCounter(cole, colc, 2);
        Assert.assertEquals((long)counter.key, (long)8L);
        Assert.assertTrue((boolean)counter.getContentsNodes().contains(content1));
        Assert.assertEquals((long)counter.getContentsNodes().size(), (long)1L);
        Assert.assertTrue((boolean)counter.getENodes().contains(node2));
        Assert.assertEquals((long)counter.getENodes().size(), (long)1L);
        System.out.println("---/// TEST SCHEMA BAG 04 OK ///---");
    }
}

