/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.episodic.schemas;

import cz.cuni.amis.pogamut.episodic.decisions.Intention;
import cz.cuni.amis.pogamut.episodic.decisions.Node;
import cz.cuni.amis.pogamut.episodic.schemas.SchemaCounter;
import cz.cuni.amis.pogamut.episodic.schemas.SchemaEpisodeNode;
import cz.cuni.amis.pogamut.episodic.schemas.SchemaObjectNode;
import cz.cuni.amis.pogamut.episodic.schemas.SchemaSlot;
import cz.cuni.amis.pogamut.episodic.schemas.SlotContent;
import java.util.HashSet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SlotContentTest {
    SlotContent instance = null;

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testSlotContent01() {
        SchemaSlot slot = new SchemaSlot(1, "type");
        SchemaObjectNode obj = new SchemaObjectNode(2, "object");
        this.instance = new SlotContent(123, slot, obj);
        Assert.assertEquals((long)this.instance.getId(), (long)123L);
        Assert.assertSame((Object)this.instance.getObject(), (Object)obj);
        Assert.assertSame((Object)this.instance.getSlot(), (Object)slot);
        Assert.assertTrue((boolean)this.instance.getCounts().isEmpty());
        HashSet colE = new HashSet();
        HashSet<SlotContent> colC = new HashSet<SlotContent>();
        colC.add(this.instance);
        SchemaCounter count = new SchemaCounter(this.instance.getId(), colE, colC);
        Assert.assertEquals((long)this.instance.getCounts().size(), (long)1L);
        Assert.assertEquals((long)this.instance.getCounts().get((Object)0).size(), (long)1L);
        Assert.assertSame(this.instance.getCounts().get((Object)0).iterator().next(), (Object)count);
        System.out.println("---/// TEST SLOT CONTENT 01 OK ///---");
    }

    @Test
    public void testSlotContent02() {
        SchemaSlot slot1 = new SchemaSlot(1, "type1");
        SchemaSlot slot2 = new SchemaSlot(2, "type2");
        SchemaObjectNode obj1 = new SchemaObjectNode(3, "object1");
        SchemaObjectNode obj2 = new SchemaObjectNode(4, "object2");
        SlotContent content11 = new SlotContent(5, slot1, obj1);
        SlotContent content12 = new SlotContent(6, slot1, obj2);
        SlotContent content21 = new SlotContent(7, slot2, obj1);
        SlotContent content22 = new SlotContent(8, slot2, obj2);
        Intention node = new Intention("intention", 0);
        SchemaEpisodeNode schemaENode = new SchemaEpisodeNode((Node)node, 10, "episodeNode");
        HashSet<SlotContent> col1 = new HashSet<SlotContent>();
        col1.add(content11);
        HashSet<SlotContent> col2 = new HashSet<SlotContent>();
        col2.add(content11);
        col2.add(content12);
        col2.add(content21);
        HashSet cole1 = new HashSet();
        HashSet<SchemaEpisodeNode> cole2 = new HashSet<SchemaEpisodeNode>();
        cole2.add(schemaENode);
        int hash = content11.id;
        SchemaCounter c11 = new SchemaCounter(hash, cole1, col1);
        hash = content11.id + content12.id + content21.id;
        SchemaCounter c22 = new SchemaCounter(hash += schemaENode.id, cole2, col2);
        c11.increaseCount();
        c22.increaseCount();
        c22.increaseCount();
        Assert.assertEquals((long)content11.getCounts().size(), (long)2L);
        Assert.assertEquals((long)content12.getCounts().size(), (long)1L);
        Assert.assertEquals((long)content21.getCounts().size(), (long)1L);
        Assert.assertEquals((long)content22.getCounts().size(), (long)0L);
        Assert.assertSame(content12.getCounts().get((Object)(hash - content12.id)).iterator().next(), (Object)c22);
        Assert.assertSame(content21.getCounts().get((Object)(hash - content21.id)).iterator().next(), (Object)c22);
        Assert.assertSame(content11.getCounts().get((Object)(hash - content11.id)).iterator().next(), (Object)c22);
        Assert.assertSame(content11.getCounts().get((Object)0).iterator().next(), (Object)c11);
        Assert.assertEquals((long)((SchemaCounter)content11.getCounts().get((Object)0).iterator().next()).getCount(), (long)1L);
        Assert.assertTrue((boolean)c11.getContentsNodes().contains(content11));
        Assert.assertEquals((long)c11.getContentsNodes().size(), (long)1L);
        Assert.assertTrue((boolean)c11.getENodes().isEmpty());
        Assert.assertTrue((boolean)c22.getContentsNodes().contains(content11));
        Assert.assertTrue((boolean)c22.getContentsNodes().contains(content12));
        Assert.assertTrue((boolean)c22.getContentsNodes().contains(content21));
        Assert.assertTrue((boolean)c22.getContentsNodes().contains(content11));
        Assert.assertEquals((long)c22.getContentsNodes().size(), (long)3L);
        Assert.assertTrue((boolean)c22.getENodes().contains(schemaENode));
        Assert.assertEquals((long)c22.getENodes().size(), (long)1L);
        Assert.assertEquals((long)((SchemaCounter)content11.getCounts().get((Object)(hash - content11.id)).iterator().next()).getCount(), (long)2L);
        System.out.println("---/// TEST SLOT CONTENT 02 OK ///---");
    }
}

