package cz.cuni.amis.pogamut.defcon.example;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.util.LinkedList;
import java.util.List;
import java.util.Map.Entry;
import java.util.SortedMap;
import java.util.TreeMap;

import javax.imageio.ImageIO;

import cz.cuni.amis.pogamut.defcon.agent.impl.DefConAgentLogicController;
import cz.cuni.amis.pogamut.defcon.ai.fleetai.IFleetAI;
import cz.cuni.amis.pogamut.defcon.base3d.worldview.object.DefConLocation;
import cz.cuni.amis.pogamut.defcon.communication.messages.commands.RequestGameSpeed;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.AirBase;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.Fleet;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.Silo;
import cz.cuni.amis.pogamut.defcon.communication.worldview.NativeMapSource;
import cz.cuni.amis.pogamut.defcon.communication.worldview.modules.bitmap.BitmapMapSource;
import cz.cuni.amis.pogamut.defcon.communication.worldview.modules.managers.buildings.BuildingPlacementProvider;
import cz.cuni.amis.pogamut.defcon.communication.worldview.modules.managers.buildings.BuildingsManager;
import cz.cuni.amis.pogamut.defcon.communication.worldview.modules.managers.buildings.BuildingsManager.BuildingWithAI;
import cz.cuni.amis.pogamut.defcon.communication.worldview.modules.managers.fleets.FleetsManager;
import cz.cuni.amis.pogamut.defcon.communication.worldview.modules.managers.fleets.IPlacingFinishedListener;
import cz.cuni.amis.pogamut.defcon.communication.worldview.polygons.GameMapInfoPolygons;
import cz.cuni.amis.pogamut.defcon.communication.worldview.polygons.loaders.borders.FilePrecomputedBordersSaver;
import cz.cuni.amis.pogamut.defcon.consts.GameSpeed;
import cz.cuni.amis.pogamut.defcon.consts.UnitType;
import cz.cuni.amis.pogamut.defcon.utils.closestpoints.ClosestPointsLookUp;
import cz.cuni.amis.pogamut.defcon.utils.closestpoints.ClosestPointsLookUp.ClosestPoints;
import cz.cuni.amis.pogamut.defcon.utils.closestpoints.ClosestPointsManager;
import cz.cuni.amis.pogamut.defcon.utils.quadtree.QuadTree;
import cz.cuni.amis.pogamut.defcon.utils.quadtree.QuadTreesManager;
import cz.cuni.amis.utils.exception.PogamutException;

/**
 * Example of a bot.
 * 
 * @author Radek 'Black_Hand' Pibil
 * 
 */
public class ExampleBotLogicController extends
		DefConAgentLogicController<ExampleBot> {

	protected LinkedList<QuadTree> placeableWaterQuadTrees =
			new LinkedList<QuadTree>();
	protected LinkedList<LinkedList<QuadTree>> enemyQuadTrees =
			new LinkedList<LinkedList<QuadTree>>();
	protected GameMapInfoPolygons mapInfo;
	protected ClosestPointsManager closestPoints;
	protected ClosestPointsLookUp lookup;
	protected QuadTreesManager qTreesManager;
	protected BuildingPlacementProvider placementProvider;

	/**
	 * Since this bot is implemented as a state machine we have to declare
	 * states.
	 * 
	 * @author Radek 'Black_Hand' Pibil
	 * 
	 */
	protected enum PrecomputingStage {
		START,
		CREATING_GAMEMAP_POLYS,
		FINISHED_GAMEMAP_POLYS,
		CREATING_QUADTREES,
		FINISHED_QUADTREES,
		CREATING_CLOSEST_POINTS,
		PLACING_SHIPS,
		PLACING_RADAR,
		PLACING_SILO,
		PLACING_AIR_BASE,
		ASSIGN_BUILDING_AIS,
		DONE
	};

	protected PrecomputingStage precomputingStage = PrecomputingStage.START;

	protected final PrecomputingStage[] buildingPlacementOrdering =
			new PrecomputingStage[] {
					PrecomputingStage.PLACING_RADAR,
					PrecomputingStage.PLACING_SILO,
					PrecomputingStage.PLACING_AIR_BASE
	};

	@Override
	public void firstGameLogic() {
		getLog().addConsoleHandler();

		getLog().info("Logic start");

		act(new RequestGameSpeed(GameSpeed.FAST));

		fleetsManager = new FleetsManager(this);
		buildingsManager = new BuildingsManager(this);

		permuteBuildingPlaccementOrdering();

		createGameMapInfoPolygons();
	}

	protected static final int BUILDING_PLACEMENT_TRANSPOSITIONS = 5;

	protected void permuteBuildingPlaccementOrdering() {
		int transpositions = BUILDING_PLACEMENT_TRANSPOSITIONS;

		while (transpositions > 0) {
			int first = getRandom().nextInt(buildingPlacementOrdering.length);
			int second = getRandom().nextInt(buildingPlacementOrdering.length);

			if (first == second)
				continue;

			PrecomputingStage tmp = buildingPlacementOrdering[first];
			buildingPlacementOrdering[first] = buildingPlacementOrdering[second];
			buildingPlacementOrdering[second] = tmp;

			--transpositions;
		}
	}

	protected int placementIndex = 0;

	protected PrecomputingStage getNextBuildingPlacementStage() {

		if (placementIndex >= buildingPlacementOrdering.length)
			return PrecomputingStage.ASSIGN_BUILDING_AIS;

		return buildingPlacementOrdering[placementIndex++];
	}

	/**
	 * Prepares, construct and triggers processing of game map analysis.
	 */
	protected void createGameMapInfoPolygons() {
		getLog().info("Creating GameMapInfoPolygons");
		precomputingStage = PrecomputingStage.CREATING_GAMEMAP_POLYS;

		try {
			File mapBitmaps = new File("./AI/javabot/Bitmaps/Territories");

			FilenameFilter filter = new FilenameFilter() {

				@Override
				public boolean accept(File dir, String name) {
					return name.endsWith(".bmp");
				}
			};

			int territories_count = mapBitmaps.listFiles(filter).length;

			BufferedImage[] territories = new
					BufferedImage[territories_count];

			int i = 0;

			for (File bitmap_file : mapBitmaps.listFiles(filter)) {
				territories[i] = ImageIO.read(bitmap_file);
				++i;
			}

			BufferedImage sailable = ImageIO.read(new File(
					"./AI/javabot/Bitmaps/sailable.bmp"));

			SortedMap<Integer, int[]> enemies = new TreeMap<Integer,
					int[]>();

			for (int enemyId : agent.getWorldView().getGameInfo()
					.getEnemyTeamIds()) {
				enemies.put(enemyId, agent.getWorldView().getGameInfo()
						.getTeamTerritories(enemyId));
			}

			flagChecker = new BitmapMapSource(territories,
					gameInfo.getOwnTeamTerritories(),
					enemies,
					sailable,
					getLog());

			// flagChecker = new NativeMapSource(gameInfo, getLog());

			// mapInfo = new GameMapInfoPolygons(agent, flagChecker,
			// null, getLog());

			mapInfo = new GameMapInfoPolygons(agent, flagChecker,
					"./AI/javabot/Preprocessed/", getLog());

			// mapInfo.saveBorders(new FilePrecomputedBordersSaver(
			// "./AI/javabot/Preprocessed/"));
		} catch (Exception e) {
			if (e.getMessage() != null)
				getLog().info(e.getMessage());
			throw new PogamutException(e, this);
		}

		precomputingStage = PrecomputingStage.FINISHED_GAMEMAP_POLYS;
		getLog().info("Finished GameMapInfoPolygons");
	}

	/**
	 * Creates quad trees from game map info polys.
	 */
	protected void createQuadTrees() {
		getLog().info("Creating QuadTrees");
		precomputingStage = PrecomputingStage.CREATING_QUADTREES;

		qTreesManager = new QuadTreesManager(
				mapInfo.getOwnTerritories(), mapInfo.getEnemiesTerritories(),
				worldview, getLog());

		precomputingStage = PrecomputingStage.FINISHED_QUADTREES;
		getLog().info("Finished QuadTrees");
	}

	protected void createClosestPoints() {
		getLog().info("Creating closest points");
		precomputingStage = PrecomputingStage.CREATING_CLOSEST_POINTS;
		lookup = new ClosestPointsLookUp(gameInfo, getLog(),
				ClosestPointsLookUp.prepareEnemyQuadTrees(qTreesManager
						.getEnemyQuadTrees()),
				qTreesManager.getOwnQuadTrees());

		closestPoints = lookup.getClosestPoints();

		if (closestPoints != null) {
			precomputingStage = PrecomputingStage.PLACING_SHIPS;
			getLog().info("Finished closest points");
		}
	}

	/**
	 * State machine switch.
	 */
	@Override
	public void gameLogic() {
		switch (precomputingStage) {
			case FINISHED_GAMEMAP_POLYS: {
				createQuadTrees();
				break;
			}
			case FINISHED_QUADTREES: {
				createClosestPoints();
				break;
			}
			case PLACING_SHIPS: {

				final UnitType[] unit_composition = new UnitType[] {
						UnitType.BATTLE_SHIP,
						UnitType.BATTLE_SHIP,
						UnitType.CARRIER,
						UnitType.CARRIER,
						UnitType.SUB,
						UnitType.SUB };

				boolean canCreate = gameInfo.canCreateFleet(unit_composition);
				if (semaphore == 0 && canCreate) {

					for (Entry<Integer, SortedMap<Integer, List<ClosestPoints>>> single_enemy : closestPoints
							.getClosestPoints().entrySet()) {

						for (Entry<Integer, List<ClosestPoints>> ownTerritoryWithClosestsPoints : single_enemy
								.getValue().entrySet()) {

							for (ClosestPoints closest : ownTerritoryWithClosestsPoints
									.getValue()) {

								boolean basic_success =
										fleetsManager.placeFleet(
												closest.getOrigins(),
												unit_composition,
												2,
												closest.getTarget(),
												placedFleetListener);

								if (basic_success)
									++semaphore;


							}
						}
					}
				} else {
					if (!canCreate) {
						getLog().info("Placing buildings");
						placementProvider = new BuildingPlacementProvider(
								this, mapInfo, qTreesManager);
						precomputingStage = getNextBuildingPlacementStage();
					}
				}
				break;
			}
			case PLACING_RADAR: {

				if (buildingsManager.isFinished()) {

					int placeableCount = gameInfo
							.getRemainingUnits(UnitType.RADAR);
					if (placeableCount != 0) {

						List<DefConLocation> placements;
						placements = placementProvider.getLocations(
								gameInfo.getRadarRange() * .75d,
								placeableCount,
								UnitType.RADAR);

						buildingsManager.placeBuildings(
								placements,
								UnitType.RADAR);

					} else {

						precomputingStage = getNextBuildingPlacementStage();
					}
				}

				break;
			}
			case PLACING_SILO: {

				if (buildingsManager.isFinished()) {

					int placeableCount = gameInfo
							.getRemainingUnits(UnitType.SILO);
					if (placeableCount != 0) {

						List<DefConLocation> placements;
						placements = placementProvider.getLocations(
								gameInfo.getSiloRange() * .75d,
								placeableCount,
								UnitType.SILO);

						buildingsManager.placeBuildings(
								placements,
								UnitType.SILO);

					} else {
						precomputingStage = getNextBuildingPlacementStage();
					}
				}

				break;
			}
			case PLACING_AIR_BASE: {

				if (buildingsManager.isFinished()) {
					int placeableCount = gameInfo
							.getRemainingUnits(UnitType.AIR_BASE);

					if (placeableCount != 0) {

						List<DefConLocation> placements;
						placements = placementProvider.getLocations(
								40d * .75d,
								placeableCount,
								UnitType.AIR_BASE);

						buildingsManager.placeBuildings(
								placements,
								UnitType.AIR_BASE);

					} else {
						precomputingStage = getNextBuildingPlacementStage();
					}
				}

				break;
			}
			case ASSIGN_BUILDING_AIS: {
				for (BuildingWithAI<?> building : buildingsManager
						.getOwnBuildings()) {
					switch (building.getBuilding().getType()) {
						case SILO: {
							building.setAI(new SiloAI((Silo) building
									.getBuilding(), this));
							break;
						}
						case AIR_BASE: {
							building.setAI(new AirBaseAI(
									(AirBase) building
											.getBuilding(), this));
							break;
						}
					}
				}
				precomputingStage = PrecomputingStage.DONE;
				break;
			}
			case DONE:
				break;
		}
	}

	protected int semaphore = 0;

	/**
	 * Reacts to fleets manager finishing placing.
	 */
	protected IPlacingFinishedListener placedFleetListener = new IPlacingFinishedListener() {

		@Override
		public void placingFinished(List<Fleet> succeeded, Object initData,
				boolean success) {
			getLog().info(
					"Placed: " + succeeded + " success: " + success
							+ " target "
							+ initData.toString());
			DefConLocation target = (DefConLocation) initData;

			for (Fleet fleet : succeeded) {
				IFleetAI ai = new MixedFleetAI(target, fleet,
						ExampleBotLogicController.this);
				fleetsManager.assignAI(fleet, ai);
			}
			--semaphore;
		}
	};

}
