/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.defcon.example;

import cz.cuni.amis.pogamut.defcon.agent.impl.DefConAgentLogicController;
import cz.cuni.amis.pogamut.defcon.ai.buildingai.IBuildingAI;
import cz.cuni.amis.pogamut.defcon.ai.fleetai.IFleetAI;
import cz.cuni.amis.pogamut.defcon.base3d.worldview.object.DefConLocation;
import cz.cuni.amis.pogamut.defcon.communication.messages.commands.DefConCommand;
import cz.cuni.amis.pogamut.defcon.communication.messages.commands.RequestGameSpeed;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.AirBase;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.Fleet;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.Silo;
import cz.cuni.amis.pogamut.defcon.communication.worldview.modules.bitmap.BitmapMapSource;
import cz.cuni.amis.pogamut.defcon.communication.worldview.modules.managers.buildings.BuildingPlacementProvider;
import cz.cuni.amis.pogamut.defcon.communication.worldview.modules.managers.buildings.BuildingsManager;
import cz.cuni.amis.pogamut.defcon.communication.worldview.modules.managers.fleets.FleetsManager;
import cz.cuni.amis.pogamut.defcon.communication.worldview.modules.managers.fleets.IPlacingFinishedListener;
import cz.cuni.amis.pogamut.defcon.communication.worldview.polygons.GameMapInfoPolygons;
import cz.cuni.amis.pogamut.defcon.consts.GameSpeed;
import cz.cuni.amis.pogamut.defcon.consts.UnitType;
import cz.cuni.amis.pogamut.defcon.example.AirBaseAI;
import cz.cuni.amis.pogamut.defcon.example.ExampleBot;
import cz.cuni.amis.pogamut.defcon.example.MixedFleetAI;
import cz.cuni.amis.pogamut.defcon.example.SiloAI;
import cz.cuni.amis.pogamut.defcon.utils.closestpoints.ClosestPointsLookUp;
import cz.cuni.amis.pogamut.defcon.utils.closestpoints.ClosestPointsManager;
import cz.cuni.amis.pogamut.defcon.utils.quadtree.QuadTree;
import cz.cuni.amis.pogamut.defcon.utils.quadtree.QuadTreesManager;
import cz.cuni.amis.utils.exception.PogamutException;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class ExampleBotLogicController
extends DefConAgentLogicController<ExampleBot> {
    protected LinkedList<QuadTree> placeableWaterQuadTrees = new LinkedList();
    protected LinkedList<LinkedList<QuadTree>> enemyQuadTrees = new LinkedList();
    protected GameMapInfoPolygons mapInfo;
    protected ClosestPointsManager closestPoints;
    protected ClosestPointsLookUp lookup;
    protected QuadTreesManager qTreesManager;
    protected BuildingPlacementProvider placementProvider;
    protected PrecomputingStage precomputingStage = PrecomputingStage.START;
    protected final PrecomputingStage[] buildingPlacementOrdering = new PrecomputingStage[]{PrecomputingStage.PLACING_RADAR, PrecomputingStage.PLACING_SILO, PrecomputingStage.PLACING_AIR_BASE};
    protected static final int BUILDING_PLACEMENT_TRANSPOSITIONS = 5;
    protected int placementIndex = 0;
    protected int semaphore = 0;
    protected IPlacingFinishedListener placedFleetListener = new IPlacingFinishedListener(){

        public void placingFinished(List<Fleet> succeeded, Object initData, boolean success) {
            ExampleBotLogicController.this.getLog().info("Placed: " + succeeded + " success: " + success + " target " + initData.toString());
            DefConLocation target = (DefConLocation)initData;
            for (Fleet fleet : succeeded) {
                MixedFleetAI ai = new MixedFleetAI(target, fleet, ExampleBotLogicController.this);
                ExampleBotLogicController.this.fleetsManager.assignAI(fleet, (IFleetAI)ai);
            }
            --ExampleBotLogicController.this.semaphore;
        }
    };

    public void firstGameLogic() {
        this.getLog().addConsoleHandler();
        this.getLog().info("Logic start");
        this.act((DefConCommand)new RequestGameSpeed(GameSpeed.FAST));
        this.fleetsManager = new FleetsManager((DefConAgentLogicController)this);
        this.buildingsManager = new BuildingsManager((DefConAgentLogicController)this);
        this.permuteBuildingPlaccementOrdering();
        this.createGameMapInfoPolygons();
    }

    protected void permuteBuildingPlaccementOrdering() {
        int transpositions = 5;
        while (transpositions > 0) {
            int second;
            int first = this.getRandom().nextInt(this.buildingPlacementOrdering.length);
            if (first == (second = this.getRandom().nextInt(this.buildingPlacementOrdering.length))) continue;
            PrecomputingStage tmp = this.buildingPlacementOrdering[first];
            this.buildingPlacementOrdering[first] = this.buildingPlacementOrdering[second];
            this.buildingPlacementOrdering[second] = tmp;
            --transpositions;
        }
    }

    protected PrecomputingStage getNextBuildingPlacementStage() {
        if (this.placementIndex >= this.buildingPlacementOrdering.length) {
            return PrecomputingStage.ASSIGN_BUILDING_AIS;
        }
        return this.buildingPlacementOrdering[this.placementIndex++];
    }

    protected void createGameMapInfoPolygons() {
        this.getLog().info("Creating GameMapInfoPolygons");
        this.precomputingStage = PrecomputingStage.CREATING_GAMEMAP_POLYS;
        try {
            File mapBitmaps = new File("./AI/javabot/Bitmaps/Territories");
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".bmp");
                }
            };
            int territories_count = mapBitmaps.listFiles(filter).length;
            BufferedImage[] territories = new BufferedImage[territories_count];
            int i = 0;
            for (File bitmap_file : mapBitmaps.listFiles(filter)) {
                territories[i] = ImageIO.read(bitmap_file);
                ++i;
            }
            BufferedImage sailable = ImageIO.read(new File("./AI/javabot/Bitmaps/sailable.bmp"));
            TreeMap<Integer, int[]> enemies = new TreeMap<Integer, int[]>();
            for (int enemyId : ((ExampleBot)this.agent).getWorldView().getGameInfo().getEnemyTeamIds()) {
                enemies.put(enemyId, ((ExampleBot)this.agent).getWorldView().getGameInfo().getTeamTerritories(enemyId));
            }
            this.flagChecker = new BitmapMapSource(territories, this.gameInfo.getOwnTeamTerritories(), enemies, sailable, (Logger)this.getLog());
            this.mapInfo = new GameMapInfoPolygons(this.agent, this.flagChecker, "./AI/javabot/Preprocessed/", (Logger)this.getLog());
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                this.getLog().info(e.getMessage());
            }
            throw new PogamutException((Throwable)e, (Object)this);
        }
        this.precomputingStage = PrecomputingStage.FINISHED_GAMEMAP_POLYS;
        this.getLog().info("Finished GameMapInfoPolygons");
    }

    protected void createQuadTrees() {
        this.getLog().info("Creating QuadTrees");
        this.precomputingStage = PrecomputingStage.CREATING_QUADTREES;
        this.qTreesManager = new QuadTreesManager(this.mapInfo.getOwnTerritories(), this.mapInfo.getEnemiesTerritories(), this.worldview, (Logger)this.getLog());
        this.precomputingStage = PrecomputingStage.FINISHED_QUADTREES;
        this.getLog().info("Finished QuadTrees");
    }

    protected void createClosestPoints() {
        this.getLog().info("Creating closest points");
        this.precomputingStage = PrecomputingStage.CREATING_CLOSEST_POINTS;
        this.lookup = new ClosestPointsLookUp(this.gameInfo, (Logger)this.getLog(), ClosestPointsLookUp.prepareEnemyQuadTrees((SortedMap)this.qTreesManager.getEnemyQuadTrees()), this.qTreesManager.getOwnQuadTrees());
        this.closestPoints = this.lookup.getClosestPoints();
        if (this.closestPoints != null) {
            this.precomputingStage = PrecomputingStage.PLACING_SHIPS;
            this.getLog().info("Finished closest points");
        }
    }

    public void gameLogic() {
        switch (this.precomputingStage) {
            case FINISHED_GAMEMAP_POLYS: {
                this.createQuadTrees();
                break;
            }
            case FINISHED_QUADTREES: {
                this.createClosestPoints();
                break;
            }
            case PLACING_SHIPS: {
                UnitType[] unit_composition = new UnitType[]{UnitType.BATTLE_SHIP, UnitType.BATTLE_SHIP, UnitType.CARRIER, UnitType.CARRIER, UnitType.SUB, UnitType.SUB};
                boolean canCreate = this.gameInfo.canCreateFleet(unit_composition);
                if (this.semaphore == 0 && canCreate) {
                    for (Map.Entry single_enemy : this.closestPoints.getClosestPoints().entrySet()) {
                        for (Map.Entry ownTerritoryWithClosestsPoints : ((SortedMap)single_enemy.getValue()).entrySet()) {
                            for (ClosestPointsLookUp.ClosestPoints closest : (List)ownTerritoryWithClosestsPoints.getValue()) {
                                boolean basic_success = this.fleetsManager.placeFleet(closest.getOrigins(), unit_composition, 2, (Object)closest.getTarget(), this.placedFleetListener);
                                if (!basic_success) continue;
                                ++this.semaphore;
                            }
                        }
                    }
                    break;
                }
                if (canCreate) break;
                this.getLog().info("Placing buildings");
                this.placementProvider = new BuildingPlacementProvider((DefConAgentLogicController)this, this.mapInfo, this.qTreesManager);
                this.precomputingStage = this.getNextBuildingPlacementStage();
                break;
            }
            case PLACING_RADAR: {
                if (!this.buildingsManager.isFinished()) break;
                int placeableCount = this.gameInfo.getRemainingUnits(UnitType.RADAR);
                if (placeableCount != 0) {
                    List placements = this.placementProvider.getLocations(this.gameInfo.getRadarRange() * 0.75, placeableCount, UnitType.RADAR);
                    this.buildingsManager.placeBuildings(placements, UnitType.RADAR);
                    break;
                }
                this.precomputingStage = this.getNextBuildingPlacementStage();
                break;
            }
            case PLACING_SILO: {
                if (!this.buildingsManager.isFinished()) break;
                int placeableCount = this.gameInfo.getRemainingUnits(UnitType.SILO);
                if (placeableCount != 0) {
                    List placements = this.placementProvider.getLocations(this.gameInfo.getSiloRange() * 0.75, placeableCount, UnitType.SILO);
                    this.buildingsManager.placeBuildings(placements, UnitType.SILO);
                    break;
                }
                this.precomputingStage = this.getNextBuildingPlacementStage();
                break;
            }
            case PLACING_AIR_BASE: {
                if (!this.buildingsManager.isFinished()) break;
                int placeableCount = this.gameInfo.getRemainingUnits(UnitType.AIR_BASE);
                if (placeableCount != 0) {
                    List placements = this.placementProvider.getLocations(30.0, placeableCount, UnitType.AIR_BASE);
                    this.buildingsManager.placeBuildings(placements, UnitType.AIR_BASE);
                    break;
                }
                this.precomputingStage = this.getNextBuildingPlacementStage();
                break;
            }
            case ASSIGN_BUILDING_AIS: {
                for (BuildingsManager.BuildingWithAI building : this.buildingsManager.getOwnBuildings()) {
                    switch (building.getBuilding().getType()) {
                        case SILO: {
                            building.setAI((IBuildingAI)new SiloAI((Silo)building.getBuilding(), this));
                            break;
                        }
                        case AIR_BASE: {
                            building.setAI((IBuildingAI)new AirBaseAI((AirBase)building.getBuilding(), this));
                        }
                    }
                }
                this.precomputingStage = PrecomputingStage.DONE;
                break;
            }
        }
    }

    protected static enum PrecomputingStage {
        START,
        CREATING_GAMEMAP_POLYS,
        FINISHED_GAMEMAP_POLYS,
        CREATING_QUADTREES,
        FINISHED_QUADTREES,
        CREATING_CLOSEST_POINTS,
        PLACING_SHIPS,
        PLACING_RADAR,
        PLACING_SILO,
        PLACING_AIR_BASE,
        ASSIGN_BUILDING_AIS,
        DONE;

    }
}

