/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.defcon.example;

import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.defcon.agent.impl.DefConAgentLogicController;
import cz.cuni.amis.pogamut.defcon.ai.AbstractAI;
import cz.cuni.amis.pogamut.defcon.ai.fleetai.IFleetAI;
import cz.cuni.amis.pogamut.defcon.base3d.worldview.object.DefConLocation;
import cz.cuni.amis.pogamut.defcon.communication.messages.commands.DefConCommand;
import cz.cuni.amis.pogamut.defcon.communication.messages.commands.SetActionTarget;
import cz.cuni.amis.pogamut.defcon.communication.messages.commands.SetMovementTarget;
import cz.cuni.amis.pogamut.defcon.communication.messages.commands.SetState;
import cz.cuni.amis.pogamut.defcon.communication.messages.commands.WhiteboardDraw;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.Carrier;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.City;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.DefConChanged;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.DefConUnitObject;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.DefConViewableObject;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.Fleet;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.Sub;
import cz.cuni.amis.pogamut.defcon.communication.worldview.modules.grid.flags.BasicFlag;
import cz.cuni.amis.pogamut.defcon.consts.UnitType;
import cz.cuni.amis.pogamut.defcon.consts.state.CarrierState;
import cz.cuni.amis.pogamut.defcon.consts.state.IState;
import cz.cuni.amis.pogamut.defcon.consts.state.SubState;
import cz.cuni.amis.pogamut.defcon.example.ExampleBotLogicController;
import java.util.List;

public class MixedFleetAI
extends AbstractAI
implements IFleetAI {
    protected final Fleet fleet;
    protected DefConLocation targetLocation;
    protected DefConLocation optimizedTargetLocation;
    protected DefConLocation currentTargetLocation;
    protected DefConLocation originalLocation;
    protected final List<Integer> enemyCityIds;
    protected boolean canLaunch = false;
    protected float arrivalTime = -1.0f;
    protected State currentState = State.PRE_DEFCON4;
    protected final IWorldEventListener<DefConChanged> level3DefconListener = new IWorldEventListener<DefConChanged>(){

        public void notify(DefConChanged event) {
            switch (event.getNewDefCon()) {
                case 1: {
                    MixedFleetAI.this.canLaunch = true;
                    if (MixedFleetAI.this.arrivalTime != -1.0f) {
                        MixedFleetAI.this.arrivalTime = MixedFleetAI.this.logic.getGameInfo().getGameTick();
                    }
                    MixedFleetAI.this.logic.getLog().info("canLaunch " + MixedFleetAI.this.fleet.getId());
                    if (MixedFleetAI.this.currentState != State.WAIT_FOR_DEFCON1) break;
                    MixedFleetAI.this.currentState = State.LAUNCH_NUKES;
                    break;
                }
                case 4: {
                    MixedFleetAI.this.currentState = State.GOTO_ATTACK_POSITION;
                    MixedFleetAI.this.setMoveToTarget();
                    MixedFleetAI.this.logic.getLog().info("goto attack position " + MixedFleetAI.this.fleet.getId());
                }
            }
        }
    };
    protected static final double TARGET_SELECTION_LIMIT = 50.0;
    protected Fleet targetFleet;
    protected float lastTargetSelect = 0.0f;

    public MixedFleetAI(DefConLocation target, Fleet fleet, ExampleBotLogicController logic) {
        super((DefConAgentLogicController)logic, fleet.getId());
        this.fleet = fleet;
        logic.getWorldView().addEventListener(DefConChanged.class, this.level3DefconListener);
        this.enemyCityIds = logic.getGameInfo().getEnemyCityIds();
        this.originalLocation = new DefConLocation((Location)fleet.getLocation());
        this.optimizeOriginalLocation();
        this.setTargetLocation(new DefConLocation((Location)target));
        this.caculateBestMovementTarget();
    }

    protected void optimizeOriginalLocation() {
        DefConLocation cities_center = this.logic.getGameInfo().getCitiesGravityCenter(this.logic.getGameInfo().getOwnTeamId());
        DefConLocation optimized = new DefConLocation((Location)this.originalLocation);
        float curr_distance = Float.POSITIVE_INFINITY;
        while ((optimized = this.getLogic().getFlagChecker().traceFromTo(optimized, cities_center, BasicFlag.SEA, 8.0)) != null && Float.isInfinite(curr_distance = this.logic.getGameInfo().getSailDistance((Location)this.fleet.getLocation(), (Location)optimized))) {
        }
        if (!Float.isInfinite(curr_distance)) {
            this.originalLocation = optimized;
        }
        this.act((DefConCommand)new WhiteboardDraw(cities_center, this.originalLocation));
    }

    protected void setMoveToTarget() {
        this.moveFleet(this.currentTargetLocation);
    }

    protected void moveFleet(DefConLocation target) {
        if (target == null) {
            this.logic.getLog().info("moveFleet: null");
            return;
        }
        this.logic.getLog().info("moveFleet: " + this.fleet.getId() + " " + this.fleet.getLocation() + " " + target + " " + this.logic.getGameInfo().getSailDistance((Location)this.fleet.getLocation(), (Location)target));
        for (int unitId : this.fleet.getFleetMembers()) {
            this.logic.act((DefConCommand)new SetMovementTarget(unitId, target));
        }
    }

    public void update() {
        if (this.fleet.getFleetMembers().length == 0) {
            this.logic.getLog().info("no fleet members?!?! " + this.unitId);
        }
        switch (this.currentState) {
            case PRE_DEFCON4: {
                break;
            }
            case GOTO_ATTACK_POSITION: {
                this.runGotoAttackPosition();
                break;
            }
            case WAIT_FOR_DEFCON1: {
                break;
            }
            case LAUNCH_NUKES: {
                this.runLaunchNukes();
                break;
            }
            case HUNT: {
                this.runHunt();
            }
        }
    }

    protected void runGotoAttackPosition() {
        if (this.optimizedTargetLocation.getDistance((Location)this.fleet.getLocation()) < 20.0) {
            this.arrivalTime = this.logic.getGameInfo().getGameTick();
            this.logic.getLog().info("arrivalTime: " + this.arrivalTime);
            this.currentState = this.canLaunch ? State.LAUNCH_NUKES : State.WAIT_FOR_DEFCON1;
        }
    }

    protected void runLaunchNukes() {
        if (!this.hasSpareNukes() || (float)this.logic.getGameInfo().getGameTick() - this.arrivalTime > 750.0f) {
            this.logic.getLog().info("Hunt " + this.fleet.getId());
            this.currentState = State.HUNT;
        }
        if (!this.hasSpareLaunchableNukes()) {
            return;
        }
        for (int unitId : this.fleet.getFleetMembers()) {
            if (this.logic.getGameInfo().getActionQueue(unitId).length > 20 || !this.nukeCapable(unitId)) continue;
            if (!this.inNukeState(unitId)) {
                this.toNukeState(unitId);
                continue;
            }
            DefConUnitObject unit = (DefConUnitObject)this.logic.getWorldView().get(WorldObjectId.get((long)unitId));
            int nukes = this.logic.getGameInfo().getNukeSupply(unitId);
            int tries = 10;
            while (nukes > 0 && tries > 0) {
                int cityId = this.enemyCityIds.get(this.logic.getRandom().nextInt(this.enemyCityIds.size()));
                if (!this.inNukeRange(unitId, cityId, unit.getType())) {
                    --tries;
                    continue;
                }
                this.launchNuke(unitId, cityId);
                --nukes;
            }
        }
    }

    protected void runHunt() {
        float tmp = this.logic.getGameInfo().getGameTick();
        for (int unitId : this.fleet.getFleetMembers()) {
            DefConUnitObject unit = (DefConUnitObject)this.logic.getWorldView().get(WorldObjectId.get((long)unitId));
            if (unit.getType() == null || unit.getType() != UnitType.SUB || unit.getState() == SubState.ACTIVE_SONAR) continue;
            this.act((DefConCommand)new SetState(unitId, SubState.ACTIVE_SONAR.id));
        }
        if (this.targetFleet != null) {
            if ((double)(tmp - this.lastTargetSelect) < 150.0) {
                return;
            }
            this.lastTargetSelect = tmp;
            this.logic.getLog().info("updating target: " + this.fleet.getId());
            if (this.targetFleet.isVisible()) {
                if (this.targetFleet.getLocation().getDistance((Location)this.currentTargetLocation) > 35.0) {
                    this.refreshClosestEnemyFleet();
                    if (this.targetFleet != null) {
                        this.setAttackTarget(Integer.parseInt(this.targetFleet.getId().getStringId()));
                        this.currentTargetLocation = this.targetFleet.getLocation();
                    }
                    this.setMoveToTarget();
                }
            } else {
                this.refreshClosestEnemyFleet();
                if (this.targetFleet != null) {
                    this.setAttackTarget((int)this.targetFleet.getId().getLongId());
                    this.currentTargetLocation = this.targetFleet.getLocation();
                } else {
                    this.currentTargetLocation = this.originalLocation;
                }
                this.setMoveToTarget();
            }
        } else {
            if ((double)(tmp - this.lastTargetSelect) < 50.0) {
                return;
            }
            this.lastTargetSelect = tmp;
            this.logic.getLog().info("looking for: " + this.fleet.getId());
            this.refreshClosestEnemyFleet();
            if (this.targetFleet != null) {
                this.logic.getLog().info("Found new target: " + this.targetFleet.getId());
                this.setAttackTarget((int)this.targetFleet.getId().getLongId());
                this.currentTargetLocation = this.targetFleet.getLocation();
                this.setMoveToTarget();
            } else if (this.fleet.getLocation().getDistance((Location)this.originalLocation) > 5.0) {
                this.logic.getLog().info("Returning back");
                this.currentTargetLocation = this.originalLocation;
                this.setMoveToTarget();
            } else {
                this.logic.getLog().info("Already back");
            }
        }
    }

    protected void setAttackTarget(int targetId) {
        for (int unitId : this.fleet.getFleetMembers()) {
            this.logic.act((DefConCommand)new SetActionTarget(unitId, targetId, null));
        }
    }

    protected void refreshClosestEnemyFleet() {
        Fleet f = this.getClosestEnemyFleetWithUnits(new UnitType[]{UnitType.SUB, UnitType.CARRIER});
        if (f == null) {
            f = this.getClosestEnemyFleet();
        }
        if (f != null) {
            this.logic.getLog().info("Targetted: " + f + " " + this.arrayToString(f.getFleetMembers()));
            this.currentTargetLocation = f.getLocation();
        }
        this.targetFleet = f;
    }

    protected void caculateBestMovementTarget() {
        float curr_distance;
        int enemyId = this.getClosestEnemyCityOwner(this.targetLocation);
        if (enemyId == -1) {
            return;
        }
        DefConLocation cities_center = this.logic.getGameInfo().getCitiesGravityCenter(enemyId);
        this.currentTargetLocation = this.targetLocation;
        this.act((DefConCommand)new WhiteboardDraw(cities_center, cities_center.add((Location)new DefConLocation(0.5, 0.5))));
        this.act((DefConCommand)new WhiteboardDraw(this.targetLocation, this.targetLocation.add((Location)new DefConLocation(0.5, 0.5))));
        DefConLocation best_position_for_target = new DefConLocation((Location)cities_center);
        do {
            best_position_for_target = this.getLogic().getFlagChecker().traceFromTo(this.targetLocation, best_position_for_target, BasicFlag.SEA, 8.0);
        } while (Float.isInfinite(curr_distance = this.logic.getGameInfo().getSailDistance((Location)this.fleet.getLocation(), (Location)best_position_for_target)));
        double best_position_for_target_distance = best_position_for_target.getDistance2D((Location)cities_center);
        DefConLocation best_direct_position = new DefConLocation((Location)cities_center);
        while ((best_direct_position = this.getLogic().getFlagChecker().traceFromTo(this.fleet.getLocation(), best_direct_position, BasicFlag.SEA, 8.0)) != null && Float.isInfinite(this.logic.getGameInfo().getSailDistance((Location)this.fleet.getLocation(), (Location)best_direct_position))) {
        }
        double best_direct_position_distance = best_direct_position != null ? best_direct_position.getDistance2D((Location)cities_center) : Double.POSITIVE_INFINITY;
        this.currentTargetLocation = best_direct_position_distance < best_position_for_target_distance ? best_direct_position : best_position_for_target;
        this.optimizedTargetLocation = this.currentTargetLocation;
        this.act((DefConCommand)new WhiteboardDraw(cities_center, this.currentTargetLocation));
    }

    protected int getClosestEnemyCityOwner(DefConLocation closestTo) {
        if (closestTo == null) {
            return -1;
        }
        double closest_distance = Double.POSITIVE_INFINITY;
        DefConLocation closest = new DefConLocation();
        int enemyId = -1;
        for (City city : this.logic.getWorldView().getAll(City.class).values()) {
            double distance;
            if (city.getTeamId() == this.logic.getGameInfo().getOwnTeamId() || !((distance = closestTo.getDistance((Location)city.getLocation())) < closest_distance)) continue;
            closest_distance = distance;
            closest = new DefConLocation((Location)city.getLocation());
            enemyId = city.getTeamId();
        }
        return enemyId;
    }

    protected String arrayToString(int[] array) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (int element : array) {
            builder.append(element);
            builder.append(", ");
        }
        builder.append("]");
        return builder.toString();
    }

    protected boolean inNukeRange(int unitId, int cityId, UnitType type) {
        DefConLocation unitLocation = ((DefConUnitObject)this.logic.getWorldView().get(WorldObjectId.get((long)unitId))).getLocation();
        DefConLocation cityLocation = ((DefConViewableObject)this.logic.getWorldView().get(WorldObjectId.get((long)cityId))).getLocation();
        return this.inNukeRange(unitLocation, cityLocation, type);
    }

    protected boolean inNukeRange(DefConLocation unit, DefConLocation target, UnitType type) {
        double dist = target.getDistance((Location)unit);
        switch (type) {
            case SUB: {
                return dist < this.logic.getGameInfo().getSubNukeRange();
            }
            case CARRIER: 
            case BOMBER: {
                return dist < this.logic.getGameInfo().getBomberRange();
            }
            case SILO: {
                return true;
            }
        }
        return false;
    }

    protected void launchNuke(int unitId, int targetId) {
        this.act((DefConCommand)new SetActionTarget(unitId, targetId, null));
    }

    protected boolean nukeCapable(int unitId) {
        DefConUnitObject object = (DefConUnitObject)this.logic.getWorldView().get(WorldObjectId.get((long)unitId));
        if (object == null) {
            return false;
        }
        if (object.getType() == null) {
            return false;
        }
        switch (object.getType()) {
            case CARRIER: {
                return this.logic.getGameInfo().getNukeSupply(unitId) > 0 && this.logic.getGameInfo().getStateCount(unitId, (IState)CarrierState.BOMBER_LAUNCH) > 0;
            }
            case SUB: 
            case BOMBER: 
            case SILO: {
                return this.logic.getGameInfo().getNukeSupply(unitId) > 0;
            }
        }
        return false;
    }

    protected boolean inNukeState(int unitId) {
        DefConUnitObject object = (DefConUnitObject)this.logic.getWorldView().get(WorldObjectId.get((long)unitId));
        switch (object.getType()) {
            case CARRIER: {
                Carrier carrier = (Carrier)object;
                return carrier.getState() == CarrierState.BOMBER_LAUNCH;
            }
            case SUB: {
                Sub sub = (Sub)object;
                return sub.getState() == SubState.NUKE;
            }
        }
        return false;
    }

    protected boolean toNukeState(int unitId) {
        int nukes = this.logic.getGameInfo().getNukeSupply(unitId);
        if (nukes <= 0) {
            return false;
        }
        switch (this.logic.getGameInfo().getType(unitId)) {
            case SUB: {
                this.act((DefConCommand)new SetState(unitId, SubState.NUKE.getStateId()));
                break;
            }
            case CARRIER: {
                this.act((DefConCommand)new SetState(unitId, CarrierState.BOMBER_LAUNCH.getStateId()));
            }
        }
        return true;
    }

    protected boolean hasSpareNukes() {
        for (int unitId : this.fleet.getFleetMembers()) {
            int nukes = this.logic.getGameInfo().getNukeSupply(unitId);
            if (nukes <= 0) continue;
            return true;
        }
        return false;
    }

    protected boolean hasSpareLaunchableNukes() {
        for (int unitId : this.fleet.getFleetMembers()) {
            int nukes = this.logic.getGameInfo().getNukeSupply(unitId);
            if (this.logic.getGameInfo().getType(unitId) == UnitType.CARRIER) {
                nukes -= this.logic.getGameInfo().getStateCount(unitId, (IState)CarrierState.BOMBER_LAUNCH);
            }
            if (nukes <= 0) continue;
            return true;
        }
        return false;
    }

    public final Fleet getFleet() {
        return this.fleet;
    }

    public final ExampleBotLogicController getLogic() {
        return (ExampleBotLogicController)this.logic;
    }

    public void setTargetLocation(DefConLocation target) {
        this.targetLocation = target;
    }

    public Fleet getClosestEnemyFleet() {
        return this.getClosestEnemyFleetWithUnit(null);
    }

    public Fleet getClosestEnemyFleetWithUnit(UnitType type) {
        return this.getClosestEnemyFleetWithUnits(new UnitType[]{type});
    }

    public Fleet getClosestEnemyFleetWithUnits(UnitType[] types) {
        double closest_dist = Double.POSITIVE_INFINITY;
        Fleet closest_fleet = null;
        for (int enemyId : this.logic.getGameInfo().getEnemyTeamIds()) {
            for (Fleet enemy_fleet : this.getLogic().getFleetsManager().getEnemyFleets(enemyId)) {
                double dist;
                if (enemy_fleet.getTeamId() == this.logic.getGameInfo().getOwnTeamId() || !enemy_fleet.isVisible()) continue;
                if (types != null && types.length > 0) {
                    boolean found = false;
                    for (int unitId : enemy_fleet.getFleetMembers()) {
                        DefConUnitObject unit = (DefConUnitObject)this.logic.getWorldView().get(WorldObjectId.get((long)unitId));
                        if (unit == null || !unit.isVisible() || unit.getType() == null || !this.arrayContains(types, unit.getType())) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                }
                if (!((dist = (double)this.logic.getGameInfo().getSailDistance((Location)this.fleet.getLocation(), (Location)enemy_fleet.getLocation())) < closest_dist)) continue;
                closest_fleet = enemy_fleet;
                closest_dist = dist;
            }
        }
        return closest_fleet;
    }

    public void dispose() {
        super.dispose();
        this.logic.getWorldView().removeListener(this.level3DefconListener);
    }

    protected <T> boolean arrayContains(T[] array, T element) {
        return this.arrayIndex(array, element) != -1;
    }

    protected <T> int arrayIndex(T[] array, T element) {
        if (element == null) {
            return -1;
        }
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null || !array[i].equals(element)) continue;
            return i;
        }
        return -1;
    }

    public int[] getFleetMembers() {
        return this.fleet.getFleetMembers();
    }

    public DefConLocation getLocation() {
        return this.fleet.getLocation();
    }

    protected static enum State {
        PRE_DEFCON4,
        GOTO_ATTACK_POSITION,
        WAIT_FOR_DEFCON1,
        LAUNCH_NUKES,
        HUNT;

    }
}

