package cz.cuni.amis.pogamut.defcon.example.javabot;

import java.io.File;
import java.util.logging.Level;

import com.google.inject.Inject;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.LogPublisher;
import cz.cuni.amis.pogamut.defcon.agent.DefConAgent;
import cz.cuni.amis.pogamut.defcon.agent.IDefConAgentLogicController;
import cz.cuni.amis.pogamut.defcon.communication.command.impl.DefConAct;
import cz.cuni.amis.pogamut.defcon.communication.worldview.DefConWorldView;

/**
 * JavaBot wrapper class.
 * 
 * @author Radek 'Black_Hand' Pibil
 * 
 */
public class JavaBot extends	DefConAgent {
	
	@Inject
	public JavaBot(IAgentId agentId, IComponentBus eventBus,
			IAgentLogger logger, DefConWorldView worldView, DefConAct act,
			IDefConAgentLogicController init) {
		super(agentId, eventBus, logger, worldView, act, init);
		getLogger().addToAllCategories(
				new LogPublisher.FilePublisher(new File(
						"Pogamut-JavaBot.log")));
		getLogger().setLevel(Level.FINE);
	}
}