/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.defcon.example.javabot;

import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.defcon.agent.impl.DefConAgentLogicController;
import cz.cuni.amis.pogamut.defcon.ai.buildingai.AbstractBuildingAI;
import cz.cuni.amis.pogamut.defcon.communication.messages.commands.DefConCommand;
import cz.cuni.amis.pogamut.defcon.communication.messages.commands.SetActionTarget;
import cz.cuni.amis.pogamut.defcon.communication.messages.commands.SetState;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.AirBase;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.DefConChanged;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.DefConUnitObject;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.DefConViewableObject;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.Sub;
import cz.cuni.amis.pogamut.defcon.consts.UnitType;
import cz.cuni.amis.pogamut.defcon.consts.state.AirBaseState;
import cz.cuni.amis.pogamut.defcon.consts.state.IState;
import cz.cuni.amis.pogamut.defcon.consts.state.SubState;
import java.util.Map;

public class AirBaseAI
extends AbstractBuildingAI<AirBase> {
    private static final UnitType[] preNukePriorities = new UnitType[]{UnitType.BOMBER, UnitType.CARRIER, UnitType.FIGHTER, UnitType.SUB, UnitType.BATTLE_SHIP};
    private static final UnitType[] nukePriorities = new UnitType[]{UnitType.CITY, UnitType.BOMBER, UnitType.CARRIER, UnitType.FIGHTER, UnitType.SUB, UnitType.AIR_BASE, UnitType.BATTLE_SHIP, UnitType.NUKE};
    private UnitType[] priorities = preNukePriorities;
    private boolean canLaunch = false;
    private final double squareBomberRange;
    private final double squareFighterRange;
    private final IWorldEventListener<DefConChanged> defconListener = new IWorldEventListener<DefConChanged>(){

        public void notify(DefConChanged event) {
            if (event.getNewDefCon() == 1) {
                AirBaseAI.this.canLaunch = true;
                AirBaseAI.access$102(AirBaseAI.this, nukePriorities);
            }
        }
    };

    public AirBaseAI(AirBase airbase, DefConAgentLogicController<?> logic) {
        super((DefConUnitObject)airbase, logic);
        logic.getWorldView().addEventListener(DefConChanged.class, this.defconListener);
        this.squareBomberRange = logic.getGameInfo().getBomberRange() * logic.getGameInfo().getBomberRange();
        this.squareFighterRange = logic.getGameInfo().getFighterRange() * logic.getGameInfo().getFighterRange();
    }

    public void update() {
        if (this.logic.getGameInfo().getStateTimer(this.unitId) > 0.0f) {
            return;
        }
        int bombers = this.logic.getGameInfo().getStateCount(this.unitId, (IState)AirBaseState.BOMBER_LAUNCH);
        int fighters = this.logic.getGameInfo().getStateCount(this.unitId, (IState)AirBaseState.FIGHTER_LAUNCH);
        if (bombers > 0 || fighters > 0) {
            DefConViewableObject target = null;
            int targets_priority = this.priorities.length;
            Map possible_targets = this.logic.getWorldView().getAllVisible(DefConViewableObject.class);
            Object[] keys = possible_targets.keySet().toArray();
            if (keys == null || keys.length == 0) {
                return;
            }
            for (int tries = 0; tries < 30; ++tries) {
                float rand;
                int priority;
                DefConViewableObject unit = (DefConViewableObject)possible_targets.get(keys[this.logic.getRandom().nextInt(keys.length)]);
                if (unit.getType() == UnitType.SUB && ((Sub)unit).getState() == SubState.PASSIVE_SONAR || !unit.isVisible() || unit.getTeamId() == this.logic.getGameInfo().getOwnTeamId()) continue;
                if (unit.getLocation() == null || unit.getLocation().x == 0.0 && unit.getLocation().y == 0.0) {
                    this.logic.getLog().info("location is null");
                    continue;
                }
                if (!this.canLaunch && this.isNukeTarget(unit.getType()) || (priority = this.arrayIndex(this.priorities, unit.getType())) < 0) continue;
                double square_distance = ((AirBase)this.building).getLocation().getDistanceSquare((Location)unit.getLocation());
                if (this.canLaunch && this.isBomberTarget(unit.getType()) && (bombers == 0 || square_distance > this.squareBomberRange) || this.isFighterTarget(unit.getType()) && (fighters == 0 || square_distance > this.squareFighterRange)) continue;
                if (priority < targets_priority) {
                    target = unit;
                    targets_priority = priority;
                    continue;
                }
                if (priority != targets_priority || !((rand = this.logic.getRandom().nextFloat()) > 0.15f)) continue;
                target = unit;
            }
            if (target != null) {
                this.launchAppropriateAircraft(target.getType(), Integer.parseInt(target.getId().getStringId()));
            }
        }
    }

    private boolean isNukeTarget(UnitType unitType) {
        switch (unitType) {
            case CITY: 
            case AIR_BASE: 
            case SILO: 
            case RADAR: {
                return true;
            }
        }
        return false;
    }

    private boolean isFighterTarget(UnitType unitType) {
        switch (unitType) {
            case FIGHTER: 
            case BOMBER: 
            case BATTLE_SHIP: 
            case CARRIER: {
                return true;
            }
        }
        return false;
    }

    private boolean isBomberTarget(UnitType unitType) {
        switch (unitType) {
            case CITY: 
            case AIR_BASE: 
            case SILO: 
            case RADAR: {
                return true;
            }
        }
        return false;
    }

    private void launchAppropriateAircraft(UnitType target, int targetId) {
        switch (target) {
            case CITY: 
            case AIR_BASE: 
            case SILO: 
            case RADAR: 
            case BATTLE_SHIP: 
            case CARRIER: 
            case SUB: {
                if (((AirBase)this.building).getState() != AirBaseState.BOMBER_LAUNCH) {
                    this.act((DefConCommand)new SetState(this.unitId, AirBaseState.BOMBER_LAUNCH.id));
                }
                this.act((DefConCommand)new SetActionTarget(this.unitId, targetId, null));
                break;
            }
            case FIGHTER: 
            case BOMBER: 
            case NUKE: {
                if (((AirBase)this.building).getState() != AirBaseState.FIGHTER_LAUNCH) {
                    this.act((DefConCommand)new SetState(this.unitId, AirBaseState.FIGHTER_LAUNCH.id));
                }
                this.act((DefConCommand)new SetActionTarget(this.unitId, targetId, null));
            }
        }
    }

    private <T> int arrayIndex(T[] array, T element) {
        if (element == null) {
            return -1;
        }
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null || !array[i].equals(element)) continue;
            return i;
        }
        return -1;
    }

    public void dispose() {
        super.dispose();
        this.logic.getWorldView().removeListener(this.defconListener);
    }

    static /* synthetic */ UnitType[] access$102(AirBaseAI x0, UnitType[] x1) {
        x0.priorities = x1;
        return x1;
    }
}

