package cz.cuni.amis.pogamut.defcon.example.javabot;

import java.util.List;

import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.defcon.agent.impl.DefConAgentLogicController;
import cz.cuni.amis.pogamut.defcon.ai.buildingai.AbstractBuildingAI;
import cz.cuni.amis.pogamut.defcon.communication.messages.commands.SetActionTarget;
import cz.cuni.amis.pogamut.defcon.communication.messages.commands.SetState;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.DefConChanged;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.Silo;
import cz.cuni.amis.pogamut.defcon.consts.state.SiloState;

/**
 * Silo AI.
 * 
 * @author Radek 'Black_Hand' Pibil
 * 
 */
public class SiloAI extends AbstractBuildingAI<Silo> {

	private boolean canLaunch = false;
	private boolean changedToNuke = false;

	private final IWorldEventListener<DefConChanged> defconListener = new IWorldEventListener<DefConChanged>() {

		@Override
		public void notify(DefConChanged event) {
			if (event.getNewDefCon() == 1) {
				canLaunch = true;
			}
		}
	};

	public SiloAI(Silo silo, DefConAgentLogicController<?> logic) {
		super(silo, logic);
		logic.getWorldView().addEventListener(
				DefConChanged.class,
				defconListener);
	}

	@Override
	public void update() {

		if (canLaunch && logic.getGameInfo().getGameTick() > 2500f) {

			if (hasSpareNukes()) {

				if (inNukeState()) {

					while (nukes > 0) {

						for (List<Integer> cities : logic.getGameInfo()
								.getEnemiesCityIds().values()) {


							int cityId = cities.get(logic.getRandom().nextInt(
									cities.size()));

							launchNuke(unitId, cityId);

							--nukes;

							if (nukes == 0) {
								break;
							}
						}
					}
				} else {
					toNukeState();
				}

			} else {

				if (inNukeState() && building.getStateCount() == 0) {
					logic.getLog().info("Retuning to air defense: " + unitId);
					act(new SetState(unitId, SiloState.AIR_DEFENSE.id));
				}
			}
		}
	}

	private boolean inNukeState() {

		return building.getState() == SiloState.NUKE;
	}

	private boolean toNukeState() {

		if (nukes <= 0 || changedToNuke)
			return false;

		changedToNuke = true;

		act(new SetState(unitId, SiloState.NUKE.id));
		return true;

	}

	private void launchNuke(int unitId, int targetId) {
		act(new SetActionTarget(unitId, targetId, null));
	}

	@Override
	public void dispose() {
		super.dispose();
		logic.getWorldView().removeListener(defconListener);
	}
}
