/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.defcon.example.javabot;

import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.defcon.agent.impl.DefConAgentLogicController;
import cz.cuni.amis.pogamut.defcon.ai.buildingai.AbstractBuildingAI;
import cz.cuni.amis.pogamut.defcon.communication.messages.commands.DefConCommand;
import cz.cuni.amis.pogamut.defcon.communication.messages.commands.SetActionTarget;
import cz.cuni.amis.pogamut.defcon.communication.messages.commands.SetState;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.DefConChanged;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.DefConUnitObject;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.Silo;
import cz.cuni.amis.pogamut.defcon.consts.state.SiloState;
import java.util.List;

public class SiloAI
extends AbstractBuildingAI<Silo> {
    private boolean canLaunch = false;
    private boolean changedToNuke = false;
    private final IWorldEventListener<DefConChanged> defconListener = new IWorldEventListener<DefConChanged>(){

        public void notify(DefConChanged event) {
            if (event.getNewDefCon() == 1) {
                SiloAI.this.canLaunch = true;
            }
        }
    };

    public SiloAI(Silo silo, DefConAgentLogicController<?> logic) {
        super((DefConUnitObject)silo, logic);
        logic.getWorldView().addEventListener(DefConChanged.class, this.defconListener);
    }

    public void update() {
        if (this.canLaunch && (float)this.logic.getGameInfo().getGameTick() > 2500.0f) {
            if (this.hasSpareNukes()) {
                if (this.inNukeState()) {
                    block0: while (this.nukes > 0) {
                        for (List cities : this.logic.getGameInfo().getEnemiesCityIds().values()) {
                            int cityId = (Integer)cities.get(this.logic.getRandom().nextInt(cities.size()));
                            this.launchNuke(this.unitId, cityId);
                            --this.nukes;
                            if (this.nukes != 0) continue;
                            continue block0;
                        }
                    }
                } else {
                    this.toNukeState();
                }
            } else if (this.inNukeState() && ((Silo)this.building).getStateCount() == 0) {
                this.logic.getLog().info("Retuning to air defense: " + this.unitId);
                this.act((DefConCommand)new SetState(this.unitId, SiloState.AIR_DEFENSE.id));
            }
        }
    }

    private boolean inNukeState() {
        return ((Silo)this.building).getState() == SiloState.NUKE;
    }

    private boolean toNukeState() {
        if (this.nukes <= 0 || this.changedToNuke) {
            return false;
        }
        this.changedToNuke = true;
        this.act((DefConCommand)new SetState(this.unitId, SiloState.NUKE.id));
        return true;
    }

    private void launchNuke(int unitId, int targetId) {
        this.act((DefConCommand)new SetActionTarget(unitId, targetId, null));
    }

    public void dispose() {
        super.dispose();
        this.logic.getWorldView().removeListener(this.defconListener);
    }
}

