package cz.cuni.amis.pogamut.jasonBase;

import jason.architecture.AgArch;
import jason.asSyntax.Literal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

import cz.cuni.amis.pogamut.base.communication.messages.InfoMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.component.exception.ComponentCantStartException;
import cz.cuni.amis.pogamut.base.utils.logging.ILogPublisher;
import cz.cuni.amis.pogamut.base.utils.logging.LogFormatter;
import cz.cuni.amis.pogamut.base.utils.logging.LogHandler;
import cz.cuni.amis.pogamut.base.utils.logging.LogPublisher;
import cz.cuni.amis.pogamut.jasonInterface.IPogamutBot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BeginMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;

public abstract class PogamutMainAgArchBase extends AgArch {

	/*
	 * incoming messages from pogamut
	 */
	private List<Literal> messageBuffer = new ArrayList<Literal>();

	private void addMessageToBuffer(InfoMessage message) {
		
		message = beforeAddMessageToBuffer(message);
		if (message == null)
			return;
		if (message instanceof BeginMessage)
			return;

		if (message instanceof EndMessage) {
			LinkedList<Literal> messages = null;
			synchronized (messageBuffer) {
				messages = new LinkedList<Literal>(messageBuffer); // it must be
																	// a copy!
				messageBuffer.clear();
			}
			// on end message copy received messages
			this.addPercept(messages);

			return;
		}

		//Fix some badly generated Literals 
		String messageLiteral = message.toJsonLiteral();
		// message = message.toLowerCase();
		messageLiteral = messageLiteral.substring(0, 1).toLowerCase()
				+ messageLiteral.substring(1);
		if (messageLiteral.contains("( ,")) {
			messageLiteral = messageLiteral.replace("( ,", "(");
		}
		if (messageLiteral.contains("( )")) {
			messageLiteral = messageLiteral.replace("( )", "");
		}
		if (messageLiteral.contains("(null, )")) {
			messageLiteral = messageLiteral.replace("(null, )", "");
		}
		if (messageLiteral.contains("(null, ,")) {
			messageLiteral = messageLiteral.replace("(null, ,", "");
		}
		
		logger.info(messageLiteral);

		messageBuffer.add(Literal.parseLiteral(messageLiteral));
	}
	
	/*
	 * Override this method if you want to change percepts send to Jason
	 */
	public InfoMessage beforeAddMessageToBuffer(InfoMessage message) {
		return message;
		
	}

	private final IWorldEventListener<?> allWorldEventsListener = new IWorldEventListener<IWorldEvent>() {
		@Override
		public void notify(IWorldEvent message) {
			if (message == null || !(message instanceof InfoMessage))
				return;

			addMessageToBuffer((InfoMessage) message);
		}
	};

	private final IWorldObjectEventListener<IWorldObject, IWorldObjectEvent<IWorldObject>> allWorldUpdateEventsListener = new IWorldObjectEventListener<IWorldObject, IWorldObjectEvent<IWorldObject>>() {

		@Override
		public void notify(IWorldObjectEvent<IWorldObject> objectEvent) {
			if (objectEvent == null
					|| !(objectEvent.getObject() instanceof InfoMessage))
				return;

			IWorldObject object = objectEvent.getObject();
			addMessageToBuffer((InfoMessage) object);

		}
	};

	private List<Literal> percepts = Collections
			.synchronizedList(new ArrayList<Literal>());


	protected java.util.logging.Logger logger = Logger.getLogger("Jason");

	public PogamutMainAgArchBase() {

		ILogPublisher publisher = new LogPublisher.FilePublisher(new File(
				"PogamutAgArch.log"), new LogFormatter(true));
		Handler defaultHandler = new LogHandler(publisher);

		logger.addHandler(defaultHandler);
		for (int loggerIndex = 0; loggerIndex < logger.getHandlers().length; loggerIndex++) {
			logger.getHandlers()[loggerIndex].setLevel(Level.ALL);
		}
		// logger.setLevel(Level.ALL);
	}

	public void addPercept(Literal percept) {
		synchronized (this.percepts) {
			this.percepts.add(percept);
		}
	}

	public void addPercept(LinkedList<Literal> percepts) {
		synchronized (this.percepts) {
			this.percepts.addAll(percepts);
		}
	}

	@Override
	public java.util.List<jason.asSyntax.Literal> perceive() {
		LinkedList<Literal> result = null;

		synchronized (percepts) {
			result = new LinkedList<Literal>(percepts); // it must be a copy!
			percepts.clear();
		}
		return result;

	}

	protected IPogamutBot pogamutBot;

	public IPogamutBot getPogamutBot() {
		return pogamutBot;
	}
	
	public void setPogamutBot(IPogamutBot bot)
	{
		pogamutBot = bot;
		pogamutBot.getWorldView().addEventListener(IWorldEvent.class,
				allWorldEventsListener);
		pogamutBot.getWorldView().addObjectListener(IWorldObject.class,
				WorldObjectUpdatedEvent.class, allWorldUpdateEventsListener);
	}
	
	@Override
	public void init() throws Exception {
		super.init();
		boolean successfullyStarted = false;
		for(int attempt = 0;attempt < 20;attempt++){
		    // wrapped logic for bots executions, suitable to run single bot in single JVM
		    try {
		    	startPogamutBot();
		    	successfullyStarted = true;
			} catch (ComponentCantStartException e) {
				logger.severe("Not able to connect to the server: " + e.getMessage());
				try {
					logger.info("Sleep 5 seconds and try to start pogamut bot again. Attempt: " + attempt);
					Thread.sleep(5*1000);
				} catch (InterruptedException e1) {
				}
			} 
		    if(successfullyStarted) break;
    	}
	}

	protected abstract void startPogamutBot();
}
