package cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization.action.trade;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.IDeferredConstructor;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.IDeferredConstructorChainer;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.memorization.ds.FoggyRefMemorization;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.ObservationMemory;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization.item.IItemMemorization;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization.process.AbstractProcessMemorization;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.action.trade.IBartererReplication;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.action.trade.ITradeProcess;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.action.trade.TradeProcessReplication;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItemReplication;

public class TradeProcessMemorization 
	extends AbstractProcessMemorization<TradeProcessReplication>
	implements ITradeProcess {
	
	protected FoggyRefMemorization<IBartererMemorization<IBartererReplication>> barterPartner;
	protected List<IItemMemorization<IItemReplication>> offer;
	protected boolean hasAccepted;
	protected float lastOfferChangeTime;
	
	public TradeProcessMemorization(
		final TradeProcessReplication object,
		final ObservationMemory observationMemory,
		IDeferredConstructorChainer deferredConstructorChainer
	) {
		super( object, observationMemory );
		
		deferredConstructorChainer.addDeferredConstructor( 
			new IDeferredConstructor() {
				@Override
				public void construct() {
					if ( ! object.isBarterPartnerHidden() ) {
						barterPartner = FoggyRefMemorization.make( 
							false, 
							(IBartererMemorization<IBartererReplication>) observationMemory.getMemorization( object.getBarterPartner() ) 
						);
					} else {
						barterPartner = FoggyRefMemorization.make( true, null );
					}
					offer = new LinkedList<IItemMemorization<IItemReplication>>();
					for ( IItemReplication item : object.readOffer() ) {
						offer.add( (IItemMemorization<IItemReplication>) observationMemory.getMemorization( item ) );
					}
					hasAccepted = object.hasAccepted();
					lastOfferChangeTime = object.getLastOfferChangeTime();
				}
			}
		);
	}
	
	@Override
	public boolean isBarterPartnerHidden() {
		return barterPartner.isHidden();
	}
	
	@Override
	public IBartererMemorization<IBartererReplication> getBarterPartner() {
		return barterPartner.get();
	}

	@Override
	public TradeProcessMemorization getBarterPartnerProcess() {
		if ( !isBarterPartnerHidden() && getBarterPartner() != null ) {
			return (TradeProcessMemorization) getBarterPartner().getProcess();
		} else {
			return null;
		}
	}

	@Override
	public boolean isEstablished() {
		return getBarterPartnerProcess() != null;
	}

	@Override
	public boolean hasAccepted() {
		return hasAccepted;
	}
	
	@Override
	public Iterable<? extends IItemMemorization<IItemReplication>> readOffer() {
		return Collections.unmodifiableList( offer );
	}
	
	@Override
	public float getLastOfferChangeTime() {
		return lastOfferChangeTime;
	}
}
