package cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.action.collector;

import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.AbstractActionReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.IActionResultHandler;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.SerializationTools;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.StreamBuffer;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.ICountableItemReplication;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.ISubstanceItemReplication;

/** Split item in inventory
 */
public class SplitItemActionReplication extends AbstractActionReplication {
	
	public static final int ERROR_INVALID_QUANTITY  = 10;
	public static final int ERROR_TARGET_INVALID = 11;
	public static final int ERROR_TARGET_NOT_IN_INVENTORY = 12;
	public static final int ERROR_PERFORMER_NOT_COLLECTOR = 13;
	public static final int ERROR_TARGET_NOT_COUNTABLE = 14;
	public static final int ERROR_TARGET_NOT_SUBSTANCE = 15;
	public static final int ERROR_QUANTITY_OUT_OF_BOUNDS = 16;
	public static final int ERROR_COLLECTOR_DENIED = 17;
	
	/** Constructor
	 */
	public SplitItemActionReplication() {
	}
	
	@Override
	public String getActionName()
	{
		return "Split item";
	}
		
	/** Request split of countable item
	 * 
	 * @param performer action performer
	 * @param item item to split
	 * @param count splinter count
	 * @param resultHandler result handler
	 */
	public void requestSplitCountable( ICollectorReplication performer, ICountableItemReplication item, int count, IActionResultHandler resultHandler )
	{
		StreamBuffer arguments = new StreamBuffer();
		SerializationTools.serializeObjectReferenceOnClient( arguments, item );
		arguments.writeInt( count );
		performer.requestAction(
			this,
			resultHandler,
			arguments
		);
	}
	
	/** Request split of substance item
	 *  
	 * @param performer action performer
	 * @param item item to split
	 * @param amount splinter amount
	 * @param resultHandler result handler
	 */
	public void requestSplitSubstance( ICollectorReplication performer, ISubstanceItemReplication item, float amount, IActionResultHandler resultHandler )
	{
		StreamBuffer arguments = new StreamBuffer();
		SerializationTools.serializeObjectReferenceOnClient( arguments, item );
		arguments.writeFloat( amount );
		performer.requestAction(
			this,
			resultHandler,
			arguments
		);
	}
}