package cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.action.container;

import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.IActionReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.IActionResultHandler;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.SerializationTools;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.StreamBuffer;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.action.collector.ICollectorReplication;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItemReplication;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.container.IContainerReplication;

/** Store item in container action
 */
public class StoreItemInContainerActionReplication extends AbstractContainerActionReplication implements IActionReplication {

	public static final int ERROR_STORED_ITEM_NOT_IN_INVENTORY = 17;
	public static final int ERROR_CONTAINER_DENIED = 18;
	public static final int ERROR_COLLECTOR_DENIED = 19;
	
	/** Constructor
	 */
	public StoreItemInContainerActionReplication() {
	}
	
	@Override
	public String getActionName() {
		return "Store item in container";
	}
	
	/** Request action
	 *  
	 * @param performer action performer
	 * @param container container to store item to
	 * @param storedItem item to store, must be in performer's inventory
	 * @param resultHandler result handler
	 */
	public void request( ICollectorReplication performer, IContainerReplication container, IItemReplication storedItem, IActionResultHandler resultHandler )
	{
		StreamBuffer arguments = new StreamBuffer();
		SerializationTools.serializeObjectReferenceOnClient( arguments, container );
		SerializationTools.serializeObjectReferenceOnClient( arguments, storedItem );
		performer.requestAction(
			this,
			resultHandler,
			arguments
		);
	}
}
