package cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item;


/** Abstract substance item
*
* @author Paletz
*/
abstract public class AbstractSubstanceItem extends AbstractItem implements ISubstanceItemReplication {

	public static final String AMOUNT_ATTR = "amount";
	
	public AbstractSubstanceItem() {
	}
	
	@Override
	public float getAmount() {
		return getAttributes().floats().get(AMOUNT_ATTR);
	}
	
	@Override
	public boolean canMerge( IMergeableItem otherItem ) {
		// class comparison wouldn't handle mixing of torn-off and live objects
		return otherItem.getDisplayName().equals( getDisplayName() );
	}
}
