/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.unreal.timeline;

import cz.cuni.amis.nb.pogamut.unreal.timeline.records.TLFolder;
import cz.cuni.amis.nb.pogamut.unreal.timeline.records.TLProperty;
import cz.cuni.amis.nb.util.NodeFactory;
import cz.cuni.amis.nb.util.collections.ObservableCollectionNode;
import cz.cuni.amis.utils.collections.ObservableCollection;
import cz.cuni.amis.utils.collections.ObservableList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;

class TLFolderNode
extends ObservableCollectionNode<TLFolder> {
    private TLFolder folder;
    private Set<TLProperyAdapter> propertyAdapters = new HashSet<TLProperyAdapter>();

    public TLFolderNode(TLFolder folder) {
        super((ObservableCollection)new ObservableList(new LinkedList()), (NodeFactory)new NodeFactory<TLFolder>(){

            public Node[] create(TLFolder obj) {
                return new Node[]{new TLFolderNode(obj)};
            }
        });
        this.folder = folder;
        this.setDisplayName(folder.getName());
        for (TLFolder subfolder : folder.getSubfolders()) {
            this.getChildrenCollection().add((Object)subfolder);
        }
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set props = sheet.get("properties");
        if (props == null) {
            props = Sheet.createPropertiesSet();
            sheet.put(props);
        }
        for (TLProperty property : this.folder.getProperties()) {
            TLProperyAdapter adapter = new TLProperyAdapter(property);
            props.put((Node.Property)adapter);
            this.propertyAdapters.add(adapter);
        }
        return sheet;
    }

    public void updateToTime(long time) {
        for (TLProperyAdapter propAdapter : this.propertyAdapters) {
            propAdapter.updateToTime(time);
        }
        for (TLProperyAdapter propAdapter : this.propertyAdapters) {
            this.firePropertyChange(propAdapter.getName(), null, propAdapter.getValue());
        }
        for (Node n : this.getChildren().getNodes()) {
            ((TLFolderNode)n).updateToTime(time);
        }
    }

    private static class TLProperyAdapter
    extends PropertySupport.ReadOnly {
        private static String prefix = "TLPROP";
        private static int propertyId = 0;
        private long time = 0L;
        private Object data = null;
        private TLProperty property;

        public TLProperyAdapter(TLProperty property) {
            super(TLProperyAdapter.getNewPropId(property.getName()), property.getType(), property.getName(), "");
            this.property = property;
        }

        public void updateToTime(long time) {
            this.time = time;
            this.data = this.property.getValue(time);
        }

        public Object getValue() {
            return this.data;
        }

        private static String getNewPropId(String suffix) {
            return prefix + "_" + propertyId++ + "_" + suffix;
        }
    }
}

