/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.unreal.timeline.widgets;

import cz.cuni.amis.nb.pogamut.unreal.timeline.records.TLEntity;
import cz.cuni.amis.nb.pogamut.unreal.timeline.records.TLLogRecorder;
import cz.cuni.amis.nb.pogamut.unreal.timeline.widgets.EntityAxisStrip;
import cz.cuni.amis.nb.pogamut.unreal.timeline.widgets.LogCategoryWidget;
import cz.cuni.amis.nb.pogamut.unreal.timeline.widgets.TLScene;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class EntityWidget
extends Widget {
    TLEntity entity;
    EntityAxisStrip stripWidget;
    ArrayList<LogCategoryWidget> logCategoryWidgets = new ArrayList();
    private TLEntity.Listener updateEndTimeListener = new TLEntity.Adapter(){

        @Override
        public void endTimeChanged(TLEntity entity, long previousEndTime, long endTime) {
            assert (SwingUtilities.isEventDispatchThread());
            EntityWidget.this.stripWidget.updateStripRange();
            for (LogCategoryWidget logWidget : EntityWidget.this.logCategoryWidgets) {
                logWidget.updateWidget();
            }
            EntityWidget.this.getScene().validate();
        }
    };
    private TLEntity.Listener addLogRecorderListener = new TLEntity.Adapter(){

        @Override
        public void logRecorderAdded(TLEntity entity, TLLogRecorder recorder) {
            assert (SwingUtilities.isEventDispatchThread());
            EntityWidget.this.addLogCategoryWidget(recorder);
        }
    };

    public EntityWidget(TLScene scene, TLEntity entity) {
        super((Scene)scene);
        this.entity = entity;
        this.setLayout(LayoutFactory.createVerticalFlowLayout());
        this.stripWidget = new EntityAxisStrip(scene, entity);
        this.addChild(this.stripWidget);
        entity.addListener(this.updateEndTimeListener);
        entity.addListener(this.addLogRecorderListener);
        for (TLLogRecorder logRecorder : entity.getLogRecorders()) {
            this.addLogCategoryWidget(logRecorder);
        }
        scene.validate();
    }

    public void addLogCategoryWidget(TLLogRecorder newCategory) {
        assert (SwingUtilities.isEventDispatchThread());
        LogCategoryWidget lcWidget = new LogCategoryWidget((TLScene)this.getScene(), newCategory);
        this.logCategoryWidgets.add(lcWidget);
        this.addChild(lcWidget);
        this.getScene().validate();
    }
}

