/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.unreal.timeline.view;

import cz.cuni.amis.nb.pogamut.unreal.timeline.records.TLDatabase;
import cz.cuni.amis.nb.pogamut.unreal.timeline.records.TLEntity;
import cz.cuni.amis.nb.pogamut.unreal.timeline.view.TLToolbar;
import cz.cuni.amis.nb.pogamut.unreal.timeline.widgets.EntityWidget;
import cz.cuni.amis.nb.pogamut.unreal.timeline.widgets.TLScene;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.openide.awt.UndoRedo;
import org.openide.util.Lookup;

public class MVTimelineElement
extends JScrollPane
implements MultiViewElement {
    private final TLDatabase database;
    private JToolBar toolbar;
    private final TLScene scene;
    private Lookup lookup;
    private final TLDatabase.Adapter dbListener = new TLDatabase.Adapter(){

        @Override
        public void onEntityEntered(TLDatabase db, TLEntity entity) {
            MVTimelineElement.this.scene.addEntityWidget(new EntityWidget(MVTimelineElement.this.scene, entity));
        }

        @Override
        public void endTimeChanged(long previousEndTime, long endTime) {
            MVTimelineElement.this.scene.setTimeAxisLength(MVTimelineElement.this.database.getElapsedTime());
            int panelWidth = MVTimelineElement.this.getWidth();
            JComponent view = MVTimelineElement.this.scene.getView();
            if (view.getWidth() > panelWidth && view.getX() + view.getWidth() - panelWidth < 10) {
                view.setLocation(-(view.getWidth() - panelWidth), view.getY());
            }
        }
    };

    public MVTimelineElement(TLDatabase database, Lookup lookup) {
        this.database = database;
        this.lookup = lookup;
        this.scene = new TLScene(database);
        database.addDBListener(this.dbListener);
        for (TLEntity entity : database.getEntities()) {
            this.scene.addEntityWidget(new EntityWidget(this.scene, entity));
        }
    }

    public JComponent getVisualRepresentation() {
        if (this.scene.getView() == null) {
            this.setViewportView(this.scene.createView());
        }
        return this;
    }

    public JComponent getToolbarRepresentation() {
        if (this.toolbar == null) {
            this.toolbar = new TLToolbar(this.database);
        }
        return this.toolbar;
    }

    public Action[] getActions() {
        return new Action[0];
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    public void componentShowing() {
    }

    public void componentHidden() {
    }

    public void componentActivated() {
    }

    public void componentDeactivated() {
    }

    public UndoRedo getUndoRedo() {
        return UndoRedo.NONE;
    }

    public void setMultiViewCallback(MultiViewElementCallback callback) {
    }

    public CloseOperationState canCloseElement() {
        return CloseOperationState.STATE_OK;
    }
}

