/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.unreal.timeline.widgets;

import cz.cuni.amis.nb.pogamut.unreal.timeline.records.TLEntity;
import cz.cuni.amis.nb.pogamut.unreal.timeline.widgets.StripWidget;
import cz.cuni.amis.nb.pogamut.unreal.timeline.widgets.TLWidget;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public abstract class AxisWidget
extends TLWidget {
    protected int zoom = 100;
    protected final int TEXT_HEIGHT = 15;
    public final int TOP_MARGIN = 0;
    protected LabelWidget nameWidget;
    protected StripWidget stripWidget;
    private int stripHeight;

    AxisWidget(Scene scene, TLEntity entity, String text, int stripHeight, Border border) {
        super(scene, entity);
        this.setLayout(LayoutFactory.createAbsoluteLayout());
        this.stripHeight = stripHeight;
        this.nameWidget = new LabelWidget(scene, text);
        this.addChild((Widget)this.nameWidget);
        this.revalidate();
        this.updateNameLocation();
        this.stripWidget = new StripWidget(scene, entity, border);
        this.addChild(this.stripWidget);
        this.revalidate();
        this.updateStripRange();
    }

    public int getStripHeight() {
        return this.stripHeight;
    }

    protected void updateStripRange() {
        Point location = new Point(this.getStartOffset(), 0);
        Dimension dimension = new Dimension(this.getTimeframeLength(this.getEntityTimeframe()), this.getStripHeight());
        this.stripWidget.setPreferredLocation(location);
        this.stripWidget.setPreferredBounds(new Rectangle(dimension));
    }

    public void updateWidget() {
        this.updateStripRange();
        this.updateNameLocation();
    }

    private void updateNameLocation() {
        this.nameWidget.setVerticalAlignment(LabelWidget.VerticalAlignment.CENTER);
        Dimension bounds = new Dimension(80, 15);
        Point p = new Point(this.getStartOffset() - 80, 0 - (15 - this.getStripHeight()) / 2);
        this.nameWidget.setPreferredLocation(p);
        this.nameWidget.setPreferredBounds(new Rectangle(bounds));
    }

    public TLEntity getEntity() {
        return this.entity;
    }
}

