/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.spyvsspy.mapgenerator;

import cz.cuni.amis.pogamut.spyvsspy.mapgenerator.ButtonDefinition;
import cz.cuni.amis.pogamut.spyvsspy.mapgenerator.Corridor;
import cz.cuni.amis.pogamut.spyvsspy.mapgenerator.Direction;
import java.awt.Point;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class AbstractRandomMapGenerator {
    Map<ButtonLocation, ButtonDefinition> buttonDefinitions;
    int width;
    int height;
    Random rnd;

    public AbstractRandomMapGenerator(long seed, int width, int height) {
        this.width = width;
        this.height = height;
        this.rnd = new Random(seed);
    }

    protected int getMaximumNumberOfButtons() {
        return 2 * ((this.width - 1) * this.height + this.width * (this.height - 1));
    }

    protected Point getRandomPoint() {
        return new Point(this.rnd.nextInt(this.width), this.rnd.nextInt(this.height));
    }

    protected boolean addButtonInteractionToLocation(Point location, Point doorStart, Point doorEnd, boolean open) {
        boolean horizontal;
        ButtonLocation buttonLocation = this.getRandomButtonForLocation(location);
        ButtonDefinition butDef = this.buttonDefinitions.get(buttonLocation);
        if (butDef == null) {
            butDef = new ButtonDefinition(buttonLocation.x, buttonLocation.y, buttonLocation.direction, (Corridor[])null, null);
            this.buttonDefinitions.put(buttonLocation, butDef);
        }
        if (doorStart.x == doorEnd.x) {
            if (Math.abs(doorStart.y - doorEnd.y) != 1) {
                throw new IllegalArgumentException("Start and end are not neighbours");
            }
            horizontal = false;
        } else if (doorStart.y == doorEnd.y) {
            if (Math.abs(doorStart.x - doorEnd.x) != 1) {
                throw new IllegalArgumentException("Start and end are not neighbours");
            }
            horizontal = true;
        } else {
            throw new IllegalArgumentException("Start and end are not neighbours");
        }
        Corridor targetCorridor = new Corridor(Math.min(doorStart.x, doorEnd.x), Math.min(doorStart.y, doorEnd.y), horizontal);
        if (butDef.getOpens().contains(targetCorridor) || butDef.getCloses().contains(targetCorridor)) {
            return false;
        }
        if (open) {
            butDef.addOpen(targetCorridor);
        } else {
            butDef.addClose(targetCorridor);
        }
        return true;
    }

    protected ButtonLocation getRandomButtonForLocation(Point location) {
        Direction dir;
        while (this.isButtonOutOfLevel(location, dir = Direction.values()[this.rnd.nextInt(Direction.values().length)])) {
        }
        return new ButtonLocation(location.x, location.y, dir);
    }

    protected boolean isButtonOutOfLevel(Point location, Direction dir) {
        switch (dir) {
            case EAST: {
                return location.x >= this.width - 1;
            }
            case NORTH: {
                return location.y <= 0;
            }
            case SOUTH: {
                return location.y >= this.height - 1;
            }
            case WEST: {
                return location.x <= 0;
            }
        }
        throw new IllegalStateException("Unrecognized direction");
    }

    protected Set<Point> getNeighbouringPoints(Point point) {
        Point newPoint;
        HashSet<Point> result = new HashSet<Point>();
        if (point.x > 0) {
            newPoint = new Point(point.x - 1, point.y);
            result.add(newPoint);
        }
        if (point.x < this.width - 1) {
            newPoint = new Point(point.x + 1, point.y);
            result.add(newPoint);
        }
        if (point.y > 0) {
            newPoint = new Point(point.x, point.y - 1);
            result.add(newPoint);
        }
        if (point.y < this.height - 1) {
            newPoint = new Point(point.x, point.y + 1);
            result.add(newPoint);
        }
        return result;
    }

    protected class ButtonLocation {
        private int x;
        private int y;
        private Direction direction;

        public ButtonLocation(int x, int y, Direction direction) {
            this.x = x;
            this.y = y;
            this.direction = direction;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ButtonLocation other = (ButtonLocation)obj;
            if (this.x != other.x) {
                return false;
            }
            if (this.y != other.y) {
                return false;
            }
            return this.direction == other.direction;
        }

        public int hashCode() {
            int hash = 7;
            hash = 73 * hash + this.x;
            hash = 73 * hash + this.y;
            hash = 73 * hash + (this.direction != null ? this.direction.hashCode() : 0);
            return hash;
        }
    }
}

