/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.spyvsspy.mapgenerator;

import cz.cuni.amis.pogamut.unreal.t3dgenerator.datatypes.Point3D;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.datatypes.Rotation3D;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.elements.map.PrefabInstance;

public class PrefabDefinition {
    private Point3D prePivot;
    private String prefabName;

    public PrefabDefinition(Point3D prePivot, String prefabName) {
        this.prePivot = prePivot;
        this.prefabName = prefabName;
    }

    public Point3D getPrePivot() {
        return this.prePivot;
    }

    public String getPrefabName() {
        return this.prefabName;
    }

    public Point3D adjustLocation(Point3D location, int yawRotation) {
        int cos;
        int sin;
        int correctedRotation = yawRotation;
        if (correctedRotation < 0) {
            correctedRotation += 65536 * (-correctedRotation / 65536 + 1);
        }
        if (correctedRotation >= 65536) {
            correctedRotation %= 65536;
        }
        if (correctedRotation == 0) {
            sin = 0;
            cos = 1;
        } else if (correctedRotation == 16384) {
            sin = 1;
            cos = 0;
        } else if (correctedRotation == 32768) {
            sin = 0;
            cos = -1;
        } else if (correctedRotation == 49152) {
            sin = -1;
            cos = 0;
        } else {
            throw new IllegalArgumentException("Generator supports only yaw rotation of multiplies of PI/2. Rotation submitted: " + yawRotation + " rotation after correction: " + correctedRotation);
        }
        double deltaX = (float)cos * this.prePivot.getX() + (float)(-sin) * this.prePivot.getY();
        double deltaY = (float)sin * this.prePivot.getX() + (float)cos * this.prePivot.getY();
        Point3D delta = new Point3D((float)deltaX, (float)deltaY, -this.prePivot.getZ());
        return location.add(delta);
    }

    public PrefabInstance createPrefabInstance(Point3D location, Rotation3D rotation) {
        return this.createPrefabInstance(location, rotation, null);
    }

    public PrefabInstance createPrefabInstance(Point3D location, Rotation3D rotation, String name) {
        PrefabInstance prefab = new PrefabInstance(this.getPrefabName(), this.adjustLocation(location, rotation.getYaw()), rotation);
        if (name != null) {
            prefab.setName(name);
        }
        return prefab;
    }
}

