/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.spyvsspy.metadata;

import cz.cuni.amis.pogamut.spyvsspy.metadata.Room;

public class Door {
    private Room from;
    private Room to;

    public Door(Room from, Room to) {
        if (from == null || to == null) {
            throw new NullPointerException("Door locations can't be null");
        }
        this.from = from;
        this.to = to;
    }

    public Room getFrom() {
        return this.from;
    }

    public void setFrom(Room from) {
        this.from = from;
    }

    public Room getTo() {
        return this.to;
    }

    public void setTo(Room to) {
        this.to = to;
    }

    public Door inverted() {
        return new Door(this.to, this.from);
    }

    public boolean isEqualOrInverted(Door other) {
        return this.equals(other) || this.inverted().equals(other);
    }

    public String toString() {
        return "Door{from=" + this.from.getRoomName() + ",to=" + this.to.getRoomName() + '}';
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Door other = (Door)obj;
        if (!(this.from == other.from || this.from != null && this.from.equals(other.from))) {
            return false;
        }
        return this.to == other.to || this.to != null && this.to.equals(other.to);
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.from != null ? this.from.hashCode() : 0);
        hash = 97 * hash + (this.to != null ? this.to.hashCode() : 0);
        return hash;
    }
}

