/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package cz.cuni.amis.pogamut.spyvsspy.mapgenerator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;

/**
 *
 * @author Martin Cerny
 */
public class ButtonDefinition {
    private int locX, locY;
    private Direction direction;

    private List<Corridor> opens;
    private List<Corridor> closes;

    public ButtonDefinition(int locX, int locY, Direction direction, Corridor opens, Corridor closes) {
        this(locX,locY, direction, opens == null ? null : new Corridor[] {opens},closes == null ? null : new Corridor[] {closes});                
    }    
    
    
    public ButtonDefinition(int locX, int locY, Direction direction, Corridor[] opens, Corridor[] closes) {
        this.locX = locX;
        this.locY = locY;
        this.direction = direction;

        if(opens == null){
            this.opens = new ArrayList<Corridor>();
        } else {
            this.opens = new ArrayList<Corridor>(Arrays.asList(opens));
        }

        if(closes == null){
            this.closes = new ArrayList<Corridor>();
        } else {
            this.closes = new ArrayList<Corridor>(Arrays.asList(closes));
        }
    }

    public List<Corridor> getCloses() {
        return closes;
    }

    public Direction getDirection() {
        return direction;
    }

    public int getLocX() {
        return locX;
    }

    public int getLocY() {
        return locY;
    }

    public List<Corridor> getOpens() {
        return opens;
    }

    public void addOpen(Corridor open){
        if(closes.contains(open)){
            throw new IllegalArgumentException("Open - close conflict");
        }
        opens.add(open);                
    }
    
    public void addClose(Corridor close){
        if(opens.contains(close)){
            throw new IllegalArgumentException("Open - close conflict");
        }
        closes.add(close);
    }
    
    /**
     * return the union of opens and closes.
     * @return
     */
    public Collection<Corridor> getAllCorridor(){
        List<Corridor> ret = new ArrayList<Corridor>(opens);
        ret.addAll(closes);
        return ret;
    }

    @Override
    public String toString() {
        return "ButtonDefinition{" + "locX=" + locX + ", locY=" + locY + ", direction=" + direction + ", opens=" + opens + ", closes=" + closes + '}';
    }

    
}
