/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package cz.cuni.amis.pogamut.spyvsspy.mapgenerator;

/**
 *
 * @author Martin Cerny
 */
public class Corridor {
    private int originX, originY;
    private boolean horizontal;

    public Corridor(int originX, int originY, boolean horizontal) {
        this.originX = originX;
        this.originY = originY;
        this.horizontal = horizontal;
    }

    public boolean isHorizontal() {
        return horizontal;
    }

    public int getOriginX() {
        return originX;
    }

    public int getOriginY() {
        return originY;
    }

    public boolean isVertical(){
        return !isHorizontal();
    }

    public int getDestinationX(){
        if(horizontal){
            return originX + 1;
        } else {
            return originX;
        }
    }

    public int getDestinationY(){
        if(horizontal){
            return originY;
        } else {
            return originY + 1;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final Corridor other = (Corridor) obj;
        if (this.originX != other.originX) {
            return false;
        }
        if (this.originY != other.originY) {
            return false;
        }
        if (this.horizontal != other.horizontal) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + this.originX;
        hash = 83 * hash + this.originY;
        hash = 83 * hash + (this.horizontal ? 1 : 0);
        return hash;
    }
    
    
}
