/*
 * Copyright (C) 2011 AMIS research group, Faculty of Mathematics and Physics, Charles University in Prague, Czech Republic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package cz.cuni.amis.pogamut.spyvsspy.mapgenerator;

import cz.cuni.amis.pogamut.unreal.t3dgenerator.elements.kismet.AbstractKismetObject;

/**
 *
 * @author Martin Cerny
 */
public class DoorStateChangedAction extends AbstractKismetObject {
    public static final String CLOSE_LINK = "Close";
    public static final String OPEN_LINK = "Open";
    public static final String OUT_LINK = "Out";

    private String doorFrom;
    private String doorTo;
    
    public DoorStateChangedAction(String doorFrom, String doorTo) {
        super("SeqAction_DoorStateChanged", "GameBotsUDK.Default__SeqAction_DoorStateChanged", new String[] {OPEN_LINK, CLOSE_LINK}, new String[] {OUT_LINK}, new String[] {});
        this.doorFrom = doorFrom;
        this.doorTo = doorTo;
    }

    public String getDoorFrom() {
        return doorFrom;
    }

    public void setDoorFrom(String doorFrom) {
        this.doorFrom = doorFrom;
    }

    public String getDoorTo() {
        return doorTo;
    }

    public void setDoorTo(String doorTo) {
        this.doorTo = doorTo;
    }

    
    
    
}
