/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package cz.cuni.amis.pogamut.spyvsspy.mapgenerator;

import cz.cuni.amis.pogamut.unreal.t3dgenerator.DefaultT3dGenerator;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.IT3dGenerator;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.SequenceNamingFactory;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.T3dElementHelper;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.datatypes.DynamicReference;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.datatypes.KismetLinkTarget;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.datatypes.StaticReference;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.elements.kismet.AbstractKismetObject;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.elements.kismet.DelayAction;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.elements.kismet.FinishSequenceAction;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.elements.kismet.LogAction;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.elements.kismet.Matinee;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.elements.kismet.MatineeData;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.elements.kismet.MatineeMover;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.elements.kismet.ObjectVariable;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.elements.kismet.Sequence;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.elements.kismet.SequenceActivatedEvent;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.elements.kismet.TriggerUsedEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author Martin Cerny
 */
public class KismetGenerator {
    private static final String INTERP_ACTOR = "InterpActor";
    private static final String TRIGGER = "Trigger";

    private SequenceNamingFactory emulatedEditorNameDesignation;

    private String lastDoorName;
    
    private Generator generator;
    
    public KismetGenerator(Generator generator) {
        this.generator = generator;
        emulatedEditorNameDesignation = new SequenceNamingFactory();
    }


    List<AbstractKismetObject> generatedObjects = new ArrayList<AbstractKismetObject>();



    private List<AbstractKismetObject> createButtonHandler(String buttonActorName, String triggerName, String outputLinkName, MatineeData buttonMatineeData, int baseX, int baseY){
        List<AbstractKismetObject> handlerObjects = new ArrayList<AbstractKismetObject>();

        ObjectVariable buttonMoverVar = new ObjectVariable(new StaticReference(INTERP_ACTOR, buttonActorName));
        buttonMoverVar.setPositionForGUI(baseX + 250, baseY + 300);
        handlerObjects.add(buttonMoverVar);

        Matinee matinee = new MatineeMover(buttonMatineeData, buttonMoverVar);
        matinee.setPositionForGUI(baseX + 200, baseY + 100);
        handlerObjects.add(matinee);

        DelayAction delay = new DelayAction(0.5f, Boolean.FALSE);
        delay.setPositionForGUI(baseX + 200, baseY - 50);
        handlerObjects.add(delay);

        TriggerUsedEvent triggerUsedEvent = new TriggerUsedEvent(new StaticReference(TRIGGER, triggerName));
        triggerUsedEvent.setAimToInteract(Boolean.FALSE);
        triggerUsedEvent.setInteractDistance(256.0f);
        triggerUsedEvent.setMaxTriggerCount(0);
        triggerUsedEvent.setPositionForGUI(baseX, baseY);
        handlerObjects.add(triggerUsedEvent);

        FinishSequenceAction finishAction = new FinishSequenceAction(outputLinkName);
        finishAction.setPositionForGUI(baseX + 500, baseY);
        handlerObjects.add(finishAction);

        triggerUsedEvent.addOutputLinkTarget(TriggerUsedEvent.USED_LINK, new KismetLinkTarget(matinee, Matinee.PLAY_LINK));
        matinee.addOutputLinkTarget(Matinee.COMPLETED_LINK, new KismetLinkTarget(delay, DelayAction.START_LINK));
        matinee.addOutputLinkTarget(Matinee.COMPLETED_LINK, new KismetLinkTarget(finishAction, FinishSequenceAction.IN_LINK));
        delay.addOutputLinkTarget(DelayAction.FINISHED_LINK, new KismetLinkTarget(matinee, Matinee.REVERSE_LINK));

        return handlerObjects;
    }

    public Sequence addCorridorSequence(String corridorName, String doorFrom, String doorTo,  int corridorLocX, int corridorLocY){


        lastDoorName = emulatedEditorNameDesignation.getName(INTERP_ACTOR);
        String firstButtonName = emulatedEditorNameDesignation.getName(INTERP_ACTOR);
        String firstTriggerName = corridorName + generator.BUTTON1_TRIGGER_SUFFIX;
        String secondButtonName = emulatedEditorNameDesignation.getName(INTERP_ACTOR);
        String secondTriggerName = corridorName + generator.BUTTON2_TRIGGER_SUFFIX;


        Sequence seq = new Sequence(new String[] {"Open", "Close"}, new String[] {"Button1", "Button2"}, new String[]{});
        seq.setName(corridorName + "_sequence");
        seq.getOutputLink("Button1").setDrawY(0);
        seq.getOutputLink("Button2").setDrawY(32);


        /*Input part of sequence - sending external events to door mover*/
        MatineeData doorMovementMatineeData = new DoorMatineeData();
        doorMovementMatineeData.setPositionForGUI(200, 200);
        ObjectVariable doorVariable = new ObjectVariable(new StaticReference( INTERP_ACTOR, lastDoorName));
        doorVariable.setPositionForGUI(250, 200);
        Matinee doorMatinee = new MatineeMover(doorMovementMatineeData, doorVariable);
        doorMatinee.setPositionForGUI(200, 0);
        seq.addSequenceObject(doorMovementMatineeData);
        seq.addSequenceObject(doorVariable);
        seq.addSequenceObject(doorMatinee);

        SequenceActivatedEvent openEvent = new SequenceActivatedEvent("Open");
        KismetLinkTarget openDoorLinkTarget = new KismetLinkTarget(doorMatinee, Matinee.PLAY_LINK);
        openEvent.addOutputLinkTarget("Out", openDoorLinkTarget);
        openEvent.setPositionForGUI(-300, 0);
        seq.addSequenceObject(openEvent);

        SequenceActivatedEvent closeEvent = new SequenceActivatedEvent("Close");
        KismetLinkTarget closeDoorLinkTarget = new KismetLinkTarget(doorMatinee, Matinee.REVERSE_LINK);
        closeEvent.addOutputLinkTarget("Out", closeDoorLinkTarget);
        closeEvent.setPositionForGUI(-300, 200);
        seq.addSequenceObject(closeEvent);
        
        ExternalDoorStateChangedEvent externalDoorEvent = new ExternalDoorStateChangedEvent(doorFrom, doorTo);
        externalDoorEvent.addOutputLinkTarget(ExternalDoorStateChangedEvent.OPEN_LINK, openDoorLinkTarget);
        externalDoorEvent.addOutputLinkTarget(ExternalDoorStateChangedEvent.CLOSE_LINK, closeDoorLinkTarget);
        externalDoorEvent.setPositionForGUI(-80, 0);
        seq.addSequenceObject(externalDoorEvent);
      
        DoorStateChangedAction doorStateChanged = new DoorStateChangedAction(doorFrom,doorTo);
        doorMatinee.addOutputLinkTarget(Matinee.COMPLETED_LINK, new KismetLinkTarget(doorStateChanged, DoorStateChangedAction.OPEN_LINK));
        doorMatinee.addOutputLinkTarget(Matinee.REVERSED_LINK, new KismetLinkTarget(doorStateChanged, DoorStateChangedAction.CLOSE_LINK));
        doorStateChanged.setPositionForGUI(430, 0);
        seq.addSequenceObject(doorStateChanged);
        

        //Button handling
        MatineeData buttonMatineeData = new ButtonMatineeData();
        buttonMatineeData.setPositionForGUI(700, 250);
        seq.addSequenceObject(buttonMatineeData);

        seq.addSequenceObjects(createButtonHandler(firstButtonName, firstTriggerName, "Button1", buttonMatineeData, 700, 0));
        seq.addSequenceObjects(createButtonHandler(secondButtonName, secondTriggerName, "Button2", buttonMatineeData, 700, 500));

        seq.setObjComment(corridorName);
        int gridSize = 128;
        seq.setPositionForGUI(gridSize * corridorLocX, gridSize * corridorLocY);
        generatedObjects.add(seq);
        return seq;
    }

    public void saveToFile(File file){
        try {
            OutputStreamWriter out = new FileWriter(file);
            IT3dGenerator gen = new DefaultT3dGenerator();
            gen.generateT3d(generatedObjects, out);
            out.close();
        } catch (IOException e) {
            e.printStackTrace();
        }

    }

    /**
     * Gets the name for referencing of the last door actor that was created.
     * @return 
     */
    public String getLastDoorName() {
        return lastDoorName;
    }
    
    
}
