/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package cz.cuni.amis.pogamut.spyvsspy.metadata;

import java.util.List;

/**
 *
 * @author Martin Cerny
 */
public class Button {

    private String navPointName;

    private Room room;
    private List<Door> opens;
    private List<Door> closes;
    private String triggerName;

    public Button() {
    	
    }
    
    public Button(String navPointName, Room room, List<Door> opens, List<Door> closes, String triggerName) {
        this.navPointName = navPointName;
        this.room = room;
        this.opens = opens;
        this.closes = closes;
        this.triggerName = triggerName;
    }
    
    
    public String getNavPointName() {
        return navPointName;
    }

    public List<Door> getCloses() {
        return closes;
    }

    public List<Door> getOpens() {
        return opens;
    }

    public Room getRoom() {
        return room;
    }

    public String getTriggerName() {
        return triggerName;
    }

    
    
    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final Button other = (Button) obj;
        if ((this.navPointName == null) ? (other.navPointName != null) : !this.navPointName.equals(other.navPointName)) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + (this.navPointName != null ? this.navPointName.hashCode() : 0);
        return hash;
    }

    


    
}
