/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package cz.cuni.amis.pogamut.spyvsspy.metadata;

/**
 *
 * @author Martin Cerny
 */
public class Door {
    /**
     * cannot be null
     */
    private Room from;
    
    /**
     * cannot be null
     */
    private Room to;

    public Door() {
    	
    }

    /**
     * 
     * @param from
     * @param to 
     * @throws NullPointerException if either of the arguments is null
     */
    public Door(Room from, Room to) {
        if(from == null || to == null){
            throw new NullPointerException("Door locations can't be null");
        }
        this.from = from;
        this.to = to;
    }

    public Room getFrom() {
        return from;
    }

    public void setFrom(Room from) {
        this.from = from;
    }

    public Room getTo() {
        return to;
    }

    public void setTo(Room to) {
        this.to = to;
    }
    
    public Door inverted(){
        return new Door(to, from);
    }

    /**
     * Checks whether this door is same as another or symmetric to another
     * @param other
     * @return 
     */
    public boolean isEqualOrInverted(Door other){
        return this.equals(other) || this.inverted().equals(other);
    }
    
    @Override
    public String toString() {
        return "Door{" + "from=" + from.getRoomName() + ",to=" + to.getRoomName() + '}';
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final Door other = (Door) obj;
        if (this.from != other.from && (this.from == null || !this.from.equals(other.from))) {
            return false;
        }
        if (this.to != other.to && (this.to == null || !this.to.equals(other.to))) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.from != null ? this.from.hashCode() : 0);
        hash = 97 * hash + (this.to != null ? this.to.hashCode() : 0);
        return hash;
    }

    

}
