/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.process;

import cz.cuni.amis.utils.StreamSink;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.exception.PogamutIOException;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.ImmutableFlag;
import cz.cuni.amis.utils.process.ProcessExecutionConfig;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProcessExecution {
    protected ProcessExecutionConfig config;
    protected Flag<Boolean> running = new Flag((Object)false);
    protected Process process = null;
    protected StreamSink streamSinkOutput = null;
    protected StreamSink streamSinkError = null;
    protected Logger log;
    protected Runnable shutDownHook = new Runnable(){

        @Override
        public void run() {
            if (ProcessExecution.this.process != null) {
                ProcessExecution.this.process.destroy();
            }
        }
    };
    protected Thread shutDownHookThread;
    protected Runnable waitForEnd = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block41: {
                block39: {
                    start = System.currentTimeMillis();
                    timeout = ProcessExecution.this.config.getTimeout() == null ? -1L : ProcessExecution.this.config.getTimeout();
                    try {
                        if (timeout > 0L) {
                            terminated = false;
                            while (System.currentTimeMillis() - start < timeout) {
                                try {
                                    ProcessExecution.this.process.exitValue();
                                    terminated = true;
                                }
                                catch (Exception e) {
                                    terminated = false;
                                }
                                if (terminated) break;
                                waitMillis = Math.min(500L, 100L + timeout - (System.currentTimeMillis() - start));
                                Thread.sleep(waitMillis);
                            }
                            if (terminated) break block39;
                            var6_7 = ProcessExecution.this.running;
                            synchronized (var6_7) {
                                if (ProcessExecution.this.waitForEndThread == Thread.currentThread()) {
                                    if (ProcessExecution.this.log != null && ProcessExecution.this.log.isLoggable(Level.SEVERE)) {
                                        ProcessExecution.this.log.severe("Process(" + ProcessExecution.this.config.getId() + ") TIMEOUT!");
                                    }
                                    ProcessExecution.this.shutdown(true);
                                }
                                break block39;
                            }
                        }
                        ProcessExecution.this.process.waitFor();
                    }
                    catch (InterruptedException e) {
                        var6_8 = ProcessExecution.this.running;
                        synchronized (var6_8) {
                            if (((Boolean)ProcessExecution.this.running.getFlag()).booleanValue()) ** break block40
                            // MONITOREXIT @DISABLED, blocks:[0, 19, 4, 12] lbl41 : MonitorExitStatement: MONITOREXIT : var6_8
                            var9_9 = ProcessExecution.this.running;
                        }
                        synchronized (var9_9) {
                            if (!((Boolean)ProcessExecution.this.running.getFlag()).booleanValue()) {
                                return;
                            }
                            if (ProcessExecution.this.waitForEndThread == Thread.currentThread()) {
                                ProcessExecution.this.shutdown(true);
                            }
                        }
                        return;
                        {
                            // MONITOREXIT @DISABLED, blocks:[0, 19, 6, 7, 12] lbl58 : MonitorExitStatement: MONITOREXIT : var6_8
                            if (ProcessExecution.this.log != null && ProcessExecution.this.log.isLoggable(Level.WARNING)) {
                                ProcessExecution.this.log.warning("Interrupted while waiting for the processProcess(" + ProcessExecution.this.config.getId() + ") to end!");
                            }
                            var9_10 = ProcessExecution.this.running;
                        }
                        synchronized (var9_10) {
                            if (!((Boolean)ProcessExecution.this.running.getFlag()).booleanValue()) {
                                return;
                            }
                            if (ProcessExecution.this.waitForEndThread == Thread.currentThread()) {
                                ProcessExecution.this.shutdown(true);
                            }
                            break block41;
                        }
                        {
                            catch (Throwable var8_13) {
                                var9_11 = ProcessExecution.this.running;
                                synchronized (var9_11) {
                                    if (!((Boolean)ProcessExecution.this.running.getFlag()).booleanValue()) {
                                        return;
                                    }
                                    if (ProcessExecution.this.waitForEndThread == Thread.currentThread()) {
                                        ProcessExecution.this.shutdown(true);
                                    }
                                }
                                throw var8_13;
                            }
                        }
                    }
                }
                var9_12 = ProcessExecution.this.running;
                synchronized (var9_12) {
                    if (!((Boolean)ProcessExecution.this.running.getFlag()).booleanValue()) {
                        return;
                    }
                    if (ProcessExecution.this.waitForEndThread == Thread.currentThread()) {
                        ProcessExecution.this.shutdown(true);
                    }
                }
            }
        }
    };
    protected Thread waitForEndThread;

    public ProcessExecution(ProcessExecutionConfig config, Logger log) {
        this.log = log;
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String host, int port) throws PogamutIOException {
        Flag<Boolean> flag = this.running;
        synchronized (flag) {
            if (((Boolean)this.running.getFlag()).booleanValue()) {
                throw new PogamutException("Could not start the process again, it is already running! stop() it first!", this.log, (Object)this);
            }
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("Starting process: " + this.config);
            }
            if (this.config.getPathToProgram() == null) {
                throw new PogamutException("Could not start the process according to config " + this.config + " as the path to program was not specified (is null).", (Object)this);
            }
            String javaHome = System.getProperty("JAVA_HOME");
            boolean linux = System.getProperty("os.name").toLowerCase().contains("linux");
            String command = this.config.getPathToProgram().getAbsolutePath();
            ArrayList<String> commandParts = new ArrayList<String>();
            commandParts.add(command);
            String fullCommand = command;
            if (this.config.getArgs() != null) {
                for (String arg : this.config.getArgs()) {
                    fullCommand = String.valueOf(fullCommand) + " " + arg;
                    commandParts.add(arg);
                }
            }
            File directory = this.config.getExecutionDir() != null ? this.config.getExecutionDir() : (this.config.getPathToProgram().getParentFile() != null ? this.config.getPathToProgram().getParentFile() : new File("."));
            if (this.log != null && this.log.isLoggable(Level.INFO)) {
                this.log.info("Executing command: " + fullCommand);
                this.log.info("From directory:    " + directory.getAbsolutePath());
            }
            ProcessBuilder procBuilder = new ProcessBuilder(commandParts.toArray(new String[commandParts.size()]));
            procBuilder.directory(directory);
            try {
                this.process = procBuilder.start();
            }
            catch (IOException e) {
                if (this.log != null && this.log.isLoggable(Level.SEVERE)) {
                    this.log.severe("Could not start the process: " + e.getMessage());
                }
                this.process = null;
                throw new PogamutIOException("Failed to start the processProcess(" + this.config.getId() + "). IOException: " + e.getMessage(), (Throwable)e, (Object)this);
            }
            this.streamSinkError = this.config.isRedirectStdErr() ? new StreamSink(String.valueOf(this.config.getId()) + "-StdErrSink", this.process.getErrorStream(), this.log, String.valueOf(this.config.getId()) + "-StdErr") : new StreamSink(String.valueOf(this.config.getId()) + "-StdErrSink", this.process.getErrorStream());
            this.streamSinkError.start();
            this.streamSinkOutput = this.config.isRedirectStdOut() ? new StreamSink(String.valueOf(this.config.getId()) + "-StdOutSink", this.process.getInputStream(), this.log, String.valueOf(this.config.getId()) + "-StdOut") : new StreamSink(String.valueOf(this.config.getId()) + "-StdOutSink", this.process.getInputStream());
            this.streamSinkOutput.start();
            this.shutDownHookThread = new Thread(this.shutDownHook, String.valueOf(this.config.getId()) + "-JVMShutdownHook");
            Runtime.getRuntime().addShutdownHook(this.shutDownHookThread);
            this.waitForEndThread = new Thread(this.waitForEnd, String.valueOf(this.config.getId()) + "-WaitForProcessEnd");
            this.running.setFlag((Object)true);
            this.waitForEndThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown(boolean waitForEndThread) {
        Flag<Boolean> flag = this.running;
        synchronized (flag) {
            if (!((Boolean)this.running.getFlag()).booleanValue()) {
                return;
            }
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("Shutting down processProcess(" + this.config.getId() + ")!");
            }
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("... destroying processProcess(" + this.config.getId() + ").");
            }
            if (this.process != null) {
                try {
                    this.process.destroy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.process = null;
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("... destroying streamSinkError(" + this.config.getId() + ").");
            }
            try {
                if (this.streamSinkError != null) {
                    this.streamSinkError.interrupt();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.streamSinkError = null;
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("... destroying streamSinkOutput(" + this.config.getId() + ").");
            }
            try {
                if (this.streamSinkOutput != null) {
                    this.streamSinkOutput.interrupt();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.streamSinkOutput = null;
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("... destroying waitForEnd(" + this.config.getId() + ").");
            }
            if (!waitForEndThread) {
                try {
                    if (this.waitForEndThread != null) {
                        this.waitForEndThread.interrupt();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.waitForEndThread = null;
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("... removing shutDownHook(" + this.config.getId() + ").");
            }
            if (this.shutDownHookThread != null) {
                try {
                    Runtime.getRuntime().removeShutdownHook(this.shutDownHookThread);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.shutDownHookThread = null;
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("... setting running-flag(" + this.config.getId() + ") to FALSE.");
            }
            this.running.setFlag((Object)false);
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("Shutdown(" + this.config.getId() + ") finished.");
            }
        }
    }

    public void stop() {
        this.shutdown(false);
    }

    public Process getBotProcess() {
        return this.process;
    }

    public ImmutableFlag<Boolean> getRunning() {
        return this.running.getImmutable();
    }

    public boolean isRunning() {
        return (Boolean)this.running.getFlag();
    }
}

