/*
 * Decompiled with CFR 0.152.
 */
package cz.dd4j.agents.heroes.pddl;

import cz.dd4j.agents.heroes.pddl.PDDLAgentBase;
import cz.dd4j.agents.heroes.planners.NPlanCygwinExecutor;
import cz.dd4j.utils.config.AutoConfig;
import cz.dd4j.utils.config.Configurable;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

@AutoConfig
public class NPlanCygwinAgent
extends PDDLAgentBase {
    @Configurable
    protected File nplanFolder = new File("./nplan");
    @Configurable
    protected String nplanBatchFile = "nplan.bat";
    protected File nplanWorkingDir;

    @Override
    public void prepareAgent() {
        super.prepareAgent();
        this.executor = new NPlanCygwinExecutor();
        this.executor.prepareEnvironment(this.agentWorkingDir);
        this.inputGenerator.setPddlNewLine(this.executor.getPddlNewLine());
        this.problemFile = this.getWorkingFile("nplan/problem.pddl");
        this.nplanWorkingDir = this.getWorkingFile("nplan");
        this.nplanWorkingDir.mkdirs();
        this.nplanWorkingDir.deleteOnExit();
        this.copyNPlanFolder(this.nplanFolder, this.nplanWorkingDir);
        File nplanDomainFile = this.getWorkingFile("nplan/domain.pddl");
        try {
            FileUtils.copyFile((File)this.domainFile, (File)nplanDomainFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to copy domain file from '" + this.domainFile.getAbsolutePath() + "' into '" + nplanDomainFile.getAbsolutePath() + "'.", e);
        }
    }

    private void copyNPlanFolder(File nplanFolder, File nplanWorkingDir) {
        try {
            File[] fileArray = nplanFolder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile()) {
                    FileUtils.copyFileToDirectory((File)file, (File)nplanWorkingDir);
                } else if (file.isDirectory()) {
                    FileUtils.copyDirectoryToDirectory((File)file, (File)nplanWorkingDir);
                }
                ++n2;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to copy directory '" + nplanFolder.getAbsolutePath() + "' into '" + nplanWorkingDir.getAbsolutePath() + "'.", e);
        }
    }

    @Override
    public void simulationEnded() {
        super.simulationEnded();
        FileUtils.deleteQuietly((File)this.nplanWorkingDir);
    }
}

