/*
 * Decompiled with CFR 0.152.
 */
package cz.dd4j.agents.heroes.planners;

import cz.dd4j.agents.heroes.pddl.PDDLAction;
import cz.dd4j.agents.heroes.planners.AbstractPlannerExecutor;
import cz.dd4j.utils.config.AutoConfig;
import cz.dd4j.utils.config.Configurable;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.io.FileUtils;

@AutoConfig
public class LamaDockerExecutor
extends AbstractPlannerExecutor {
    @Configurable
    protected File fdDir = new File("./fast-downward/");
    protected File agentWorkingDir;
    protected File lamaWorkingDir;

    @Override
    public String getPddlNewLine() {
        return "\n";
    }

    @Override
    public List<PDDLAction> execPlanner(File domainFile, File problemFile) throws IOException {
        File resultFile = new File(this.lamaWorkingDir, "plan.sol");
        FileUtils.copyFile((File)domainFile, (File)new File(this.lamaWorkingDir, "domain.pddl"));
        FileUtils.copyFile((File)problemFile, (File)new File(this.lamaWorkingDir, "problem.pddl"));
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("workingDir", this.lamaWorkingDir.getCanonicalPath());
        config.put("domain", "domain.pddl");
        config.put("problem", "problem.pddl");
        config.put("result", "plan.sol");
        CommandLine commandLine = new CommandLine("docker");
        commandLine.addArgument("run");
        commandLine.addArgument("-v");
        commandLine.addArgument("${workingDir}:/data");
        commandLine.addArgument("--rm");
        commandLine.addArgument("lama");
        commandLine.addArgument("${domain}");
        commandLine.addArgument("${problem}");
        commandLine.addArgument("plan.sol");
        commandLine.setSubstitutionMap(config);
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWorkingDirectory(this.lamaWorkingDir);
        executor.setExitValue(0);
        try {
            executor.execute(commandLine);
        }
        catch (ExecuteException e) {
            return null;
        }
        if (!resultFile.exists()) {
            System.out.println("plan not found");
            return null;
        }
        String resultLines = FileUtils.readFileToString((File)resultFile);
        String[] lines = resultLines.split("[\n\r]+");
        StringBuilder resLines = new StringBuilder();
        int i = 0;
        while (i < lines.length) {
            if (!lines[i].contains(";")) {
                resLines.append(i).append(" : ").append(lines[i]).append("\n");
            }
            ++i;
        }
        resultLines = resLines.toString();
        resultLines = resultLines.replaceAll("move[12]", "move");
        System.out.println("PLAN");
        System.out.println(resultLines);
        FileUtils.deleteQuietly((File)new File(this.lamaWorkingDir, "output.sas"));
        resultFile.delete();
        return this.parseLines(resultLines);
    }

    @Override
    public void prepareEnvironment(File agentWorkingDir) {
        this.agentWorkingDir = agentWorkingDir;
        this.lamaWorkingDir = new File(this.agentWorkingDir, "fd");
        this.lamaWorkingDir.mkdirs();
    }
}

