/*
 * Decompiled with CFR 0.152.
 */
package cz.dd4j.agents.heroes.planners;

import cz.dd4j.agents.heroes.pddl.PDDLAction;
import cz.dd4j.agents.heroes.planners.AbstractPlannerExecutor;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.io.FileUtils;

public class NPlanDockerExecutor
extends AbstractPlannerExecutor {
    File nplanWorkingDir;

    @Override
    public List<PDDLAction> execPlanner(File domainFile, File problemFile) throws IOException {
        FileUtils.copyFile((File)domainFile, (File)new File(this.nplanWorkingDir, "domain.pddl"));
        FileUtils.copyFile((File)problemFile, (File)new File(this.nplanWorkingDir, "problem.pddl"));
        File resultFile = new File(this.nplanWorkingDir, "plan.SOL");
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("workingDir", this.nplanWorkingDir.getAbsolutePath());
        config.put("domainFile", "domain.pddl");
        config.put("problemFile", "problem.pddl");
        CommandLine commandLine = new CommandLine("docker");
        commandLine.addArgument("run");
        commandLine.addArgument("-v");
        commandLine.addArgument("${workingDir}:/data");
        commandLine.addArgument("--rm");
        commandLine.addArgument("nplan");
        commandLine.addArgument("${domainFile}");
        commandLine.addArgument("${problemFile}");
        commandLine.addArgument("-o");
        commandLine.addArgument("plan.SOL");
        commandLine.addArgument("-Q");
        commandLine.setSubstitutionMap(config);
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWorkingDirectory(this.nplanWorkingDir);
        executor.setExitValue(0);
        executor.execute(commandLine);
        if (!resultFile.exists()) {
            return null;
        }
        String resultLines = FileUtils.readFileToString((File)resultFile);
        resultFile.delete();
        return this.parseLines(resultLines);
    }

    @Override
    public void prepareEnvironment(File agentWorkingDir) {
        this.nplanWorkingDir = new File(agentWorkingDir, "nplan");
        this.nplanWorkingDir.mkdirs();
    }
}

